/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.doorman.main;

import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.lsst.ccs.ComponentConfigurationEnvironment;
import org.lsst.ccs.UsesSubsystem;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.doorman.main.ConfigurationService;
import org.lsst.ccs.subsystem.doorman.main.InstrumentConfig;
import org.lsst.ccs.subsystem.doorman.main.InstrumentStatus;
import org.lsst.ccs.subsystem.doorman.main.InstrumentType;

public class CCSConfiguration
implements HasLifecycle,
UsesSubsystem,
ConfigurationService {
    private volatile Duration readoutInterval;
    private volatile List<InstrumentConfig> instConfigs;
    private ComponentConfigurationEnvironment configEnv = null;
    @ConfigurationParameter(name="readoutInterval", description="The time between readouts.")
    private volatile String readoutIntervalString = "PT1H";
    @ConfigurationParameter(description="Instrument make and/or model.")
    private volatile String[] instrumentTypes = new String[0];
    @ConfigurationParameter(description="Connection info for the instrument.")
    private volatile String[] instrumentConnections = new String[0];
    @ConfigurationParameter(description="The Instant of the lastest data read from the instrument.")
    private volatile String[] instrumentLastDataTimes = new String[0];
    @ConfigurationParameter(description="The name or IPv4 address of the SMTP server.")
    private volatile String SMTPServer = "";
    @ConfigurationParameter(description="Email address, possibly fake, used as email sender.")
    private volatile String emailSender = "";
    @ConfigurationParameter(description="Real email address which receives bounced messages.")
    private volatile String emailBounceTo = "";
    @ConfigurationParameter(description="List of recipients of alarm emails.")
    private volatile String[] emailRecipients = new String[0];

    @Override
    public List<InstrumentConfig> getInstrumentConfigs() {
        return this.instConfigs;
    }

    @Override
    public void updateInstrument(InstrumentStatus stat) {
        String[] newTimes = Arrays.copyOf(this.instrumentLastDataTimes, this.instrumentLastDataTimes.length);
        newTimes[stat.index] = stat.lastDataTime.toString();
        this.instrumentLastDataTimes = newTimes;
        this.configEnv.change("instrumentLastDataTimes", (Object)this.instrumentLastDataTimes);
        this.configEnv.saveAllChanges();
    }

    @Override
    public Duration getReadoutInterval() {
        return this.readoutInterval;
    }

    @Override
    public String getEmailSender() {
        return this.emailSender;
    }

    @Override
    public String getEmailBounceAddress() {
        return this.emailBounceTo;
    }

    @Override
    public String getSMTPServer() {
        return this.SMTPServer;
    }

    @Override
    public List<String> getEmailRecipients() {
        return Collections.unmodifiableList(Arrays.asList(this.emailRecipients));
    }

    public void start() {
        this.configEnv = this.getComponentConfigurationEnvironment();
        this.configEnv.printConfigurableParameters(new String[0]).forEach((key, value) -> System.out.println(key + " :: " + value));
        try {
            this.readoutInterval = Duration.parse(this.readoutIntervalString);
        }
        catch (DateTimeException exc) {
            throw new IllegalArgumentException("Bad configuration. Invalid readout interval.");
        }
        System.out.println(this.readoutInterval);
        this.makeInstrumentConfigs();
    }

    private void makeInstrumentConfigs() {
        String[] types = this.instrumentTypes;
        String[] conns = this.instrumentConnections;
        String[] times = this.instrumentLastDataTimes;
        if (types.length != conns.length || types.length != times.length) {
            throw new IllegalArgumentException("Bad configuration. Not all the instrumentXxx[] arrays are the same length.");
        }
        if (types.length == 0) {
            throw new IllegalArgumentException("Bad configuration. No instruments defined!");
        }
        CCSConfiguration.checkStringSet(Stream.of(types), Stream.of(InstrumentType.values()).map(InstrumentType::getConfigName), "Unknown instrument types");
        CCSConfiguration.checkStringSet(Stream.of(times), Stream.of(times).filter(t -> {
            try {
                Instant.parse(t);
                return true;
            }
            catch (DateTimeParseException exc) {
                return false;
            }
        }), "Last data-times rejected by Instant.parse()");
        this.instConfigs = Collections.unmodifiableList(IntStream.range(0, types.length).mapToObj(i -> new InstrumentConfig(i, InstrumentType.parse(types[i]).get(), conns[i], Instant.parse(times[i]))).collect(Collectors.toList()));
    }

    private static void checkStringSet(Stream<String> mentioned, Stream<String> legal, String errorMsg) {
        Set unknown = mentioned.collect(Collectors.toSet());
        unknown.removeAll(legal.collect(Collectors.toSet()));
        if (unknown.size() > 0) {
            throw new IllegalArgumentException("Bad configuration. " + errorMsg + ": " + unknown.stream().collect(Collectors.joining(", ")));
        }
    }
}

