/**
 * The main package for the AirWatch subsystem.
 * <p>
 * At subsystem start-up a periodic task is started to read the particle-counter instruments
 * with at regular intervals (fixed period) and send the data to the trending subsystem. Only
 * new data, accumulated since the last time data was read, is posted for each instrument.
 * <p>
 * A stop command will have no effect on a readout in progress but will cancel any further
 * readouts.
 * <p>
 * A shutdown command will fail unless a stop command has been executed. If you need
 * to cut short a currently active readout then use an abort command in between the
 * stop and shutdown commands.
 * <p>
 * An abort command will interrupt a readout in progress. Subsequent readouts will still occur
 * if they are scheduled. An abort is a no-op if no readout is in progress. When a readout is
 * interrupted a given instrument will either have had its new data sent to trending and its
 * last-data-time updated, or neither.
 * <p>
 * Query commands will execute without delay, though they might not show concurrent changes
 * in instrument state being made by action commands or the readout task.
 * <p>
 * Action commands that mutate instrument state will be rejected if a readout is in
 * progress, otherwise they'll run without delay. Readout may take several minutes so
 * it seems better to reject conflicting commands right away so that the operators can
 * abort the current readout if they want.
 * <p>
 * If the readout task encounters an instrument I/O error it will raise an alert of severity
 * WARNING whose ID is "InstrumentIO".
 * The cause string will be the instrument location plus the message from the HardwareException
 * that was thrown as a result of the problem. Any further readout of the affected instrument
 * will be disabled until re-enabled by command. Before clearing the alert the operators
 * may attempt to re-enable the instrument or decide to leave it disabled. In either case
 * the alert may be cleared without further checks by the subsystem.
 * 
 * <dl>
 * <dt><span class="strong">Lighthouse instruments</span></dt>
 * <dd>The instrument contains a table of location names which should be the same
 * as the list of known locations obtained from the subsystem configuration. That way
 * changing the instrument's current location can be done just by writing the index
 * number + 1 to the current-location register.
 * <p>
 * Those Lighthouse models with touch screens allow only uppercase letters
 * to be entered for location names, so case is ignored when comparing
 * the names with configured location names.
 * <p>
 * The enable and read operations sync the instrument clock with that of the computer.
 * </dd>
 * </dl>
 */
package org.lsst.ccs.subsystem.doorman.main;
