/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import java.util.LinkedHashMap;
import java.util.Map;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNodeBuilder;
import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.startup.NodeModularSubsystem;

public class BootUtils {
    private BootUtils() {
    }

    public static Subsystem getSubsystemFromFile(String descriptionName) throws Exception {
        return BootUtils.getSubsystemFromFile(descriptionName, null);
    }

    public static Subsystem getSubsystemFromFile(String descriptionName, String configName) throws Exception {
        return BootUtils.getSubsystemFromFile(descriptionName, configName, null);
    }

    public static Subsystem getSubsystemFromFile(String pathName, String propertiesFileName, String subsystemAlias) throws Exception {
        return new LocalBootObject(pathName, propertiesFileName, subsystemAlias).getSubsystem();
    }

    public static void main(String[] argv) throws Exception {
        String descriptionName = argv[0];
        ComponentLookup lookup = ComponentNodeBuilder.buildComponentNode((String)descriptionName);
        String topName = lookup.getTopComponentNode().getKey();
        LinkedHashMap map = lookup.getChildren(topName, null);
        System.out.println("Build object tree: " + topName);
        for (Map.Entry entry : map.entrySet()) {
            System.out.println("--> " + (String)entry.getKey() + "        \t" + entry.getValue().getClass());
        }
    }

    private static class LocalBootObject {
        private final NodeModularSubsystem subsystem;

        LocalBootObject(String pathName) throws Exception {
            this(pathName, "");
        }

        LocalBootObject(String fullDescription, String config) throws Exception {
            this(fullDescription, config, null);
        }

        LocalBootObject(String fullDescription, String config, String subsystemAlias) throws Exception {
            if (config != null) {
                if (config.contains("/")) {
                    throw new IllegalArgumentException("configuration files must be located at the root of a resource directory");
                }
                if (config.contains(".")) {
                    throw new IllegalArgumentException("configuration input must be the name of the configuration only");
                }
            }
            ComponentLookup lookup = ComponentNodeBuilder.buildComponentNode((String)fullDescription);
            String subsystemName = subsystemAlias == null ? CCSBuilder.getSubsystemName() : subsystemAlias;
            String[] taggedCategories = config == null ? null : config.split(",");
            String tagName = fullDescription;
            if (fullDescription.contains(":")) {
                tagName = fullDescription.substring(fullDescription.indexOf(58) + 1);
            }
            this.subsystem = new NodeModularSubsystem(subsystemName, lookup, tagName, taggedCategories);
        }

        private Subsystem getSubsystem() throws Exception {
            return this.subsystem;
        }
    }
}

