/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.doorman.main;

import java.time.Instant;
import org.lsst.ccs.subsystem.doorman.main.ChilledDoor;
import org.lsst.ccs.subsystem.doorman.main.Instrument;
import org.lsst.ccs.subsystem.doorman.main.InstrumentConfig;
import org.lsst.ccs.subsystem.doorman.main.InstrumentType;

public class DoorPuller {
    public static void main(String[] args) {
        if (args.length != 1) {
            DoorPuller.usage("Wrong number of arguments.");
        } else {
            String doorhost = args[0];
            InstrumentConfig config = new InstrumentConfig(0, InstrumentType.CHILLED_DOOR, doorhost, Instant.now());
            Instrument door = new ChilledDoor(config);
            door = door.read();
            door.getTrendables().forEach(trend -> {
                System.out.format("%n@@ %s %s%n", trend.getMasterKey(), trend.getMasterTimestamp());
                trend.getItems().forEach((key, value) -> System.out.format("%s %s%n", key, value));
            });
            door.getLastException().ifPresent(exc -> System.err.println(Instant.now() + "\n" + exc));
        }
    }

    private static void usage(String msg) {
        System.err.println(msg);
        System.err.println("Usage: <path-to-distribution>/bin/CCSbootstrap.sh -app DoorPuller <door hostname or IP>");
    }
}

