/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb.model;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.localdb.configdb.model.Configuration;
import org.lsst.ccs.localdb.configdb.model.ConfigurationParameterValue;
import org.lsst.ccs.localdb.configdb.model.ParameterPath;

public class ConfigurationUtils {
    private ConfigurationUtils() {
    }

    public static long computeChecksum(Configuration c) throws NoSuchAlgorithmException, IOException {
        TreeMap<String, String> orderedMap = new TreeMap<String, String>();
        for (Map.Entry<ParameterPath, ConfigurationParameterValue> e : c.getConfigurationParameterValues().entrySet()) {
            orderedMap.put(e.getKey().toString(), e.getValue().getValue());
        }
        return ConfigurationUtils.doComputeChecksum(c.getDescription().getId(), orderedMap);
    }

    public static long computeCheckSum(long descriptionId, List<ConfigurationParameterInfo> cpis) throws NoSuchAlgorithmException, IOException {
        TreeMap<String, String> orderedMap = new TreeMap<String, String>();
        for (ConfigurationParameterInfo cpi : cpis) {
            if (cpi.isFinal()) continue;
            orderedMap.put(new ParameterPath(cpi.getComponentName(), cpi.getParameterName()).toString(), cpi.getConfiguredValue());
        }
        return ConfigurationUtils.doComputeChecksum(descriptionId, orderedMap);
    }

    private static long doComputeChecksum(long descId, Map<String, String> parms) throws NoSuchAlgorithmException, IOException {
        MessageDigest md = MessageDigest.getInstance("SHA");
        md.update(ByteBuffer.allocate(64).putLong(descId));
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bas);
        oos.writeObject(parms);
        md.update(bas.toByteArray());
        bas.close();
        oos.close();
        return new BigInteger(md.digest()).longValue();
    }
}

