/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.lsst.ccs.gconsole.plugins.trending.Trend;
import org.lsst.ccs.gconsole.plugins.trending.TrendData;
import org.lsst.ccs.gconsole.plugins.trending.TrendingChannel;

public abstract class TrendingSource {
    private final CopyOnWriteArrayList<Listener> listeners = new CopyOnWriteArrayList();

    public abstract List<TrendingChannel> getChannels();

    public abstract TrendData get(TrendingChannel var1, long var2, long var4, EnumSet<Trend.Meta> var6, TrendData var7);

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    protected void fireEvent(List<TrendingChannel> removedChannels, List<TrendingChannel> addedChannels) {
        Event event = new Event(this, removedChannels, addedChannels);
        this.listeners.forEach(listener -> listener.processEvent(event));
    }

    public static class Event
    extends EventObject {
        private final List<TrendingChannel> removed;
        private final List<TrendingChannel> added;

        public Event(TrendingSource source, List<TrendingChannel> removedChannels, List<TrendingChannel> addedChannels) {
            super(source);
            this.removed = removedChannels == null ? Collections.emptyList() : removedChannels;
            this.added = addedChannels == null ? Collections.emptyList() : addedChannels;
        }

        @Override
        public TrendingSource getSource() {
            return (TrendingSource)super.getSource();
        }

        public List<TrendingChannel> getRemovedChannels() {
            return this.removed == null ? Collections.emptyList() : this.removed;
        }

        public List<TrendingChannel> getAddedChannels() {
            return this.added == null ? Collections.emptyList() : this.added;
        }
    }

    public static interface Listener
    extends EventListener {
        public void processEvent(Event var1);
    }
}

