/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.style.editor;

import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertySheetTableModel;
import hep.aida.IBaseStyle;
import hep.aida.ref.plotter.style.editor.StyleProperty;
import hep.aida.ref.plotter.style.editor.StylePropertyEditColumnType;
import hep.aida.ref.plotter.style.editor.StylePropertyState;
import java.beans.PropertyChangeEvent;

public class StylePropertyTableModel
extends PropertySheetTableModel {
    public static final int EDIT_COLUMN = 2;
    public static final String EDIT_COLUMN_TEXT = "Edit...";
    private StylePropertyEditColumnType editColumnValue;
    private IBaseStyle style;

    public StylePropertyTableModel(IBaseStyle style) {
        this.style = style;
        this.editColumnValue = new StylePropertyEditColumnType(EDIT_COLUMN_TEXT);
        this.setProperties();
    }

    public IBaseStyle getStyle() {
        return this.style;
    }

    private void setProperties() {
        String[] pars = this.style.availableParameters();
        if (pars == null) {
            return;
        }
        Property[] props = new Property[pars.length];
        for (int i = 0; i < pars.length; ++i) {
            props[i] = new StyleProperty(this.style, pars[i]);
        }
        this.setProperties(props);
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        String valueString = null;
        if (value instanceof StylePropertyState) {
            valueString = ((StylePropertyState)value).toString(true);
        } else if (value != null) {
            valueString = value.toString() + ", Class=" + value.getClass().getName();
        }
        super.setValueAt(value, rowIndex, columnIndex);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
    }

    public int getColumnCount() {
        return 3;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result = null;
        PropertySheetTableModel.Item item = this.getPropertySheetElement(rowIndex);
        if (columnIndex == 2) {
            result = super.getValueAt(rowIndex, 1) instanceof StylePropertyState ? this.editColumnValue : null;
            return result;
        }
        result = item.isProperty() ? super.getValueAt(rowIndex, columnIndex) : item;
        return result;
    }
}

