/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import jas.hist.DataSource;
import jas.hist.HasStyle;
import jas.hist.HistogramUpdate;
import jas.hist.JASHist1DHistogramStyle;
import jas.hist.JASHistAxis;
import jas.hist.JASHistStyle;
import jas.hist.XYDataSource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import org.freehep.jas.plugin.plotter.DefaultPlotter;
import org.freehep.jas.plugin.plotter.DefaultRegion;
import org.freehep.jas.plugin.plotter.JAS3DataSource;
import org.freehep.jas.plugin.plotter.JAS3Plot;
import org.freehep.jas.plugin.tree.FTreePath;
import org.freehep.jas.services.PlotPage;
import org.freehep.jas.services.PlotRegion;
import org.freehep.jas.services.Plotter;
import org.freehep.swing.popup.HasPopupItems;
import org.lsst.ccs.gconsole.plugins.trending.LsstTrendingPlugin;
import org.lsst.ccs.gconsole.plugins.trending.Trend;
import org.lsst.ccs.gconsole.plugins.trending.TrendData;
import org.lsst.ccs.gconsole.plugins.trending.TrendingChannel;
import org.lsst.ccs.gconsole.plugins.trending.TrendingPreferences;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindow;

public final class TrendPlotter
implements Plotter {
    public static final String NO_META = "no-meta";
    private static final Color[] colors = new Color[]{Color.BLUE, Color.RED, Color.GREEN, Color.MAGENTA, Color.ORANGE, Color.CYAN, Color.DARK_GRAY, Color.LIGHT_GRAY};
    private final LsstTrendingPlugin plugin;
    private final DefaultPlotter plotter;
    private final ArrayList<TrendInfo> trends = new ArrayList(1);
    private PlotRegion region;
    private Trend.Meta metaOnPoint;
    private EnumSet<Trend.Meta> metaOffPoint;
    private boolean isCustomRangeT;
    private boolean isCustomRangeV;
    private double[] rangeT;
    private double[] rangeV;
    private boolean ignoreMeta;

    public TrendPlotter(LsstTrendingPlugin plugin) {
        this.plugin = plugin;
        this.reset();
        try {
            this.plotter = (DefaultPlotter)plugin.getPlotFactory().createPlotterFor(JAS3DataSource.class);
            this.plotter.getPlot().setShowStatistics(false);
            this.plotter.getPlot().getXAxis().setRangeAutomatic(false);
            this.plotter.getPlot().getYAxis().setRangeAutomatic(false);
        }
        catch (ClassCastException x) {
            throw new RuntimeException("TrendPlotter is designed to wrap DefaultPlotter", x);
        }
    }

    public PlotRegion getRegion() {
        return this.region;
    }

    public void setRegion(PlotRegion region) {
        this.region = region;
        try {
            DefaultRegion dr = (DefaultRegion)region;
            dr.addPopupItems(new Popup());
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public EnumSet<Trend.Meta> getMeta() {
        EnumSet<Trend.Meta> out = this.metaOnPoint == null ? EnumSet.noneOf(Trend.Meta.class) : EnumSet.of(this.metaOnPoint);
        out.addAll(this.metaOffPoint);
        return out;
    }

    public void setMeta(EnumSet<Trend.Meta> extras) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public boolean isActive() {
        if (this.region != null) {
            try {
                return ((JComponent)this.viewable()).getTopLevelAncestor() != null;
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                // empty catch block
            }
        }
        return false;
    }

    public List<Trend> getTrends() {
        ArrayList<Trend> out = new ArrayList<Trend>(this.trends.size());
        this.trends.forEach(info -> out.add(info.trend));
        return out;
    }

    public boolean isEmpty() {
        return this.trends.isEmpty();
    }

    @Override
    public void plot(Object timeHistory, int mode) {
        this.plot(timeHistory, mode, null, null);
    }

    public void plot(List<Trend> trendList, int mode) {
        if (trendList.size() == 1) {
            this.plot(trendList.get(0), mode);
        } else {
            trendList.forEach(trend -> this.plot(trend, 1, null, NO_META));
        }
    }

    @Override
    public void plot(Object timeHistory, int mode, Object style, String options) {
        if (!(timeHistory instanceof Trend) || mode != 0 && mode != 1) {
            return;
        }
        Set<Object> opt = options == null || options.trim().isEmpty() ? Collections.emptySet() : new HashSet<String>(Arrays.asList(options.split("\\s*,\\s*")));
        if (mode == 0) {
            this.clear();
        } else {
            this.checkRange();
            if (!this.trends.isEmpty() && this.trends.get(0).hasOffPoint()) {
                this.clearPlotter(true);
                this.trends.get(0).removeOffPoint();
                this.plotter.plot(this.trends.get((int)0).data.get(0), 1);
            }
        }
        Trend trend = (Trend)timeHistory;
        trend.setPlotter(this);
        TrendInfo trendInfo = new TrendInfo(trend);
        int trendIndex = this.trends.size();
        this.trends.add(trendInfo);
        Jas3Source ds = new Jas3Source(trendIndex, this.metaOnPoint, null);
        trendInfo.data.add(ds);
        if (!this.metaOffPoint.isEmpty() && this.trends.size() == 1 && !opt.contains(NO_META)) {
            for (Trend.Meta meta : this.metaOffPoint) {
                for (String key : meta.getKeys()) {
                    ds = new Jas3Source(trendIndex, meta, key);
                    trendInfo.data.add(ds);
                }
            }
        }
        this.plotter.plot(trendInfo.data.get(0), 1);
        for (int i = 1; i < trendInfo.data.size(); ++i) {
            this.plotter.plot(trendInfo.data.get(i), 1);
        }
        this.setPlotProperties();
    }

    @Override
    public void remove(Object data) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void clear() {
        this.clearData();
        this.reset();
        this.clearPlotter(false);
    }

    @Override
    public Component viewable() {
        return this.plotter.viewable();
    }

    @Override
    public List<Object> getData() {
        ArrayList<Object> out = new ArrayList<Object>(this.trends.size());
        this.trends.forEach(info -> out.add(info.trend));
        return out;
    }

    public void toFront() {
        PlotPage page;
        if (this.region != null && (page = this.region.getPage()) != null) {
            page.setCurrentRegion(this.region);
            page.showPage();
        }
    }

    void onRefreshRequest(Trend trend) {
        for (TrendInfo info : this.trends) {
            if (info.trend != trend) continue;
            info.messageID = this.plugin.getConsole().setStatusMessage("Loading trending data...", 0);
            break;
        }
    }

    void onDataChange(Trend trend) {
        TrendInfo trendInfo = null;
        for (TrendInfo info : this.trends) {
            if (info.trend != trend) continue;
            trendInfo = info;
            break;
        }
        if (trendInfo != null) {
            trendInfo.data.forEach(ds -> ((Jas3Source)ds).update());
            this.plugin.getConsole().setStatusMessage(null, trendInfo.messageID);
            this.setPlotProperties();
            trendInfo.data.forEach(ds -> ((Jas3Source)ds).replot());
        }
    }

    void onTimeWindowChange(Trend trend) {
        this.isCustomRangeT = false;
        this.rangeT = null;
        this.setPlotProperties();
    }

    private void peek() {
        JASHistAxis aT = this.plotter.getPlot().getXAxis();
        boolean autoT = aT.getRangeAutomatic();
        double min = aT.getMin();
        String begin = new Date(Math.round(min * 1000.0)).toString();
        double max = aT.getMax();
        String end = new Date(Math.round(max * 1000.0)).toString();
        JASHistAxis aY = this.plotter.getPlot().getYAxis();
        boolean autoV = aY.getRangeAutomatic();
        min = aY.getMin();
        max = aY.getMax();
        aT = null;
    }

    private void replot() {
        if (this.trends.size() > 1) {
            this.trends.forEach(info -> info.data.get(0).update());
            this.setPlotProperties();
            this.trends.forEach(info -> info.data.get(0).replot());
        } else if (this.trends.size() == 1) {
            Trend trend = this.trends.get((int)0).trend;
            this.clearData();
            this.clearPlotter(true);
            this.plot(trend, 1);
        }
    }

    private void clearData() {
        this.trends.forEach(info -> info.trend.setPlotter(null));
        this.trends.clear();
    }

    private void reset() {
        TrendingPreferences pref = this.plugin.getPreferences();
        this.metaOnPoint = null;
        this.metaOffPoint = EnumSet.noneOf(Trend.Meta.class);
        pref.getDrawMeta().forEach(m -> {
            if (m.isOnPoint()) {
                this.metaOnPoint = m;
            } else {
                this.metaOffPoint.add((Trend.Meta)((Object)m));
            }
        });
        this.ignoreMeta = pref.isIgnoreMetaRange();
        this.isCustomRangeT = false;
        this.isCustomRangeV = false;
        this.rangeT = null;
        this.rangeV = null;
    }

    private void setPlotProperties() {
        Object[] range;
        JASHistAxis axis = this.plotter.getPlot().getXAxis();
        double[] r = new double[]{axis.getMin(), axis.getMax()};
        if (this.isCustomRangeT) {
            if (!this.isRangeEqual(this.rangeT, r)) {
                axis.setRange(this.rangeT[0], this.rangeT[1]);
            }
        } else {
            long begin = Long.MAX_VALUE;
            long end = 0L;
            for (TrendInfo info : this.trends) {
                Trend trend = info.trend;
                range = trend.getTimeRange();
                if (range[0] < begin) {
                    begin = range[0];
                }
                if (range[1] <= end) continue;
                end = range[1];
            }
            if (end < begin) {
                end = begin = System.currentTimeMillis();
            }
            if (end == begin) {
                begin -= 1000L;
                end += 1000L;
            }
            this.rangeT = new double[]{(double)begin / 1000.0, (double)end / 1000.0};
            axis.setRange(this.rangeT[0], this.rangeT[1]);
        }
        axis = this.plotter.getPlot().getYAxis();
        r = new double[]{axis.getMin(), axis.getMax()};
        if (this.isCustomRangeV) {
            if (!this.isRangeEqual(this.rangeV, r)) {
                axis.setRange(this.rangeV[0], this.rangeV[1]);
            }
        } else if (this.rangeV == null || axis.getRangeAutomatic() || this.isRangeEqual(this.rangeV, r)) {
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            for (TrendInfo info : this.trends) {
                List<Jas3Source> data = info.data;
                if (data.isEmpty()) continue;
                if (this.ignoreMeta) {
                    range = data.get(0).getValueRange();
                    if (range[0] < min) {
                        min = range[0];
                    }
                    if (!(range[1] > max)) continue;
                    max = range[1];
                    continue;
                }
                for (Jas3Source dataset : data) {
                    double[] range2 = dataset.getValueRange();
                    if (range2[0] < min) {
                        min = range2[0];
                    }
                    if (!(range2[1] > max)) continue;
                    max = range2[1];
                }
            }
            if (max < min) {
                min = 0.0;
                max = 1.0;
            } else if (min == max) {
                if (min < 0.0) {
                    min *= 2.0;
                    max = 0.0;
                } else if (min > 0.0) {
                    min = 0.0;
                    max *= 2.0;
                } else {
                    min = -1.0;
                    max = 1.0;
                }
            } else {
                double padding = (max - min) * 0.05;
                min -= padding;
                max += padding;
            }
            this.rangeV = new double[]{min, max};
            axis.setRange(min, max);
        } else {
            this.isCustomRangeV = true;
            this.rangeV = r;
        }
        if (this.trends.size() == 1) {
            this.plotter.getPlot().setTitle(this.trends.get((int)0).trend.getChannel().getTitle());
        }
    }

    private void checkRange() {
        double[] r;
        JASHistAxis a;
        if (!this.isCustomRangeT && this.rangeT != null) {
            a = this.plotter.getPlot().getXAxis();
            r = new double[]{a.getMin(), a.getMax()};
            if (!a.getRangeAutomatic() && !this.isRangeEqual(r, this.rangeT)) {
                this.isCustomRangeT = true;
                this.rangeT = r;
            }
        }
        if (!this.isCustomRangeV && this.rangeV != null) {
            a = this.plotter.getPlot().getYAxis();
            r = new double[]{a.getMin(), a.getMax()};
            if (!a.getRangeAutomatic() && !this.isRangeEqual(r, this.rangeV)) {
                this.isCustomRangeV = true;
                this.rangeV = r;
            }
        }
    }

    private boolean isRangeEqual(double[] r1, double[] r2) {
        double tolerance = (r1[1] - r1[0]) / 10.0;
        return Math.abs(r1[0] - r2[0]) < tolerance && Math.abs(r1[1] - r2[1]) < tolerance;
    }

    private void clearPlotter(boolean keepProperties) {
        JAS3Plot plot = this.plotter.getPlot();
        if (keepProperties) {
            String title = plot.getTitle();
            JASHistAxis a = plot.getXAxis();
            double tMin = a.getMin();
            double tMax = a.getMax();
            a = plot.getYAxis();
            double vMin = a.getMin();
            double vMax = a.getMax();
            this.plotter.clear();
            if (title != null && !title.equals(plot.getTitle())) {
                plot.setTitle(title);
            }
            if (tMin != (a = plot.getXAxis()).getMin() || tMax != a.getMax()) {
                a.setRange(tMin, tMax);
            }
            if (vMin != (a = plot.getYAxis()).getMin() || vMax != a.getMax()) {
                a.setRange(vMin, vMax);
            }
        } else {
            this.plotter.clear();
        }
        plot.setShowStatistics(false);
        plot.getXAxis().setRangeAutomatic(false);
        plot.getYAxis().setRangeAutomatic(false);
    }

    Descriptor save() {
        Descriptor desc = new Descriptor();
        if (!this.trends.isEmpty()) {
            int n = this.trends.size();
            TrendDescriptor[] tds = new TrendDescriptor[n];
            for (int i = 0; i < n; ++i) {
                Trend trend = this.trends.get((int)i).trend;
                TrendDescriptor td = new TrendDescriptor();
                String path = trend.getChannel().getPath();
                td.setPath(path);
                String title = trend.getChannel().getTitle();
                if (!path.equals(title)) {
                    td.setTitle(title);
                }
                td.setTimeWindow(trend.getTimeWindow().toCompressedString());
                tds[i] = td;
            }
            desc.setTrends(tds);
        }
        if (this.metaOnPoint != null) {
            desc.setOnPointMeta(this.metaOnPoint.name());
        }
        if (!this.metaOffPoint.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            this.metaOffPoint.forEach(m -> sb.append(m.name()).append("+"));
            desc.setOffPointMeta(sb.substring(0, sb.length() - 1));
        }
        desc.setCustomRangeT(this.isCustomRangeT);
        desc.setRangeT(this.isCustomRangeT ? Arrays.copyOf(this.rangeT, this.rangeT.length) : null);
        desc.setCustomRangeV(this.isCustomRangeV);
        desc.setRangeV(this.isCustomRangeV ? Arrays.copyOf(this.rangeV, this.rangeV.length) : null);
        return desc;
    }

    void restore(Descriptor desc) {
        TrendDescriptor[] tds;
        this.isCustomRangeT = desc.isCustomRangeT();
        this.rangeT = desc.getRangeT();
        this.isCustomRangeV = desc.isCustomRangeV();
        this.rangeV = desc.getRangeV();
        String ms = desc.getOnPointMeta();
        if (ms != null) {
            this.metaOnPoint = Trend.Meta.valueOf(ms);
        }
        ms = desc.getOffPointMeta();
        this.metaOffPoint = EnumSet.noneOf(Trend.Meta.class);
        if (ms != null) {
            String[] ss;
            for (String s : ss = ms.split("\\+")) {
                this.metaOffPoint.add(Trend.Meta.valueOf(s));
            }
        }
        if ((tds = desc.getTrends()) != null) {
            ArrayList<Trend> trendList = new ArrayList<Trend>(tds.length);
            ArrayList<TrendingChannel> knownChannels = this.plugin.getSourcesManager().getChannels();
            for (TrendDescriptor td : tds) {
                String path = td.getPath();
                String title = td.getTitle();
                TrendingChannel channel = null;
                for (TrendingChannel ch : knownChannels) {
                    if (!title.equals(ch.getTitle())) continue;
                    if (path.equals(ch.getPath())) {
                        channel = ch;
                        break;
                    }
                    if (channel != null) continue;
                    channel = ch;
                }
                if (channel == null) continue;
                Trend trend = new Trend(channel);
                TimeWindow timeWindow = this.plugin.getTimeWindowSelector().getTimeWindow(td.getTimeWindow());
                trend.setTimeWindow(timeWindow);
                trendList.add(trend);
            }
            if (!trendList.isEmpty()) {
                this.plot(trendList, 0);
                this.plugin.refresh(this.getTrends());
                this.toFront();
            }
        }
    }

    static /* synthetic */ double[] access$1202(TrendPlotter x0, double[] x1) {
        x0.rangeT = x1;
        return x1;
    }

    static /* synthetic */ double[] access$1402(TrendPlotter x0, double[] x1) {
        x0.rangeV = x1;
        return x1;
    }

    public static class TrendDescriptor
    implements Serializable {
        private String path;
        private String title;
        private String timeWindow;

        public String getTimeWindow() {
            return this.timeWindow;
        }

        public void setTimeWindow(String timeWindow) {
            this.timeWindow = timeWindow;
        }

        public String getTitle() {
            return this.title == null ? this.path : this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }

    public static class Descriptor
    implements Serializable {
        private TrendDescriptor[] trends;
        private String onPointMeta;
        private String offPointMeta;
        private double[] rangeT;
        private double[] rangeV;
        private boolean customRangeT;
        private boolean customRangeV;

        public boolean isCustomRangeV() {
            return this.customRangeV;
        }

        public void setCustomRangeV(boolean customRangeV) {
            this.customRangeV = customRangeV;
        }

        public boolean isCustomRangeT() {
            return this.customRangeT;
        }

        public void setCustomRangeT(boolean customRangeT) {
            this.customRangeT = customRangeT;
        }

        public double[] getRangeV() {
            return this.rangeV;
        }

        public void setRangeV(double[] rangeV) {
            this.rangeV = rangeV;
        }

        public double[] getRangeT() {
            return this.rangeT;
        }

        public void setRangeT(double[] rangeT) {
            this.rangeT = rangeT;
        }

        public String getOffPointMeta() {
            return this.offPointMeta;
        }

        public void setOffPointMeta(String offPointMeta) {
            this.offPointMeta = offPointMeta;
        }

        public String getOnPointMeta() {
            return this.onPointMeta;
        }

        public void setOnPointMeta(String onPointMeta) {
            this.onPointMeta = onPointMeta;
        }

        public TrendDescriptor[] getTrends() {
            return this.trends;
        }

        public void setTrends(TrendDescriptor[] trends) {
            this.trends = trends;
        }
    }

    public static class Style {
        Trend.Meta onPoint;
        EnumSet<Trend.Meta> offPoint;

        public Style() {
        }

        public Style(Trend.Meta onPoint, EnumSet<Trend.Meta> offPoint) {
            this.onPoint = onPoint;
            this.offPoint = offPoint;
        }

        public Trend.Meta getOnPoint() {
            return this.onPoint;
        }

        public void setOnPoint(Trend.Meta onnPoint) {
            this.onPoint = onnPoint;
        }

        public EnumSet<Trend.Meta> getOffPoint() {
            return this.offPoint;
        }

        public void setOffPoint(EnumSet<Trend.Meta> offPoint) {
            this.offPoint = offPoint;
        }
    }

    private class Popup
    implements HasPopupItems {
        private Popup() {
        }

        public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component componentt, Point point) {
            menu.insert(new JSeparator(), 0);
            JMenu rangeMenu = new JMenu("Axes range");
            JMenuItem it = new JCheckBoxMenuItem("Ignore metadata", TrendPlotter.this.ignoreMeta);
            it.addActionListener(e -> {
                JCheckBoxMenuItem box = (JCheckBoxMenuItem)e.getSource();
                boolean isSelected = box.isSelected();
                if (TrendPlotter.this.ignoreMeta != isSelected) {
                    TrendPlotter.this.ignoreMeta = isSelected;
                    TrendPlotter.this.isCustomRangeV = false;
                    TrendPlotter.access$1402(TrendPlotter.this, null);
                    TrendPlotter.this.replot();
                }
            });
            rangeMenu.add(it);
            it = new JMenuItem("Reset");
            it.addActionListener(e -> {
                TrendPlotter.this.isCustomRangeT = false;
                TrendPlotter.access$1202(TrendPlotter.this, null);
                TrendPlotter.this.isCustomRangeV = false;
                TrendPlotter.access$1402(TrendPlotter.this, null);
                TrendPlotter.this.replot();
            });
            rangeMenu.add(it);
            menu.insert(rangeMenu, 0);
            JMenu metaMenu = new JMenu("Show metadata");
            ButtonGroup bg = new ButtonGroup();
            Trend.Meta.getOnPointSet().forEach(meta -> {
                JRadioButtonMenuItem item = new JRadioButtonMenuItem(meta.toString(), TrendPlotter.this.metaOnPoint == meta);
                bg.add(item);
                item.addActionListener(e -> {
                    Trend.Meta selected = Trend.Meta.valueOf(e.getActionCommand());
                    if (selected != TrendPlotter.this.metaOnPoint) {
                        TrendPlotter.this.metaOnPoint = selected;
                    } else {
                        TrendPlotter.this.metaOnPoint = null;
                    }
                    if (TrendPlotter.this.trends.size() == 1) {
                        Jas3Source dataset = ((TrendInfo)((TrendPlotter)TrendPlotter.this).trends.get((int)0)).data.get(0);
                        dataset.update();
                        TrendPlotter.this.setPlotProperties();
                        dataset.replot();
                    } else {
                        TrendPlotter.this.trends.forEach(info -> info.data.get(0).update());
                        TrendPlotter.this.setPlotProperties();
                        TrendPlotter.this.trends.forEach(info -> info.data.get(0).replot());
                    }
                });
                metaMenu.add(item);
            });
            metaMenu.addSeparator();
            Trend.Meta.getOffPointSet().forEach(meta -> {
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(meta.toString(), TrendPlotter.this.metaOffPoint.contains(meta));
                item.setEnabled(TrendPlotter.this.trends.size() < 2);
                item.addActionListener(e -> {
                    JCheckBoxMenuItem mi;
                    boolean isSelected;
                    Trend.Meta m = Trend.Meta.valueOf(e.getActionCommand());
                    boolean wasSelected = TrendPlotter.this.metaOffPoint.contains((Object)m);
                    if (wasSelected != (isSelected = (mi = (JCheckBoxMenuItem)e.getSource()).isSelected())) {
                        if (wasSelected) {
                            TrendPlotter.this.metaOffPoint.remove((Object)m);
                        } else {
                            TrendPlotter.this.metaOffPoint.add(m);
                        }
                        TrendPlotter.this.replot();
                    }
                });
                metaMenu.add(item);
            });
            menu.insert(metaMenu, 0);
            return menu;
        }
    }

    private class Jas3Source
    extends Observable
    implements JAS3DataSource,
    XYDataSource,
    HasStyle {
        private final int trendIndex;
        private final String title;
        private final String key;
        private long[] t;
        private double[] y;
        private double[] plusError;
        private double[] minusError;
        private final JASHist1DHistogramStyle style = new JASHist1DHistogramStyle();
        private double[] vRange;

        Jas3Source(int trendIndex, Trend.Meta meta, String key) {
            Color color;
            this.trendIndex = trendIndex;
            this.key = key;
            Trend trend = ((TrendInfo)((TrendPlotter)TrendPlotter.this).trends.get((int)trendIndex)).trend;
            if (key == null) {
                this.title = trend.getChannel().getTitle();
                color = colors[trendIndex % colors.length];
                this.style.setShowDataPoints(true);
                this.style.setShowErrorBars(true);
            } else {
                this.title = meta.toString();
                color = meta.getColor();
                this.style.setShowDataPoints(false);
                this.style.setShowErrorBars(false);
            }
            this.style.setDataPointColor(color);
            this.style.setErrorBarColor(color);
            this.style.setLineColor(color);
            this.style.setDataPointStyle(0);
            this.style.setShowHistogramBars(false);
            this.style.setShowLinesBetweenPoints(true);
            this.populate();
        }

        @Override
        public void destroy() {
        }

        @Override
        public void modifyPopupMenu(JPopupMenu jPopupMenu, Component component) {
        }

        @Override
        public DataSource dataSource() {
            return this;
        }

        @Override
        public FTreePath path() {
            return new FTreePath(this.getTitle());
        }

        @Override
        public String[] axisLabels() {
            return null;
        }

        @Override
        public void setAxisType(int type) {
        }

        public int getNPoints() {
            return this.t == null ? 0 : this.t.length;
        }

        public double getX(int i) {
            return (double)this.t[i] / 1000.0;
        }

        public double getY(int i) {
            return this.y[i];
        }

        public double getPlusError(int i) {
            return this.plusError == null ? 0.0 : this.plusError[i];
        }

        public double getMinusError(int i) {
            return this.minusError == null ? 0.0 : this.minusError[i];
        }

        public int getAxisType() {
            return 3;
        }

        public String getTitle() {
            return this.title;
        }

        public JASHistStyle getStyle() {
            return this.style;
        }

        private void populate() {
            TrendData td = ((TrendInfo)((TrendPlotter)TrendPlotter.this).trends.get((int)this.trendIndex)).trend.getData();
            if (td == null) {
                this.t = null;
                this.minusError = null;
                this.plusError = null;
                this.y = null;
            } else if (this.key == null) {
                this.t = td.getTime();
                this.y = td.getValue();
                if (TrendPlotter.this.metaOnPoint == null) {
                    this.plusError = null;
                    this.minusError = null;
                } else {
                    List<String> keys = TrendPlotter.this.metaOnPoint.getKeys();
                    int n = keys.size();
                    double[][] in = new double[n + 1][];
                    in[0] = this.y;
                    for (int i = 0; i < n; ++i) {
                        in[i + 1] = td.getValue(keys.get(i));
                    }
                    double[][] out = TrendPlotter.this.metaOnPoint.getBars(in);
                    this.minusError = out[0];
                    this.plusError = out[1];
                }
            } else {
                this.t = td.getTime(this.key);
                this.y = td.getValue(this.key);
            }
            this.vRange = null;
        }

        private void computeValueRange() {
            int n = this.getNPoints();
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            if (TrendPlotter.this.ignoreMeta) {
                for (int i = 0; i < n; ++i) {
                    double v = this.getY(i);
                    if (v < min) {
                        min = v;
                    }
                    if (!(v > max)) continue;
                    max = v;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    double v = this.getY(i);
                    double d = v - this.getMinusError(i);
                    if (d < min) {
                        min = d;
                    }
                    if (!((d = v + this.getPlusError(i)) > max)) continue;
                    max = d;
                }
            }
            this.vRange = new double[]{min, max};
        }

        private void update() {
            this.populate();
            this.setChanged();
        }

        private void replot() {
            this.notifyObservers(new HistogramUpdate(2, false));
        }

        private double[] getValueRange() {
            if (this.vRange == null) {
                this.computeValueRange();
            }
            return this.vRange;
        }
    }

    private class TrendInfo {
        Trend trend;
        List<Jas3Source> data;
        int messageID;

        TrendInfo(Trend trend, Jas3Source dataset) {
            this.trend = trend;
            this.data = new ArrayList<Jas3Source>(1);
            this.data.add(dataset);
        }

        TrendInfo(Trend trend) {
            this.trend = trend;
            this.data = new ArrayList<Jas3Source>(1);
        }

        boolean hasOffPoint() {
            return this.data.size() > 1;
        }

        void removeOffPoint() {
            Jas3Source onPoint = this.data.get(0);
            this.data = new ArrayList<Jas3Source>(1);
            this.data.add(onPoint);
        }
    }

    static enum Option {
        EXIST,
        NEWPAGE,
        NEWPLOT,
        OVERLAY,
        SLOW,
        REPLOT;

    }
}

