/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.jas3;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.utilities.conv.InputConversionEngine;
import org.lsst.ccs.utilities.conv.TypeConversionException;
import org.lsst.ccs.utilities.conv.TypeUtils;

public class PropertyHandler {
    private final Properties prop;
    private final HashMap<String, Object> defaultProperties = new HashMap();
    private final CopyOnWriteArrayList<Listener> listeners = new CopyOnWriteArrayList();

    PropertyHandler(Properties properties) {
        this.prop = properties;
    }

    public synchronized void addProperty(String key, Object defaultValue) {
        if (key == null || defaultValue == null) {
            throw new IllegalArgumentException("Arguments cannot be null.");
        }
        Type type = PropertyHandler.getType(defaultValue);
        Object oldDefault = this.defaultProperties.get(key);
        if (oldDefault != null && !PropertyHandler.getType(oldDefault).equals(type)) {
            throw new IllegalArgumentException("The key is already associated with a property of a different type.");
        }
        this.defaultProperties.put(key, defaultValue);
    }

    public synchronized Object removeProperty(String key) {
        Object value = null;
        Object defaultValue = this.defaultProperties.remove(key);
        if (defaultValue != null) {
            value = this.get(key, defaultValue);
            this.prop.remove(key);
        }
        return value;
    }

    public synchronized Object getProperty(String key) {
        Object defaultValue = this.defaultProperties.get(key);
        return this.get(key, defaultValue);
    }

    public synchronized Object setProperty(String key, Object value) {
        Object old = this.set(key, value);
        if (value == null && old != null) {
            value = this.defaultProperties.get(key);
            if (!old.equals(value)) {
                this.notifyListeners(null, key, value);
            }
        } else if (value != null && !value.equals(old)) {
            this.notifyListeners(null, key, value);
        }
        return old;
    }

    public synchronized void setProperties(Map<String, Object> keyValueMap) {
        HashMap<String, Object> changes = new HashMap<String, Object>(keyValueMap.size() * 2);
        keyValueMap.forEach((key, value) -> {
            Object old = this.set((String)key, value);
            if (value == null && old != null) {
                value = this.defaultProperties.get(key);
                if (!old.equals(value)) {
                    changes.put((String)key, value);
                }
            } else if (value != null && !value.equals(old)) {
                changes.put((String)key, value);
            }
        });
        this.notifyListeners(null, changes);
    }

    public void addPropertyListener(Console.PropertyListener listener, String filter) {
        Pattern p;
        if (filter == null) {
            p = null;
        } else {
            try {
                p = Pattern.compile(filter);
            }
            catch (PatternSyntaxException x) {
                throw new IllegalArgumentException("Illegal regular expression in property listener filter.", x);
            }
        }
        this.listeners.add(new Listener(listener, p));
    }

    public boolean removePropertyListener(Console.PropertyListener listener) {
        return this.listeners.remove(new Listener(listener, null));
    }

    private Object set(String key, Object value) {
        Type type = PropertyHandler.getType(value);
        Object defaultValue = this.defaultProperties.get(key);
        Object previousValue = this.get(key, defaultValue);
        if (value == null || value.equals(defaultValue)) {
            this.prop.remove(key);
        } else {
            Type defaultType;
            if (defaultValue != null && (defaultType = PropertyHandler.getType(defaultValue)) != type) {
                throw new IllegalArgumentException("The key is associated with a property of a different type.");
            }
            this.prop.setProperty(key, this.pack(value));
        }
        return previousValue;
    }

    private void notifyListeners(Object source, String key, Object value) {
        this.listeners.forEach(listener -> listener.notify(source, key, value));
    }

    private void notifyListeners(Object source, Map<String, Object> changes) {
        this.listeners.forEach(listener -> listener.notify(source, changes));
    }

    static Type getType(Object value) {
        if (value == null) {
            return null;
        }
        return value.getClass();
    }

    private Object get(String key, Object defaultValue) {
        String s = this.prop.getProperty(key);
        if (defaultValue == null) {
            return s;
        }
        if (s == null) {
            return defaultValue;
        }
        Type type = PropertyHandler.getType(defaultValue);
        try {
            return this.unpack(s, type);
        }
        catch (IllegalArgumentException x) {
            return defaultValue;
        }
    }

    private String pack(Object value) {
        return TypeUtils.stringify((Object)value);
    }

    private Object unpack(String data, Type type) {
        try {
            return InputConversionEngine.convertArgToType((String)data, (Type)type);
        }
        catch (TypeConversionException x) {
            throw new IllegalArgumentException("String '" + data + "' cannot be converted to type " + type.getTypeName(), x);
        }
    }

    private static class Listener {
        Console.PropertyListener listener;
        Pattern pattern;

        Listener(Console.PropertyListener listener, Pattern pattern) {
            this.listener = listener;
            this.pattern = pattern;
        }

        void notify(Object source, Map<String, Object> changes) {
            HashMap relevantChanges = new HashMap();
            changes.forEach((key, value) -> {
                if (this.pattern.matcher((CharSequence)key).matches()) {
                    relevantChanges.put(key, value);
                }
            });
            if (!relevantChanges.isEmpty()) {
                this.listener.propertiesChanged(source, Collections.unmodifiableMap(relevantChanges));
            }
        }

        void notify(Object source, String key, Object value) {
            if (this.pattern.matcher(key).matches()) {
                this.listener.propertiesChanged(source, Collections.singletonMap(key, value));
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof Listener) {
                return ((Listener)obj).listener == this.listener;
            }
            return false;
        }
    }
}

