/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandMessage;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandReply;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.LogMessage;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.AgentPresenceManager;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.BusMessageForwarder;
import org.lsst.ccs.messaging.BusMessagingLayer;
import org.lsst.ccs.messaging.CommandExecutor;
import org.lsst.ccs.messaging.CommandMessageListener;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.messaging.DestinationsException;
import org.lsst.ccs.messaging.DuplicateAgentNameException;
import org.lsst.ccs.messaging.LogMessageListener;
import org.lsst.ccs.messaging.MessagingAccessLayer;
import org.lsst.ccs.messaging.ProvidesDisconnectionInformation;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.messaging.TransportException;
import org.lsst.ccs.messaging.TransportManager;
import org.lsst.ccs.utilities.logging.Logger;

class BusApplicationLayer {
    private final AgentInfo agentInfo;
    private final String subsystemName;
    private final BusMessagingLayer busMessagingLayer;
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.bus.layer");
    private final MessagingAccessLayer messagingAccessLayer;
    private final AgentPresenceManager agentPresenceManager;
    private final ForwarderToCommandExecutor commandExecutorForwarder = new ForwarderToCommandExecutor();
    private final ForwarderToCommandOriginator commandOriginatorForwarder = new ForwarderToCommandOriginator();

    BusApplicationLayer(AgentInfo agentInfo) {
        String protocolProperty = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.transport", "jgroups:udp_ccs:");
        String transportPropsProperty = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.transport.properties", "");
        try {
            this.busMessagingLayer = TransportManager.getConnection(protocolProperty, transportPropsProperty);
        }
        catch (TransportException exc) {
            throw new RuntimeException(exc);
        }
        this.agentInfo = agentInfo;
        this.subsystemName = agentInfo.getName();
        MessagingAccessLayer.BusAccess logBusAccess = new MessagingAccessLayer.BusAccess(Bus.LOG);
        MessagingAccessLayer.StatusBusAccess statusBusAccess = new MessagingAccessLayer.StatusBusAccess(){

            @Override
            public void processDisconnectionSuspicion(String address) {
                if (BusApplicationLayer.this.getAgentPresenceManager() != null) {
                    BusApplicationLayer.this.getAgentPresenceManager().disconnecting(address);
                }
            }

            @Override
            public void processAnormalEvent(Exception ex) {
                if (BusApplicationLayer.this.agentPresenceManager != null) {
                    BusApplicationLayer.this.agentPresenceManager.anormalEvent(ex);
                }
            }
        };
        MessagingAccessLayer.BusAccess<CommandMessage> commandBusAccess = new MessagingAccessLayer.BusAccess<CommandMessage>(Bus.COMMAND){

            @Override
            public void processBusMessage(CommandMessage message) {
                super.processBusMessage(message);
                if (message instanceof CommandRequest) {
                    BusApplicationLayer.this.commandExecutorForwarder.update((CommandRequest)message);
                } else if (message instanceof CommandReply) {
                    BusApplicationLayer.this.commandOriginatorForwarder.update((CommandReply)message);
                }
            }
        };
        this.messagingAccessLayer = new MessagingAccessLayer(this.subsystemName, logBusAccess, statusBusAccess, commandBusAccess);
        this.agentPresenceManager = new AgentPresenceManager(this.getBusMessagingLayer() instanceof ProvidesDisconnectionInformation);
        this.addStatusListener(this.agentPresenceManager, BusMessageFilterFactory.messageOrigin(this.agentInfo.getName()).negate());
        try {
            this.busMessagingLayer.connect(this.messagingAccessLayer);
        }
        catch (IOException | DuplicateAgentNameException ex) {
            throw new RuntimeException(ex);
        }
    }

    final BusMessagingLayer getBusMessagingLayer() {
        return this.busMessagingLayer;
    }

    AgentInfo getAgentInfo() {
        return this.agentInfo;
    }

    void sendCommand(CommandRequest cmd, CommandOriginator originator) throws IOException {
        String destination = BusMessagingLayer.parseDestination(cmd.getDestination());
        if (destination == null || destination.isEmpty()) {
            throw new RuntimeException("Invalid destination for command " + cmd);
        }
        if (!this.getAgentPresenceManager().agentExists(destination)) {
            DestinationsException exc = new DestinationsException(this.subsystemName, destination);
            log.fine((Object)("sending fail (closed)" + this.subsystemName + " to destination " + destination));
            throw exc;
        }
        this.commandOriginatorForwarder.addCommandOriginator(cmd.getCorrelationId(), originator);
        if (cmd.getOriginAgentInfo().getName() == null) {
            throw new RuntimeException("Agent name must not be null");
        }
        this.busMessagingLayer.sendMessage(this.subsystemName, Bus.COMMAND, cmd);
    }

    void sendStatus(StatusMessage status) throws IOException {
        String origin = status.getOriginAgentInfo().getName();
        if (origin == null) {
            throw new RuntimeException("Agent name must not be null");
        }
        this.busMessagingLayer.sendMessage(this.subsystemName, Bus.STATUS, status);
    }

    void sendLog(LogMessage evt) throws IOException {
        String origin = evt.getOriginAgentInfo().getName();
        if (origin == null) {
            throw new RuntimeException("Agent name must not be null");
        }
        this.busMessagingLayer.sendMessage(this.subsystemName, Bus.LOG, evt);
    }

    void reply(CommandReply cmd) throws IOException {
        String origin = cmd.getOriginAgentInfo().getName();
        if (origin == null) {
            throw new RuntimeException("Agent name must not be null");
        }
        this.busMessagingLayer.sendMessage(this.subsystemName, Bus.COMMAND, cmd);
    }

    void setCommandExecutor(CommandExecutor executor) {
        this.commandExecutorForwarder.setCommandExecutor(executor);
    }

    void addCommandListener(CommandMessageListener l, Predicate<BusMessage<? extends Serializable, ?>> filter) {
        ForwarderToCommandListeners forwarder = new ForwarderToCommandListeners(l, filter);
        this.messagingAccessLayer.getBusAccess(Bus.COMMAND).addForwarder(l, forwarder);
    }

    void removeCommandListener(CommandMessageListener l) {
        this.messagingAccessLayer.getBusAccess(Bus.COMMAND).removeForwarder(l);
    }

    void addStatusListener(StatusMessageListener l, Predicate<BusMessage<? extends Serializable, ?>> filter) {
        ForwarderToStatusListeners forwarder = new ForwarderToStatusListeners(l, filter);
        this.messagingAccessLayer.getBusAccess(Bus.STATUS).addForwarder(l, forwarder);
    }

    void removeStatusListener(StatusMessageListener l) {
        this.messagingAccessLayer.getBusAccess(Bus.STATUS).removeForwarder(l);
    }

    void addLogListener(LogMessageListener l, Predicate<BusMessage<? extends Serializable, ?>> filter) {
        ForwarderToLogListeners forwarder = new ForwarderToLogListeners(l, filter);
        this.messagingAccessLayer.getBusAccess(Bus.LOG).addForwarder(l, forwarder);
    }

    void removeLogListener(LogMessageListener l) {
        this.messagingAccessLayer.getBusAccess(Bus.LOG).removeForwarder(l);
    }

    void close() {
        this.busMessagingLayer.disconnect(this.messagingAccessLayer);
    }

    public AgentPresenceManager getAgentPresenceManager() {
        return this.agentPresenceManager;
    }

    private class ForwarderToLogListeners
    implements BusMessageForwarder<LogMessage> {
        private final LogMessageListener listener;
        private final Predicate<BusMessage<? extends Serializable, ?>> filter;

        ForwarderToLogListeners(LogMessageListener listener, Predicate<BusMessage<? extends Serializable, ?>> filter) {
            this.listener = listener;
            this.filter = filter;
        }

        @Override
        public void update(LogMessage message) {
            if (this.filter == null || this.filter.test(message)) {
                this.listener.onLogMessage(message);
            }
        }
    }

    private class ForwarderToStatusListeners
    implements BusMessageForwarder<StatusMessage> {
        private final StatusMessageListener listener;
        private final Predicate<BusMessage<? extends Serializable, ?>> filter;

        ForwarderToStatusListeners(StatusMessageListener listener, Predicate<BusMessage<? extends Serializable, ?>> filter) {
            this.listener = listener;
            this.filter = filter;
        }

        @Override
        public void update(StatusMessage message) {
            if (this.filter == null || this.filter.test(message)) {
                this.listener.onStatusMessage(message);
            }
        }
    }

    private class ForwarderToCommandListeners
    implements BusMessageForwarder<CommandMessage> {
        private final CommandMessageListener listener;
        private final Predicate<BusMessage<? extends Serializable, ?>> filter;

        ForwarderToCommandListeners(CommandMessageListener listener, Predicate<BusMessage<? extends Serializable, ?>> filter) {
            this.listener = listener;
            this.filter = filter;
        }

        @Override
        public void update(CommandMessage message) {
            if (this.filter == null || this.filter.test(message)) {
                this.listener.onCommandMessage(message);
            }
        }
    }

    class ForwarderToCommandOriginator
    implements BusMessageForwarder<CommandReply> {
        private final ConcurrentHashMap<UUID, RequestData> currentRequests = new ConcurrentHashMap();

        ForwarderToCommandOriginator() {
        }

        void addCommandOriginator(UUID originatorId, CommandOriginator originator) {
            this.currentRequests.put(originatorId, new RequestData(originator));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(CommandReply message) {
            String destination = message.getDestination();
            if (!destination.equals(BusApplicationLayer.this.getAgentInfo().getName())) {
                return;
            }
            UUID originatorId = message.getCorrelationId();
            ForwarderToCommandOriginator forwarderToCommandOriginator = this;
            synchronized (forwarderToCommandOriginator) {
                RequestData reqData = this.currentRequests.get(originatorId);
                if (reqData == null) {
                    throw new RuntimeException("Could not find the originator of the CommandRequest " + message.getEncodedData());
                }
                if (message instanceof CommandAck) {
                    reqData.originator.processAck((CommandAck)message);
                    if (reqData.result == null) {
                        reqData.ackReceived = true;
                    } else {
                        reqData.originator.processResult(reqData.result);
                        this.currentRequests.remove(originatorId);
                    }
                } else if (message instanceof CommandNack) {
                    reqData.originator.processNack((CommandNack)message);
                    this.currentRequests.remove(originatorId);
                } else if (message instanceof CommandResult) {
                    if (reqData.ackReceived) {
                        reqData.originator.processResult((CommandResult)message);
                        this.currentRequests.remove(originatorId);
                    } else {
                        reqData.result = (CommandResult)message;
                    }
                }
            }
        }

        private class RequestData {
            CommandOriginator originator;
            CommandResult result;
            boolean ackReceived;

            RequestData(CommandOriginator originator) {
                this.originator = originator;
            }
        }
    }

    class ForwarderToCommandExecutor
    implements BusMessageForwarder<CommandRequest> {
        private volatile CommandExecutor commandExecutor;

        ForwarderToCommandExecutor() {
        }

        void setCommandExecutor(CommandExecutor commandExecutor) {
            if (this.commandExecutor != null) {
                throw new RuntimeException("A CommandExecutor is already registered for this Agent. There can be only one!");
            }
            this.commandExecutor = commandExecutor;
        }

        @Override
        public void update(CommandRequest message) {
            String destination = message.getDestination();
            if (destination.contains("/")) {
                destination = destination.substring(0, destination.indexOf("/"));
            }
            if (!destination.equals(BusApplicationLayer.this.getAgentInfo().getName())) {
                return;
            }
            if (this.commandExecutor == null) {
                throw new RuntimeException("A CommandExecutor has not been registered for this Agent.");
            }
            try {
                this.commandExecutor.executeCommandRequest(message);
            }
            catch (Exception throwable) {
                throwable.printStackTrace();
                log.error((Object)("on command :" + throwable));
            }
        }
    }
}

