/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.demo;

import org.lsst.ccs.drivers.dmmio.DMMIOBoardDriver;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.demo.LedDisplay;
import org.lsst.ccs.subsystems.demo.Thermometer;

public class ADCDemoModule
extends Module
implements Thermometer,
LedDisplay {
    private static final long serialVersionUID = -8439519765190670920L;
    DMMIOBoardDriver driver = new DMMIOBoardDriver();
    int baseAddress = 768;
    byte ledValue = 0;

    public void initModule() {
        this.driver.setBaseAddress(this.baseAddress);
        this.driver.init();
        this.driver.setGain(2.0);
        this.setLedValue((byte)0);
    }

    @Override
    public double getTemperature() {
        double t = this.driver.getAnalogInChannel(0);
        return t * 100.0;
    }

    @Override
    public void setLedValue(byte value) {
        this.ledValue = value;
        this.driver.setDigitalOutChannelsByte(value);
    }

    @Override
    public byte getLedValue() {
        return this.ledValue;
    }

    @Override
    public void setLed(int led, boolean on) {
        this.ledValue = on ? (byte)(this.ledValue | 1 << led) : (byte)(this.ledValue & (0xF ^ 1 << led));
        this.driver.setDigitalOutChannelsByte(this.ledValue);
    }

    public void tick() {
        this.setChanged();
        double t = this.getTemperature();
        Module.log.info((Object)("temperature measurement " + t));
        this.notifyObservers(t);
    }

    public static void main(String[] args) {
        ADCDemoModule m = new ADCDemoModule();
        m.init();
        int i = 0;
        while (i < 10) {
            System.out.println(m.getTemperature());
            ++i;
        }
    }
}

