package org.lsst.ccs.subsystems.demo;

import java.util.Observable;

import org.lsst.ccs.framework.Module;

public class TemperatureLEDDisplay extends Module {
	LedDisplay display;

	public LedDisplay getDisplay() {
		return display;
	}

	public void setDisplay(LedDisplay display) {
		this.display = display;
	}

	@Override
	public void processUpdate(Observable o, ValueUpdate arg) {
		if (arg.getValue() instanceof Double) {
			double t = (Double) arg.getValue();

			byte tInRange = (byte) ((t - 20) * 2);

			display.setLedValue(tInRange);
			log.info("setting led = "+tInRange);
		}
	}
}
