package org.lsst.ccs.subsystems.demo;

import org.lsst.ccs.drivers.dmmio.DMMIOBoardDriver;
import org.lsst.ccs.framework.Module;

/**
 * Hand made demo module, using a driver directly and all relevant conversions
 * internally
 */

public class ADCDemoModule extends Module implements Thermometer, LedDisplay {

	/**
	 * 
	 */
	private static final long serialVersionUID = -8439519765190670920L;
	DMMIOBoardDriver driver = new DMMIOBoardDriver();
	int baseAddress = 0x300;

	@Override
	public void initModule() {
		driver.setBaseAddress(baseAddress);
		driver.init();
		driver.setGain(2.);
		setLedValue((byte) 0);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.lsst.ccs.demo.Thermometer#getTemperature()
	 */
	public double getTemperature() {
		double t = driver.getAnalogInChannel(0);
		return t * 100;
	}

	byte ledValue = 0;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.lsst.ccs.demo.LedDisplay#setLedValue(byte)
	 */
	public void setLedValue(byte value) {
		ledValue = value;
		driver.setDigitalOutChannelsByte(value);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.lsst.ccs.demo.LedDisplay#getLedValue()
	 */
	public byte getLedValue() {
		return ledValue;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.lsst.ccs.demo.LedDisplay#setLed(int, boolean)
	 */
	public void setLed(int led, boolean on) {
		if (on) {
			ledValue |= (1 << led);
		} else {
			ledValue &= (0x0F ^ (1 << led));
		}
		driver.setDigitalOutChannelsByte(ledValue);
	}

	@Override
	public void tick() {
		setChanged();
		double t = getTemperature();
		log.info("temperature measurement " + t);
		notifyObservers(t); // TODO wrap double in some UpdateValue object ?
	}

	public static void main(String[] args) {
		ADCDemoModule m = new ADCDemoModule();
		m.init();
		for (int i = 0; i < 10; i++) {
			System.out.println(m.getTemperature());
		}
	}
}
