/*
 * Decompiled with CFR 0.152.
 */
package jas.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JDirectoryChooser
extends JComponent {
    private FileTreeModel model = new FileTreeModel();
    private JFileChooser foo = new JFileChooser();
    private JButton approve = new JButton("Select");
    private JButton cancel = new JButton("Cancel");
    private File currentDirectory = null;
    private JTree tree;
    private JDialog dialog;
    private int returnValue;
    public static int APPROVE_OPTION = 0;
    public static int CANCEL_OPTION = 1;
    private static File root = new File("root");

    public JDirectoryChooser() {
        this(FileSystemView.getFileSystemView());
    }

    public JDirectoryChooser(File currentDirectory) {
        this();
        this.setCurrentDirectory(currentDirectory);
    }

    public JDirectoryChooser(String currentDirectory) {
        this();
        if (currentDirectory != null) {
            this.setCurrentDirectory(new File(currentDirectory));
        }
    }

    public JDirectoryChooser(File currentDirectory, FileSystemView view) {
        this(view);
        this.setCurrentDirectory(currentDirectory);
    }

    public JDirectoryChooser(String currentDirectory, FileSystemView view) {
        this(view);
        this.setCurrentDirectory(new File(currentDirectory));
    }

    public JDirectoryChooser(FileSystemView view) {
        this.setup(view);
        ButtonListener al = new ButtonListener();
        this.tree = new JTree();
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(new FileRenderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(al);
        this.approve.addActionListener(al);
        this.cancel.addActionListener(al);
        this.approve.setEnabled(false);
        this.setLayout(new BorderLayout());
        this.add(new JScrollPane(this.tree));
        JPanel p = new JPanel(new FlowLayout());
        p.add(this.approve);
        p.add(this.cancel);
        this.add((Component)p, "South");
    }

    @Override
    public void addNotify() {
        this.tree.setModel(this.model);
        this.makeCurrentDirectoryVisible();
        super.addNotify();
    }

    private void makeCurrentDirectoryVisible() {
        if (this.currentDirectory != null) {
            Object node;
            File dir = this.currentDirectory;
            FileSystemView view = this.foo.getFileSystemView();
            Vector<File> v = new Vector<File>();
            while (true) {
                if (dir == null) {
                    return;
                }
                v.addElement(dir);
                if (view.isRoot(dir)) break;
                dir = view.getParentDirectory(dir);
            }
            Object[] files = new File[v.size() + 1];
            files[0] = node = this.model.getRoot();
            for (int i = 1; i < files.length; ++i) {
                File here = (File)v.elementAt(files.length - i - 1);
                int index = this.model.getIndexOfChild(node, here);
                if (index < 0) {
                    return;
                }
                files[i] = node = this.model.getChild(node, index);
            }
            TreePath path = new TreePath(files);
            this.tree.setSelectionPath(path);
            this.tree.scrollPathToVisible(path);
        }
    }

    public void setCurrentDirectory(File dir) {
        this.currentDirectory = dir;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.foo.setFileFilter(fileFilter);
        this.model.changed();
    }

    public FileFilter getFileFilter() {
        return this.foo.getFileFilter();
    }

    public void setFileHidingEnabled(boolean hide) {
        this.foo.setFileHidingEnabled(hide);
        this.model.changed();
    }

    public boolean isFileHidingEnabled() {
        return this.foo.isFileHidingEnabled();
    }

    public void setFileSelectionMode(int mode) {
        this.foo.setFileSelectionMode(mode);
        this.model.changed();
    }

    public int getFileSelectionMode() {
        return this.foo.getFileSelectionMode();
    }

    public void setMultiSelectionEnabled(boolean enable) {
        this.foo.setMultiSelectionEnabled(enable);
        this.tree.getSelectionModel().setSelectionMode(enable ? 4 : 1);
    }

    public boolean isMultiSelectionEnabled() {
        return this.foo.isMultiSelectionEnabled();
    }

    public File getSelectedFile() {
        return (File)this.tree.getLastSelectedPathComponent();
    }

    public File[] getSelectedFiles() {
        TreePath[] paths = this.tree.getSelectionPaths();
        File[] result = new File[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            result[i] = (File)paths[i].getLastPathComponent();
        }
        return result;
    }

    protected void setup(FileSystemView view) {
        this.foo.setFileSystemView(view);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.foo.updateUI();
    }

    public int showDialog(Component parent) {
        Frame frame = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        String title = null;
        title = this.foo.getDialogTitle();
        if (title == null) {
            this.foo.getUI().getDialogTitle(this.foo);
        }
        this.returnValue = 1;
        this.dialog = new JDialog(frame, title, true);
        this.dialog.getContentPane().add((Component)this, "Center");
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(parent);
        this.dialog.show();
        return this.returnValue;
    }

    public void setDialogTitle(String dialogTitle) {
        this.foo.setDialogTitle(dialogTitle);
    }

    public String getDialogTitle() {
        return this.foo.getDialogTitle();
    }

    public void setFileView(FileView fileView) {
        this.foo.setFileView(fileView);
    }

    public FileView getFileView() {
        return this.foo.getFileView();
    }

    public static void main(String[] argv) {
        final JTextField tf = new JTextField(40);
        JButton b = new JButton("Show Browser"){

            @Override
            public void fireActionPerformed(ActionEvent e) {
                JDirectoryChooser dlg = new JDirectoryChooser(tf.getText());
                dlg.showDialog(this);
                if (dlg.getSelectedFile() != null) {
                    tf.setText(dlg.getSelectedFile().toString());
                }
            }
        };
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add((Component)b, "Center");
        frame.getContentPane().add((Component)tf, "South");
        frame.pack();
        frame.show();
    }

    private class FileTreeModel
    implements TreeModel {
        private EventListenerList listenerList = new EventListenerList();
        private final int CACHE_SIZE = 10;
        private File[] cachedNode = new File[10];
        private File[][] cachedChildren = new File[10][];
        private int nextCache = 0;

        private FileTreeModel() {
        }

        @Override
        public Object getChild(Object node, int index) {
            return this.children(node)[index];
        }

        @Override
        public int getChildCount(Object node) {
            return this.children(node).length;
        }

        @Override
        public int getIndexOfChild(Object node, Object child) {
            File[] children = this.children(node);
            for (int i = 0; i < children.length; ++i) {
                if (!children[i].equals(child)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public Object getRoot() {
            return root;
        }

        @Override
        public boolean isLeaf(Object node) {
            return node != root && !((File)node).isDirectory();
        }

        @Override
        public void valueForPathChanged(TreePath p1, Object p2) {
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            this.listenerList.add(TreeModelListener.class, l);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            this.listenerList.remove(TreeModelListener.class, l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File[] children(Object node) {
            for (int i = 0; i < 10; ++i) {
                if (node != this.cachedNode[i]) continue;
                return this.cachedChildren[i];
            }
            Window w = null;
            Cursor oldCursor = null;
            if (JDirectoryChooser.this.tree != null && JDirectoryChooser.this.tree.isVisible() && (w = (Window)SwingUtilities.getAncestorOfClass(Window.class, JDirectoryChooser.this.tree)) != null) {
                oldCursor = w.getCursor();
                w.setCursor(Cursor.getPredefinedCursor(3));
            }
            try {
                Object[] children;
                FileSystemView view = JDirectoryChooser.this.foo.getFileSystemView();
                File dir = (File)node;
                boolean isRoot = dir == root;
                Object[] objectArray = children = isRoot ? view.getRoots() : view.getFiles(dir, JDirectoryChooser.this.foo.isFileHidingEnabled());
                if (!isRoot) {
                    boolean dirOnly;
                    int n = JDirectoryChooser.this.foo.getFileSelectionMode();
                    JDirectoryChooser.this.foo;
                    boolean bl = dirOnly = n == 1;
                    if (JDirectoryChooser.this.foo.getFileFilter() != null || dirOnly) {
                        Vector<Object> v = new Vector<Object>();
                        for (int i = 0; i < children.length; ++i) {
                            File f = children[i];
                            if (dirOnly && !f.isDirectory() || !JDirectoryChooser.this.foo.accept(f)) continue;
                            v.addElement(children[i]);
                        }
                        if (v.size() != children.length) {
                            children = new File[v.size()];
                            v.copyInto(children);
                        }
                    }
                }
                this.cachedNode[this.nextCache] = dir;
                this.cachedChildren[this.nextCache] = children;
                this.nextCache = (this.nextCache + 1) % 10;
                Object[] objectArray2 = children;
                if (w != null) {
                    w.setCursor(oldCursor);
                }
                return objectArray2;
            }
            catch (Throwable throwable) {
                if (w != null) {
                    w.setCursor(oldCursor);
                }
                throw throwable;
            }
        }

        void changed() {
            this.cachedNode = new File[10];
            this.cachedChildren = new File[10][];
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new TreePath(root)));
        }

        protected void fireTreeStructureChanged(TreeModelEvent e) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != TreeModelListener.class) continue;
                ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
            }
        }
    }

    private class FileRenderer
    extends DefaultTreeCellRenderer {
        private FileRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object node, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component comp = super.getTreeCellRendererComponent(tree, node, selected, expanded, leaf, row, hasFocus);
            if (comp instanceof JLabel && node instanceof File) {
                JLabel label = (JLabel)comp;
                File f = (File)node;
                label.setText(JDirectoryChooser.this.foo.getName(f));
                label.setIcon(JDirectoryChooser.this.foo.getIcon(f));
            }
            return comp;
        }
    }

    private class ButtonListener
    implements ActionListener,
    TreeSelectionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == JDirectoryChooser.this.approve) {
                JDirectoryChooser.this.foo;
                JDirectoryChooser.this.returnValue = 0;
            }
            JDirectoryChooser.this.dialog.hide();
            JDirectoryChooser.this.dialog = null;
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            JDirectoryChooser.this.approve.setEnabled(JDirectoryChooser.this.tree.getSelectionCount() > 0);
        }
    }
}

