/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.ccs;

import java.util.Random;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import org.jgroups.logging.Log;

public class MessageGate {
    static final long MIN_DELAY = 1000L;
    private static final long VETO_TIME = -129542144L;
    private static final double VETO_FACTOR = 2.0;
    private final Random rand = new Random();
    private final Log log;
    private final Level lev;
    private double loss = -1.0;
    private long maxSize = 0L;
    private double maxRate;
    private long prevDelay;
    private long prevTime;
    private long accSize = 0L;
    private long accTime = System.nanoTime();

    public MessageGate(Log logger) {
        this(logger, Level.FINE);
    }

    public MessageGate(Log logger, Level level) {
        this.log = logger;
        this.lev = level == null ? Level.ALL : level;
    }

    public synchronized void setMessageLoss(double fraction) {
        this.loss = fraction;
    }

    public synchronized void setRateLimit(int sizeMB, int rateMB) {
        this.maxSize = (long)sizeMB * 1000000L;
        this.maxRate = (double)rateMB / 1000.0;
    }

    public synchronized boolean process(int size) {
        boolean lost;
        boolean bl = lost = this.loss > 0.0 && this.loss > this.rand.nextDouble();
        if (lost) {
            this.log.out(this.lev, "Losing a message of size " + size + " bytes");
            return false;
        }
        this.log.trace("Publishing a message of size " + size + " bytes");
        if (this.maxSize > 0L) {
            this.limitRate(size);
        }
        return true;
    }

    private void limitRate(int size) {
        long delay;
        if (size <= 0) {
            return;
        }
        long now = System.nanoTime();
        this.accSize = Math.max(0L, Math.round((double)this.accSize - this.maxRate * (double)(now - this.accTime)));
        this.accSize += (long)size;
        this.accTime = now;
        if (this.accSize > this.maxSize && (delay = Math.round((double)(this.accSize - this.maxSize) / this.maxRate)) > 1000L) {
            if ((double)delay > (double)this.prevDelay * 2.0 || now > this.prevTime + -129542144L) {
                if (delay > 1000000000L) {
                    this.log.out(this.lev, "Throttle : message of size {0} is held for {1} ms.", size, delay / 1000000L);
                } else {
                    this.log.out(this.lev, "Throttle : message of size {0} is held for {1} ms.", size, delay / 1000000L);
                }
                this.prevDelay = delay;
                this.prevTime = now;
            }
            LockSupport.parkNanos(delay);
            now = System.nanoTime();
            this.accSize = Math.max(0L, Math.round((double)this.accSize - this.maxRate * (double)(now - this.accTime)));
            this.accTime = now;
        }
    }
}

