package org.lsst.ccs.subsystem.demo.main;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;

import org.lsst.ccs.Agent;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.UnauthorizedLevelException;
import org.lsst.ccs.services.UnauthorizedLockException;
import org.lsst.ccs.utilities.logging.Logger;
import org.python.antlr.PythonParser.break_stmt_return;

public class DemoLocker extends Subsystem implements HasLifecycle {

    private static final Logger LOG = Logger.getLogger(DemoLocker.class.getName());

    @LookupField(strategy = LookupField.Strategy.TREE)
    private AgentLockService agentLockService;
    @LookupField(strategy = LookupField.Strategy.TOP)
    private Agent agent;
    private AgentMessagingLayer aml;
    private ConcurrentMessagingUtils cmu;

    private String demoName = "demo-subsystem";

    public DemoLocker() {
        super("demo-locker", AgentInfo.AgentType.WORKER);
    }

    @Override
    public void postStart() {
        aml = agent.getMessagingAccess();
        cmu = new ConcurrentMessagingUtils(aml);
    }

    @Command(type = Command.CommandType.ACTION, autoAck = false, level = Command.NORMAL)
    public void lockDemo() throws Exception {
        try {
            try {
                agentLockService.lockAgent(demoName);
            } catch (Exception e) {
                agentLockService.attachLock(demoName);
            }
            LOG.log(Level.INFO, "Locking agent {0}", demoName);
            agentLockService.setLevelForAgent(demoName, 99);

        } catch (UnauthorizedLevelException | UnauthorizedLockException x) {
            throw new ExecutionException("Failed to lock subsystem " + demoName, x);
        }
    }

    @Command(type = Command.CommandType.ACTION, autoAck = false, level = Command.NORMAL)
    public void actOnDemo() throws Exception {
        try {
            cmu.sendSynchronousCommand(new CommandRequest(demoName, "switchToNormalMode"));
        } catch (Exception x) {
            throw x instanceof ExecutionException ? (ExecutionException) x : new ExecutionException(x);
        }

    }

    @Command(type = Command.CommandType.ACTION, autoAck = false, level = Command.NORMAL)
    public void unlockDemo() throws Exception {
        try {
            agentLockService.unlockAgent(demoName);
            LOG.log(Level.INFO, "Unlocking agent {0}", demoName);

        } catch (UnauthorizedLockException x) {
            throw new ExecutionException("Failed to unlock subsystem " + demoName, x);
        }
    }

    @Command(type = Command.CommandType.ACTION, autoAck = false, level = Command.NORMAL)
    public void loop(int n) throws Exception {
        for (int i = 0; i < n; i++) {
            try {
                System.out.println("loop "+i);
                while (true) {
                    try {
                        lockDemo();
                        break;
                    } catch (Exception e) {
                        System.out.println("lock error "+e);
                    }
                }
                System.out.println("lock "+i);
                AgentLock lock = agentLockService.getLockForAgent(demoName);
                if (lock == null) {
                    System.out.println("oups no lock");
                } else {
                    System.out.println("lock "+lock.getToken());
                }
                System.out.println("act "+i);
                try {
                    actOnDemo();
                } catch (Exception e) {
                    System.out.println("act error "+e);
                }
                System.out.println("unlock "+i);
                unlockDemo();
            } catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }
    }

}
