/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class DataDictionaryOrdered
implements DataProviderDictionary {
    private static final int NO_PATH = 1000;
    private static final int NULL_PATH = 1001;
    private static final int EMPTY_PATH = 1002;
    private static final int NULL_KEY = 1003;
    private static final int EMPTY_KEY = 1004;
    private static final long serialVersionUID = 1L;
    private final Branch root;
    private final Leaf[] leaves;
    private transient boolean parentsSet;
    private transient HashMap<String, String> stringCache;
    private transient Map<Map<DataProviderInfo.Attribute, String>, Map.Entry<DataProviderInfo.Attribute[], String[]>> mapCache;

    public DataDictionaryOrdered(DataProviderDictionary other) {
        this(other.getDataProviderInfos());
    }

    public DataDictionaryOrdered(List<DataProviderInfo> data) {
        int index = 0;
        BuilderNode builderRoot = new BuilderNode(null, Collections.emptyMap());
        for (DataProviderInfo d : data) {
            String[] path = d.getFullPath().split("/");
            HashMap<DataProviderInfo.Attribute, String> att = new HashMap<DataProviderInfo.Attribute, String>();
            for (DataProviderInfo.Attribute a : d.getAttributes()) {
                att.put(a, d.getAttributeValue(a));
            }
            BuilderNode parent = builderRoot;
            for (int i = 0; i < path.length - 1; ++i) {
                String name = path[i];
                BuilderNode child = parent.children.get(name);
                if (child == null) {
                    child = new BuilderNode(name, att);
                    parent.children.put(name, child);
                    att.clear();
                } else {
                    Iterator<Map.Entry<DataProviderInfo.Attribute, String>> it = child.att.entrySet().iterator();
                    while (it.hasNext()) {
                        String newValue;
                        Map.Entry<DataProviderInfo.Attribute, String> e = it.next();
                        DataProviderInfo.Attribute key = e.getKey();
                        String oldValue = e.getValue();
                        if (Objects.equals(oldValue, newValue = (String)att.get(key))) {
                            att.remove(key);
                            continue;
                        }
                        it.remove();
                        child.children.values().forEach(node -> node.att.put(key, oldValue));
                        child.leaves.values().forEach(node -> node.att.put(key, oldValue));
                    }
                }
                parent = child;
            }
            String lastName = path[path.length - 1];
            BuilderNode leaf = new BuilderNode(lastName, att);
            if (parent.leaves.put(lastName, leaf) != null) {
                throw new RuntimeException("Duplicate path: " + d.getFullPath());
            }
            String p = d.getPath();
            String k = d.getKey();
            leaf.keyFlag = p == null ? 1001 : (p.isEmpty() ? 1002 : (k == null ? 1003 : (k.isEmpty() ? 1004 : (p.endsWith(k) ? k.split("/").length : -k.split("/").length))));
            leaf.index = index++;
        }
        this.leaves = new Leaf[index];
        this.stringCache = new HashMap(2048);
        this.mapCache = new HashMap<Map<DataProviderInfo.Attribute, String>, Map.Entry<DataProviderInfo.Attribute[], String[]>>(2048);
        this.root = (Branch)this.convert(builderRoot);
        this.stringCache = null;
        this.mapCache = null;
    }

    private Node convert(BuilderNode builderNode) {
        Map.Entry<DataProviderInfo.Attribute[], String[]> att = this.getMapFromCache(builderNode.att);
        if (builderNode.children.isEmpty() && builderNode.leaves.isEmpty()) {
            Leaf leaf;
            this.leaves[builderNode.index] = leaf = new Leaf(this.getStringFromCache(builderNode.name), att.getKey(), att.getValue(), builderNode.keyFlag);
            return leaf;
        }
        Node[] children = new Node[builderNode.children.size() + builderNode.leaves.size()];
        int i = 0;
        for (BuilderNode child : builderNode.children.values()) {
            children[i++] = this.convert(child);
        }
        for (BuilderNode child : builderNode.leaves.values()) {
            children[i++] = this.convert(child);
        }
        return new Branch(this.getStringFromCache(builderNode.name), att.getKey(), att.getValue(), children);
    }

    private String getStringFromCache(String s) {
        String cached = this.stringCache.putIfAbsent(s, s);
        return cached == null ? s : cached;
    }

    private Map.Entry<DataProviderInfo.Attribute[], String[]> getMapFromCache(Map<DataProviderInfo.Attribute, String> attMap) {
        if (attMap.isEmpty()) {
            return new AbstractMap.SimpleImmutableEntry<Object, Object>(null, null);
        }
        Map.Entry<DataProviderInfo.Attribute[], String[]> att = this.mapCache.get(attMap);
        if (att == null) {
            int n = attMap.size();
            DataProviderInfo.Attribute[] keys = new DataProviderInfo.Attribute[n];
            String[] values = new String[n];
            int i = 0;
            for (Map.Entry<DataProviderInfo.Attribute, String> e : attMap.entrySet()) {
                keys[i] = e.getKey();
                values[i++] = this.getStringFromCache(e.getValue());
            }
            att = new AbstractMap.SimpleImmutableEntry<DataProviderInfo.Attribute[], String[]>(keys, values);
            this.mapCache.put(attMap, att);
        }
        return att;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataProviderInfo> getDataProviderInfos() {
        DataDictionaryOrdered dataDictionaryOrdered = this;
        synchronized (dataDictionaryOrdered) {
            if (!this.parentsSet) {
                this.parentsSet = true;
                this.setParents(this.root);
            }
        }
        ArrayList<DataProviderInfo> out = new ArrayList<DataProviderInfo>(this.size());
        for (Leaf leaf : this.leaves) {
            EnumMap<DataProviderInfo.Attribute, String> att = new EnumMap<DataProviderInfo.Attribute, String>(DataProviderInfo.Attribute.class);
            LinkedList<String> path = new LinkedList<String>();
            Node node = leaf;
            while (node != this.root) {
                path.add(0, node.name);
                if (node.attKeys != null) {
                    int i = node.attKeys.length;
                    while (i-- > 0) {
                        att.put(node.attKeys[i], node.attValues[i]);
                    }
                }
                node = node.parent;
            }
            String fullPath = String.join((CharSequence)"/", path);
            DataProviderInfo dpi = DataDictionaryOrdered.makeDPI(fullPath, leaf.keyFlag, att);
            out.add(dpi);
        }
        return out;
    }

    public DataProviderInfo getDataProviderInfoForPath(String path) {
        EnumMap<DataProviderInfo.Attribute, String> att = new EnumMap<DataProviderInfo.Attribute, String>(DataProviderInfo.Attribute.class);
        String[] ss = path.split("/");
        Branch parent = this.root;
        Leaf leaf = null;
        int n = ss.length;
        for (String name : ss) {
            Node child = null;
            if (--n > 0) {
                for (Node node : parent.children) {
                    if (!node.name.equals(name) || !(node instanceof Branch)) continue;
                    child = node;
                    parent = (Branch)child;
                    break;
                }
            } else {
                int i = parent.children.length;
                while (i > 0) {
                    Node node = parent.children[--i];
                    if (!node.name.equals(name) || !(node instanceof Leaf)) continue;
                    child = node;
                    leaf = (Leaf)child;
                    break;
                }
            }
            if (child == null) {
                return null;
            }
            if (child.attKeys == null) continue;
            for (int i = 0; i < child.attKeys.length; ++i) {
                att.put(child.attKeys[i], child.attValues[i]);
            }
        }
        return DataDictionaryOrdered.makeDPI(path, leaf.keyFlag, att);
    }

    @Deprecated
    public Set<String> getGroups() {
        return Collections.singleton("");
    }

    @Deprecated
    public List<DataProviderInfo> getDataProviderDescriptionsForGroup(String group) {
        return group == null || !group.isEmpty() ? Collections.emptyList() : this.getDataProviderInfos();
    }

    @Deprecated
    public CCSTimeStamp getCCSTimeStamp() {
        return CCSTimeStamp.currentTime();
    }

    public int size() {
        return this.leaves.length;
    }

    private static DataProviderInfo makeDPI(String fullPath, int keyFlag, Map<DataProviderInfo.Attribute, String> attributes) {
        switch (keyFlag) {
            case 1001: {
                return new DataProviderInfo(null, fullPath, attributes);
            }
            case 1002: {
                return new DataProviderInfo("", fullPath, attributes);
            }
            case 1003: {
                return new DataProviderInfo(fullPath, null, attributes);
            }
            case 1004: {
                return new DataProviderInfo(fullPath, "", attributes);
            }
            case 1000: {
                return null;
            }
        }
        List<String> ss = Arrays.asList(fullPath.split("/"));
        int n = ss.size();
        if (keyFlag == n) {
            return new DataProviderInfo(fullPath, fullPath, attributes);
        }
        if (keyFlag > 0) {
            String key = String.join((CharSequence)"/", ss.subList(n - keyFlag, n));
            return new DataProviderInfo(fullPath, key, attributes);
        }
        String path = String.join((CharSequence)"/", ss.subList(0, n + keyFlag));
        String key = String.join((CharSequence)"/", ss.subList(n + keyFlag, n));
        return new DataProviderInfo(path, key, attributes);
    }

    void setParents(Branch parent) {
        for (Node child : parent.children) {
            child.parent = parent;
            if (!(child instanceof Branch)) continue;
            this.setParents((Branch)child);
        }
    }

    private static class BuilderNode {
        BuilderNode parent;
        final String name;
        final Map<DataProviderInfo.Attribute, String> att;
        final Map<String, BuilderNode> children;
        final Map<String, BuilderNode> leaves;
        int keyFlag = 1000;
        int index = -1;

        BuilderNode(String name, Map<DataProviderInfo.Attribute, String> att) {
            this.name = name;
            this.att = new TreeMap<DataProviderInfo.Attribute, String>(att);
            this.children = new TreeMap<String, BuilderNode>();
            this.leaves = new TreeMap<String, BuilderNode>();
        }
    }

    private static class Leaf
    extends Node {
        final int keyFlag;

        Leaf(String name, DataProviderInfo.Attribute[] attKeys, String[] attValues, int keyFlag) {
            super(name, attKeys, attValues);
            this.keyFlag = keyFlag;
        }
    }

    private static class Node
    implements Serializable {
        final String name;
        final DataProviderInfo.Attribute[] attKeys;
        final String[] attValues;
        transient Branch parent;

        Node(String name, DataProviderInfo.Attribute[] attKeys, String[] attValues) {
            this.name = name;
            this.attKeys = attKeys;
            this.attValues = attValues;
        }
    }

    private static class Branch
    extends Node {
        final Node[] children;

        Branch(String name, DataProviderInfo.Attribute[] attKeys, String[] attValues, Node[] children) {
            super(name, attKeys, attValues);
            this.children = children;
        }
    }
}

