/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.demo.main;

import hep.aida.IAnalysisFactory;
import hep.aida.IDataPointSetFactory;
import hep.aida.IHistogramFactory;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.StatusData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.Options;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.command.annotations.Option;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.commons.annotations.Persist;
import org.lsst.ccs.config.ConfigurationParameterDescription;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.jgroups.ClusterSplitUtils;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.demo.bus.DemoData;
import org.lsst.ccs.subsystem.demo.bus.DemoState;
import org.lsst.ccs.subsystem.demo.main.DemoConfigurable;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;
import org.lsst.ccs.utilities.scheduler.Scheduler;

public class DemoSubsystem
extends Subsystem
implements HasLifecycle {
    protected PeriodicTask dataPublisher;
    private final IAnalysisFactory af = IAnalysisFactory.create();
    private final IDataPointSetFactory dataPointSetFactory = this.af.createDataPointSetFactory(null);
    private final IHistogramFactory histogramFactory = this.af.createHistogramFactory(null);
    private final Random r = new Random();
    private final ArrayList<PeriodicTask> tracerTestTasks = new ArrayList();
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TOP)
    protected Subsystem subsys;
    @Persist
    private volatile String somePersistStr = "abc";
    @LookupPath
    private String nodePath;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private List<DemoConfigurable> configurables = new ArrayList<DemoConfigurable>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private DataProviderDictionaryService dataProviderDictionaryService;
    public static final Alert MONITOR_ALERT = new Alert("MonitorAlert", "Raised when monitoring quantities are ouside boundaries.");
    private int dataPublishRate = 5;
    private int dataSize = 2;
    private volatile long taskSleep = 0L;
    private volatile int numberOfExceptions = 0;
    @ConfigurationParameter(category="build")
    private volatile String buildPar = "someValue";
    private ScheduledExecutorService junkPublisher;

    public DemoSubsystem() {
        super("demo-subsystem", AgentInfo.AgentType.WORKER);
    }

    public void postStart() {
        this.updateLimits("1.0", "2.0");
        this.somePersistStr = String.valueOf(System.currentTimeMillis());
    }

    public void postInit() {
        ((AgentPropertiesService)this.subsys.getAgentService(AgentPropertiesService.class)).setAgentProperty("agentCategory", "demo");
        this.subsys.getAgentPersistenceService().setAutomatic(true, true);
    }

    public void build() {
        ConfigurationParameterDescription parDesc = new ConfigurationParameterDescription().withCategory("customCat").withDescription("Period for data publishing").withName("period");
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask("demoData-publish", () -> {
            if (this.numberOfExceptions > 0) {
                --this.numberOfExceptions;
                throw new RuntimeException("An Exception");
            }
            if (this.taskSleep <= 0L) {
                this.subsys.publishSubsystemDataOnStatusBus(this.getDemoDataToPublish("fixedRate"));
            } else {
                try {
                    Thread.sleep(this.taskSleep);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }).withIsFixedRate(true).withPeriod(Duration.ofSeconds(this.dataPublishRate)).withPeriodParameterDescription(parDesc));
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask("demoData-publish-fixedDelay", () -> {
            if (this.taskSleep <= 0L) {
                this.subsys.publishSubsystemDataOnStatusBus(this.getDemoDataToPublish("fixedDelay"));
            } else {
                try {
                    Thread.sleep(this.taskSleep);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }).withIsFixedRate(false).withPeriod(Duration.ofSeconds(this.dataPublishRate)));
    }

    @Command(type=Command.CommandType.ACTION)
    public void setNumberOfExceptionInMonitoringThread(int nExeptions) {
        this.numberOfExceptions = nExeptions;
    }

    @Command(type=Command.CommandType.ACTION)
    public void setPeriodicTaskSleepTime(long sleep) {
        this.taskSleep = sleep;
    }

    public void init() {
        ((DataProviderDictionaryService)this.subsys.getAgentService(DataProviderDictionaryService.class)).registerData(this.getDemoDataToPublish("fixedRate"));
        ((DataProviderDictionaryService)this.subsys.getAgentService(DataProviderDictionaryService.class)).registerData(this.getDemoDataToPublish("fixedDelay"));
        for (DemoConfigurable c : this.configurables) {
            ((AgentStateService)this.subsys.getAgentService(AgentStateService.class)).registerState(OtherState.class, "some state", (Object)c);
            ((AgentStateService)this.subsys.getAgentService(AgentStateService.class)).updateAgentComponentState((Object)c, new Enum[]{OtherState.HIGH});
            ((AgentStateService)this.subsys.getAgentService(AgentStateService.class)).registerState(DemoState.class, "some state", (Object)c);
            ((AgentStateService)this.subsys.getAgentService(AgentStateService.class)).updateAgentComponentState((Object)c, new Enum[]{DemoState.NOMINAL});
        }
        ((AlertService)this.subsys.getAgentService(AlertService.class)).registerAlert(this.getCustomAlert());
    }

    private KeyValueData getDemoDataToPublish(String prefix) {
        DemoData dd = new DemoData(this.dataSize);
        KeyValueData d = new KeyValueData(prefix + "_demo_Data", (Serializable)dd);
        KeyValueDataList kvdl = new KeyValueDataList();
        KeyValueDataList limits = new KeyValueDataList(prefix + "_demo_Data/temp");
        limits.addData(prefix + "_test", (Serializable)Double.valueOf(1.2), KeyValueData.KeyValueDataType.KeyValueTrendingData);
        kvdl.addData((KeyValueData)limits);
        kvdl.addData(d);
        return kvdl;
    }

    @Command(type=Command.CommandType.ACTION, description="update limits")
    public void updateLimits(String low, String high) {
        KeyValueDataList limits = new KeyValueDataList("demo_Data/temp");
        this.dataProviderDictionaryService.addMetadataForObject(limits, "alarmLow", low, (Object)this);
        this.dataProviderDictionaryService.addMetadataForObject(limits, "alarmHigh", high, (Object)this);
        this.subsys.publishSubsystemDataOnStatusBus((KeyValueData)limits);
    }

    private Alert getCustomAlert() {
        return new Alert("CustomAlert", "Custom Alert");
    }

    @Command(type=Command.CommandType.QUERY, description="raise custom alert")
    public void raiseCustomAlert(AlertState severity, String cause) {
        ((AlertService)this.subsys.getAgentService(AlertService.class)).raiseAlert(this.getCustomAlert(), severity, cause);
    }

    @Command(type=Command.CommandType.QUERY, description="Get Subsystem Data Sample")
    public DemoData getSampleData() {
        return new DemoData(this.dataSize);
    }

    @Command(type=Command.CommandType.QUERY, description="Set Subsystem Data Sample")
    public void setSampleDataSize(int size) {
        this.dataSize = size;
    }

    @Command(type=Command.CommandType.QUERY, description="Get Subsystem Array Sample")
    public Object[] getSampleArrayData() {
        Object[] data = new Object[]{"test", 2.3, new int[]{3, 2, 2, 2}};
        return data;
    }

    @Command(type=Command.CommandType.QUERY, description="Throw an Exception")
    public void throwAnException() {
        throw new RuntimeException("An Exception");
    }

    @Command(type=Command.CommandType.ACTION, description="Enable/Disable Publishing Tracer Test Messages")
    public void runTracerTest(boolean enable) {
        if (enable) {
            Scheduler s = this.subsys.getScheduler();
            this.tracerTestTasks.add(s.scheduleAtFixedRate(() -> this.subsys.getLogger().info((Object)("Self test on module " + this.r.nextInt(1000) + (this.r.nextInt(5) > 0 ? ": OK" : ": FAILED"))), 0L, 7L, TimeUnit.SECONDS));
            this.tracerTestTasks.add(s.scheduleAtFixedRate(() -> this.subsys.getLogger().warn((Object)"London Bridge is in trouble, please repair."), 2L, 15L, TimeUnit.SECONDS));
            this.tracerTestTasks.add(s.scheduleAtFixedRate(() -> this.subsys.getLogger().error((Object)"Sun has gone supernova."), 3L, 13L, TimeUnit.SECONDS));
        } else {
            this.tracerTestTasks.forEach(task -> task.cancel(false));
            this.tracerTestTasks.clear();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Time out (action command)")
    public String testTimeout(int sleepSeconds) {
        if (sleepSeconds > 0) {
            try {
                Thread.sleep((long)sleepSeconds * 1000L);
            }
            catch (InterruptedException x) {
                return "Interrupted";
            }
        }
        return "Done.";
    }

    @Command(type=Command.CommandType.QUERY, level=0, category=Command.CommandCategory.USER, description="Empty level 0 category USER type QUERY command")
    public void testUserQuery0() {
    }

    @Command(type=Command.CommandType.ACTION, level=0, category=Command.CommandCategory.USER, description="Empty level 0 category USER type QUERY command")
    public void testUserAction0() {
    }

    @Command(type=Command.CommandType.QUERY, level=1, category=Command.CommandCategory.USER, description="Empty level 0 category USER type QUERY command")
    public void testUserQuery1() {
    }

    @Command(type=Command.CommandType.QUERY, level=0, category=Command.CommandCategory.SYSTEM, description="Empty level 0 category USER type QUERY command")
    public void testSystemQuery0() {
    }

    @Command(type=Command.CommandType.QUERY, level=1, category=Command.CommandCategory.SYSTEM, description="Empty level 0 category USER type QUERY command")
    public void testSystemQuery1() {
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Test sending ACK/NACK. Delays are in seconds.", autoAck=false)
    public Object testCommand(@Argument(description="If false, command is rejected with a NACK.") boolean accept, @Argument(defaultValue="0") int delayBeforeAck, @Argument(description="Delay between ACK and the result.", defaultValue="0") int delayAfterAck, @Argument(defaultValue="0") int timeout, @Argument(defaultValue="false") boolean returnException) {
        if (delayBeforeAck > 0) {
            try {
                Thread.sleep((long)delayBeforeAck * 1000L);
            }
            catch (InterruptedException x) {
                return "Interrupted while waiting to send ACK/NACK";
            }
        }
        if (accept) {
            if (timeout > 0) {
                this.subsys.sendAck(Duration.ofSeconds(timeout));
            } else {
                this.subsys.sendAck(null);
            }
        } else {
            this.subsys.sendNack((Serializable)((Object)"Sending NACK as requested."));
            return "NACK";
        }
        if (delayAfterAck > 0) {
            try {
                Thread.sleep((long)delayAfterAck * 1000L);
            }
            catch (InterruptedException x) {
                return "Interrupted while waiting to send the result";
            }
        }
        if (returnException) {
            return new RuntimeException("Requsted exception result.");
        }
        return "Done.";
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Test various types of command arguments and return types.")
    public Object testCommandArguments(@Argument(name="namedBool", description="boolean argument with name but no default") boolean b1, @Argument(defaultValue="0", description="unnamed int argument with default 0") int varName, @Argument(defaultValue="Che", description="String argument: nickname", name="nickname") String nick, @Argument(description="List of integers") List<Integer> intList, @Argument(description="List of strings") List<String> stringList, @Argument(description="Kind of object to return", allowedValueProvider="testCommandArgumentsReturnTypeValues") String returnType, String ... var) {
        switch (returnType) {
            case "unknown": {
                return new Unknown();
            }
            case "exception": {
                return new RuntimeException("Exception returned.");
            }
            case "string": {
                return "Done";
            }
            case "short_list": {
                return Arrays.asList("11", "22", "33");
            }
            case "long list": {
                return Arrays.asList("first moderately long line", "shorty", "second (kind of) long line with ()", "The third, extremely long line that almost never ends. Contains a comma, too.");
            }
            case "int array": {
                return new int[]{0, 1, 2, 4};
            }
            case "list of args": {
                ArrayList<String> out = new ArrayList<String>();
                out.add("b1 = " + Boolean.toString(b1));
                out.add("varName = " + Integer.toString(varName));
                out.add("nickname = " + nick);
                out.add("intList = " + String.join((CharSequence)",", intList.stream().map(i -> Integer.toString(i)).collect(Collectors.toList())));
                out.add("stringList = " + String.join((CharSequence)",", stringList));
                out.add("returnType = " + returnType);
                out.add("strings = " + String.join((CharSequence)",", var));
                return out;
            }
            case "map_of_args": {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("b1", b1);
                map.put("varName", varName);
                map.put("nickname", nick);
                map.put("intList", intList);
                map.put("stringList", stringList);
                map.put("returnType", returnType);
                map.put("vararg", var);
                return map;
            }
        }
        return "Unexpected value for returnType:" + returnType;
    }

    @Option.List(value={@Option(name="invert", description="Invert the provided input String"), @Option(name="uppercase", description="Uppercate the provided input String"), @Option(name="space", description="Space apart the letters")})
    @Command(description="A Command with Options")
    public String echoWithOptions(Options opts, String input) {
        String tmpRes = input;
        if (opts.hasOption("invert")) {
            StringBuilder sb = new StringBuilder(input);
            sb.reverse();
            tmpRes = sb.toString();
        }
        if (opts.hasOption("uppercase")) {
            tmpRes = tmpRes.toUpperCase();
        }
        if (opts.hasOption("space")) {
            String tmpTmpRes = "";
            for (int i = 0; i < tmpRes.length(); ++i) {
                tmpTmpRes = tmpTmpRes + Character.toString(tmpRes.charAt(i)) + " ";
            }
            tmpRes = tmpTmpRes.trim();
        }
        return tmpRes;
    }

    public List<String> testCommandArgumentsReturnTypeValues() {
        return Arrays.asList("unknown", "exception", "string", "short_list", "long list", "int array", "list of args", "map_of_args");
    }

    @Command(type=Command.CommandType.ACTION)
    public void updateState(String componentName, DemoState state) {
        if ("".equals(componentName)) {
            ((AgentStateService)this.subsys.getAgentService(AgentStateService.class)).updateAgentState(new Enum[]{state});
        } else {
            Object componentToUpdate = this.subsys.getComponentLookup().getComponentByPath(componentName);
            if (componentToUpdate == null) {
                throw new IllegalArgumentException("No component corresponds to path " + componentName);
            }
            ((AgentStateService)this.subsys.getAgentService(AgentStateService.class)).updateAgentComponentState(componentToUpdate, new Enum[]{state});
        }
    }

    @Command(type=Command.CommandType.ACTION, level=99, description="Publish status messages for testing the messaging system. Any previously requested junk publishing is stopped.")
    public String testLoadStatusBus(@Argument(description="Approximate size of each message, KB. 0 means stop publishing.", defaultValue="1000") int size, @Argument(description="Messages per second on each thread. 0 means stop publishing.", defaultValue="1") int frequency, final @Argument(description="Keep publishing for the specified number of seconds. 0 means publish one message on each thread.", defaultValue="0") int time, @Argument(description="Number of threads.", defaultValue="1") int threads) {
        if (this.junkPublisher != null) {
            this.junkPublisher.shutdownNow();
            this.junkPublisher = null;
        }
        if (size <= 0 || frequency <= 0 || threads <= 0) {
            return "Stopped publishing";
        }
        this.junkPublisher = Executors.newScheduledThreadPool(threads, r -> {
            Thread t = new Thread(r);
            t.setName("Junk Publisher");
            t.setDaemon(true);
            return t;
        });
        int period = (int)Math.round(1000.0 / (double)frequency);
        Random random = new Random();
        final int n = size * 1000;
        for (int i = 0; i < threads; ++i) {
            final byte[] payload = new byte[n];
            random.nextBytes(payload);
            Runnable run = new Runnable(){
                private final byte[] load;
                private final long deadline;
                boolean first;
                private final AgentMessagingLayer ml;
                {
                    this.load = payload;
                    this.deadline = System.currentTimeMillis() + (long)(time * 1000);
                    this.first = true;
                    this.ml = DemoSubsystem.this.getMessagingAccess();
                }

                @Override
                public void run() {
                    StatusData mess = new StatusData(new KeyValueData("junk", (Serializable)Arrays.copyOf(this.load, n)));
                    if (System.currentTimeMillis() >= this.deadline) {
                        if (this.first) {
                            this.ml.sendStatusMessage((StatusMessage)mess);
                        }
                        DemoSubsystem.this.junkPublisher.shutdownNow();
                    } else {
                        this.ml.sendStatusMessage((StatusMessage)mess);
                    }
                    this.first = false;
                }
            };
            this.getLogger().info((Object)("Scheduling: " + period));
            this.junkPublisher.scheduleAtFixedRate(run, period / threads * i, period, TimeUnit.MILLISECONDS);
        }
        return "OK";
    }

    @Command(type=Command.CommandType.ACTION, level=99, description="Split the JGroups cluster into N parts")
    public void testSplitCluster(int nSplits) {
        HashSet<String> allAgents = new HashSet<String>();
        for (AgentInfo ai : this.getMessagingAccess().getAgentPresenceManager().listConnectedAgents()) {
            allAgents.add(ai.getName());
        }
        ClusterSplitUtils.splitCluster((int)nSplits, allAgents);
    }

    public static enum OtherState {
        LOW,
        HIGH;

    }

    private static class Unknown
    implements Serializable {
        private Unknown() {
        }
    }

    public static enum AState {
        A,
        B;

    }
}

