package org.lsst.ccs.subsystem.demo.main.device;

import java.time.Duration;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.demo.DemoDriver;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.DataProviderDictionaryService;

import static org.lsst.ccs.command.annotations.Command.NORMAL;
import static org.lsst.ccs.command.annotations.Command.ENGINEERING1;
import org.lsst.ccs.monitor.Channel;

/**
 * Monitoring Device. It publishes a metadata called 'devicemetadata' at its
 * level, that will therefore be associated to all its channels.
 *
 * @author turri
 */
public class DemoDevice extends Device {
    
    @LookupField(strategy=LookupField.Strategy.TREE)
    private DataProviderDictionaryService dataProviderDictionaryService;
    
    private DemoDriver driver;
    private final String id;
    private final Random r = new Random();
    private int meta;
    private boolean error = false; // readChannel simulated error, set by Command

    public DemoDevice(String id) {
        this.id = id;
    }

    public String getId() {
        return id;
    }
    
    @Override
    protected void initialize() {
        if (driver == null) {
            try {
                driver = new DemoDriver();
            } catch (DriverException ex) {
                Logger.getLogger(DemoDevice.class.getName()).log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
        }
        if (!error) setOnline(true);
    }

    @Override
    protected void close() {
        if (driver != null) {
            try {
                driver.close();
                driver = null;
            } catch (DriverException ex) {
                Logger.getLogger(DemoDevice.class.getName()).log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    protected double readChannel(Channel ch) {
        double val = r.nextGaussian();
        if (error) setOnline(false);
        return val;
    }

    @Command(type=Command.CommandType.QUERY, level=NORMAL,
             name="showError", description="show simulated read error")
    public boolean showError() {
	return error;
    }

    @Command(type=Command.CommandType.ACTION, level=ENGINEERING1,
             name="setError", description="set simulated error true/false")
    public void setError(@Argument(name="value",
                         description="setting for simulated read error") 
                         boolean value) {
	error = value;;
    }

}
