/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

public class LandauPdf {
    static final double[] p1 = new double[]{0.4259894875, -0.124976255, 0.039842437, -0.006298287635, 0.001511162253};
    static final double[] q1 = new double[]{1.0, -0.3388260629, 0.09594393323, -0.01608042283, 0.003778942063};
    static final double[] p2 = new double[]{0.1788541609, 0.1173957403, 0.01488850518, -0.001394989411, 1.283617211E-4};
    static final double[] q2 = new double[]{1.0, 0.7428795082, 0.3153932961, 0.06694219548, 0.008790609714};
    static final double[] p3 = new double[]{0.1788544503, 0.09359161662, 0.006325387654, 6.611667319E-5, -2.031049101E-6};
    static final double[] q3 = new double[]{1.0, 0.6097809921, 0.2560616665, 0.04746722384, 0.006957301675};
    static final double[] p4 = new double[]{0.9874054407, 118.6723273, 849.279436, -743.7792444, 427.0262186};
    static final double[] q4 = new double[]{1.0, 106.8615961, 337.6496214, 2016.712389, 1597.063511};
    static final double[] p5 = new double[]{1.003675074, 167.5702434, 4789.711289, 21217.86767, -22324.9491};
    static final double[] q5 = new double[]{1.0, 156.9424537, 3745.310488, 9834.698876, 66924.28357};
    static final double[] p6 = new double[]{1.000827619, 664.9143136, 62972.92665, 475554.6998, -5743609.109};
    static final double[] q6 = new double[]{1.0, 651.4101098, 56974.73333, 165917.4725, -2815759.939};
    static final double[] a1 = new double[]{0.04166666667, -0.01996527778, 0.02709538966};
    static final double[] a2 = new double[]{-1.84556867, -4.284640743};
    protected double sigma = 0.0;
    protected double mean = 0.0;

    public LandauPdf(double mean, double sigma) {
        this.mean = mean;
        this.sigma = sigma;
    }

    public LandauPdf() {
    }

    public double getValue(double x) {
        return LandauPdf.getValue(x, this.mean, this.sigma);
    }

    public void setSigma(double sigma) {
        this.sigma = sigma;
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    static double getValue(double x, double mean, double sigma) {
        double denlan;
        if (sigma <= 0.0) {
            return 0.0;
        }
        double v = (x - mean) / sigma;
        if (v < -5.5) {
            double u = Math.exp(v + 1.0);
            if (u < 1.0E-10) {
                return 0.0;
            }
            double ue = Math.exp(-1.0 / u);
            double us = Math.sqrt(u);
            denlan = 0.3989422803 * (ue / us) * (1.0 + (a1[0] + (a1[1] + a1[2] * u) * u) * u);
        } else if (v < -1.0) {
            double u = Math.exp(-v - 1.0);
            denlan = Math.exp(-u) * Math.sqrt(u) * (p1[0] + (p1[1] + (p1[2] + (p1[3] + p1[4] * v) * v) * v) * v) / (q1[0] + (q1[1] + (q1[2] + (q1[3] + q1[4] * v) * v) * v) * v);
        } else if (v < 1.0) {
            denlan = (p2[0] + (p2[1] + (p2[2] + (p2[3] + p2[4] * v) * v) * v) * v) / (q2[0] + (q2[1] + (q2[2] + (q2[3] + q2[4] * v) * v) * v) * v);
        } else if (v < 5.0) {
            denlan = (p3[0] + (p3[1] + (p3[2] + (p3[3] + p3[4] * v) * v) * v) * v) / (q3[0] + (q3[1] + (q3[2] + (q3[3] + q3[4] * v) * v) * v) * v);
        } else if (v < 12.0) {
            double u = 1.0 / v;
            denlan = u * u * (p4[0] + (p4[1] + (p4[2] + (p4[3] + p4[4] * u) * u) * u) * u) / (q4[0] + (q4[1] + (q4[2] + (q4[3] + q4[4] * u) * u) * u) * u);
        } else if (v < 50.0) {
            double u = 1.0 / v;
            denlan = u * u * (p5[0] + (p5[1] + (p5[2] + (p5[3] + p5[4] * u) * u) * u) * u) / (q5[0] + (q5[1] + (q5[2] + (q5[3] + q5[4] * u) * u) * u) * u);
        } else if (v < 300.0) {
            double u = 1.0 / v;
            denlan = u * u * (p6[0] + (p6[1] + (p6[2] + (p6[3] + p6[4] * u) * u) * u) * u) / (q6[0] + (q6[1] + (q6[2] + (q6[3] + q6[4] * u) * u) * u) * u);
        } else {
            double u = 1.0 / (v - v * Math.log(v) / (v + 1.0));
            denlan = u * u * (1.0 + (a2[0] + a2[1] * u) * u);
        }
        return denlan / sigma;
    }
}

