/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.demo.main.device;

import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.demo.DemoDriver;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.subsystem.common.service.DataAccumulationService;

public class IonPumps
extends Device {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private DataProviderDictionaryService dataProviderDictionaryService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private DataAccumulationService dataAccumulationService;
    private DemoDriver driver;
    private final String id;
    private final Random r = new Random();
    private int meta;
    @LookupPath
    private String path;

    public IonPumps(String id) {
        this.id = id;
        DataAccumulationService.isNeeded();
    }

    public String getId() {
        return this.id;
    }

    protected int[] checkChannel(Channel ch) throws Exception {
        if (ch.getHwChan() == 20) {
            this.dataAccumulationService.registerAccumulatedDataPath(ch.getPath());
        }
        return super.checkChannel(ch);
    }

    protected void initialize() {
        if (this.driver == null) {
            try {
                this.driver = new DemoDriver();
            }
            catch (DriverException ex) {
                Logger.getLogger(IonPumps.class.getName()).log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
        }
        this.setOnline(true);
    }

    protected void close() {
        if (this.driver != null) {
            try {
                this.driver.close();
                this.driver = null;
            }
            catch (DriverException ex) {
                Logger.getLogger(IonPumps.class.getName()).log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
        }
    }

    protected double readChannel(Channel ch) {
        int chan = ch.getHwChan();
        if (chan < 10) {
            return this.r.nextGaussian() * 0.5 + (double)chan;
        }
        if (chan == 20) {
            return this.dataAccumulationService.accumulateData(ch.getPath(), this.r.nextDouble());
        }
        return this.r.nextGaussian() * 10.0 + (double)(chan % 10 * 1000);
    }
}

