/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.lsst.ccs.ChecksumUtils;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.config.CategoryDescription;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.SingleCategoryTag;
import org.lsst.ccs.utilities.structs.ParameterPath;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public final class ConfigurationInfo
implements Serializable {
    private static final long serialVersionUID = 45966430232923784L;
    @Deprecated
    public static final int DEFAULT_VERSION = -1;
    @Deprecated
    public static final int LATEST_VERSION = -2;
    @Deprecated
    public static final int UNDEF_VERSION = -3;
    private ConfigurationState configState;
    private final List<String> recentChanges = new ArrayList<String>();
    private final List<ConfigurationParameterInfo> parametersView = new ArrayList<ConfigurationParameterInfo>();
    private CCSTimeStamp ccsTimeStamp;
    private String configurationDescription;
    private String fullConfigurationDescription;
    private transient ConfigurationDescription cd;
    @Deprecated
    private String descriptionName;
    @Deprecated
    private final Map<String, Boolean> hasCategoryChanged = new HashMap<String, Boolean>();
    @Deprecated
    private final Map<String, String> tags = new HashMap<String, String>();
    @Deprecated
    private final Map<String, Integer> versions = new HashMap<String, Integer>();
    @Deprecated
    private String globalName;
    @Deprecated
    private Integer version = -3;
    private final Map<String, Long> categoryDataChecksum = new ConcurrentHashMap<String, Long>();
    private Map<String, ConfigurationParameterInfo> configByPath;
    private Map<String, Map<String, String>> valuesMapByCategory;
    private Map<String, Map<String, String>> valuesMapByComponent;
    private boolean complete = false;

    @Deprecated
    public String getDescriptionName() {
        return this.descriptionName;
    }

    public CCSTimeStamp getCCSTimeStamp() {
        return this.ccsTimeStamp;
    }

    public String getConfigurationDescription() {
        return this.configurationDescription;
    }

    public String getFullConfigurationDescription() {
        return this.fullConfigurationDescription != null ? this.fullConfigurationDescription : this.getConfigurationDescription();
    }

    public boolean hasChangesForCategory(String category) {
        return this.getConfigurationDescriptionObject().getCategoryTag(category).hasChanges();
    }

    public boolean hasChanges() {
        for (String cat : this.getCategorySet()) {
            if (!this.getConfigurationDescriptionObject().getCategoryTag(cat).hasChanges()) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public String getConfigNameForCategory(String category) {
        return this.getConfigurationDescriptionObject().getCategoryTag(category).toString().replace(category + ":", "");
    }

    @Deprecated
    public Integer getConfigVersion(String cat) {
        CategoryDescription catTag = this.getConfigurationDescriptionObject().getCategoryTag(cat);
        if (catTag == null) {
            return -3;
        }
        SingleCategoryTag tag0 = catTag.getSingleCategoryTags().get(0);
        Integer ver = -1;
        try {
            ver = Integer.parseInt(tag0.getVersion());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ver;
    }

    @Deprecated
    public String getConfigurationName() {
        return this.configurationDescription;
    }

    public boolean hasCategory(String category) {
        return this.getConfigurationDescriptionObject().containsCategory(category);
    }

    public Set<String> getCategorySet() {
        return this.getConfigurationDescriptionObject().getCategoriesSet();
    }

    public ConfigurationState getConfigurationState() {
        return this.configState;
    }

    public void setConfigurationState(ConfigurationState state) {
        this.configState = state;
    }

    public String toString() {
        return "Configuration state : " + this.configState + ":" + this.getConfigurationDescription();
    }

    public List<ConfigurationParameterInfo> getAllParameterInfo() {
        return Collections.unmodifiableList(this.parametersView);
    }

    public ConfigurationParameterInfo getCurrentParameterInfo(String pathName) {
        return this.configByPath.get(this.convertToParameterPath(pathName).toString());
    }

    public Map<String, ConfigurationParameterInfo> getCurrentParameterInfoForCategory(String category) {
        Set<String> pathsForCategory = this.getCurrentValuesForCategory(category).keySet();
        HashMap<String, ConfigurationParameterInfo> result = new HashMap<String, ConfigurationParameterInfo>();
        for (String path : pathsForCategory) {
            ConfigurationParameterInfo cpi = this.configByPath.get(path);
            result.put(path, cpi);
        }
        return result;
    }

    public Map<String, ConfigurationParameterInfo> getCurrentParameterInfoFor(String componentName) {
        Set<String> pathsForComponent = this.getCurrentValuesFor(componentName).keySet();
        HashMap<String, ConfigurationParameterInfo> result = new HashMap<String, ConfigurationParameterInfo>();
        for (String path : pathsForComponent) {
            ConfigurationParameterInfo cpi = this.configByPath.get(path);
            result.put(path, cpi);
        }
        return result;
    }

    public List<ConfigurationParameterInfo> diff(ConfigurationInfo ci) {
        ArrayList<ConfigurationParameterInfo> result = new ArrayList<ConfigurationParameterInfo>();
        for (ConfigurationParameterInfo newParInfo : this.getAllParameterInfo()) {
            String newParValue = newParInfo.getCurrentValue();
            String oldParValue = ci.getCurrentValueForParameter(newParInfo.getPathName());
            if (newParValue == null) {
                if (oldParValue == null) continue;
                result.add(newParInfo);
                continue;
            }
            if (newParValue.equals(oldParValue)) continue;
            result.add(newParInfo);
        }
        return result;
    }

    public List<ConfigurationParameterInfo> getLatestChanges() {
        if (!this.complete) {
            throw new RuntimeException("Cannot use this ConfigurationInfo object; it's not complete yet.");
        }
        ArrayList<ConfigurationParameterInfo> latestChanges = new ArrayList<ConfigurationParameterInfo>();
        for (String path : this.recentChanges) {
            ConfigurationParameterInfo p = this.configByPath.get(path);
            if (p == null) continue;
            latestChanges.add(p);
        }
        return latestChanges;
    }

    public Map<String, String> getCurrentValuesForCategory(String category) {
        if (!this.complete) {
            throw new RuntimeException("Cannot use this ConfigurationInfo object; it's not complete yet.");
        }
        return Collections.unmodifiableMap(this.valuesMapByCategory.get(category));
    }

    public Map<String, String> getCurrentValuesFor(String componentName) {
        if (!this.complete) {
            throw new RuntimeException("Cannot use this ConfigurationInfo object; it's not complete yet.");
        }
        Map<String, String> result = this.valuesMapByComponent.get(componentName);
        if (result == null) {
            throw new RuntimeException("No values found for component " + componentName);
        }
        return Collections.unmodifiableMap(result);
    }

    public String getCurrentValueForParameter(String pathName) {
        return this.configByPath.get(this.convertToParameterPath(pathName).toString()).getCurrentValue();
    }

    private ParameterPath convertToParameterPath(String pathName) {
        if (!this.complete) {
            throw new RuntimeException("Cannot use this ConfigurationInfo object; it's not complete yet.");
        }
        ParameterPath pp = ParameterPath.valueOf((String)pathName);
        return pp;
    }

    public ConfigurationDescription getConfigurationDescriptionObject() {
        if (this.cd == null) {
            String desc = this.getFullConfigurationDescription().replace("[", "").replace("]", "");
            this.cd = new ConfigurationDescription().parseConfigurationDescription(desc);
        }
        return this.cd;
    }

    public Long getCategoryDataChecksum(String category) {
        return this.categoryDataChecksum.get(category);
    }

    private void addCategoryDataChecksum() {
        if (this.categoryDataChecksum.isEmpty()) {
            try {
                for (String category : this.getCategorySet()) {
                    Map<String, String> valuesByCat = this.valuesMapByCategory.get(category);
                    if (valuesByCat == null) continue;
                    TreeMap<String, String> values = new TreeMap<String, String>(valuesByCat);
                    this.categoryDataChecksum.put(category, ChecksumUtils.evaluateChecksum(values));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void complete() {
        this.complete = true;
        this.configByPath = new HashMap<String, ConfigurationParameterInfo>();
        this.valuesMapByCategory = new HashMap<String, Map<String, String>>();
        this.valuesMapByComponent = new HashMap<String, Map<String, String>>();
        for (ConfigurationParameterInfo par : this.parametersView) {
            String pathName = par.getPathName();
            String currentValue = par.getCurrentValue();
            String category = par.getCategoryName();
            String component = par.getComponentName();
            this.configByPath.put(pathName, par);
            Map valuesMapForCategory = this.valuesMapByCategory.getOrDefault(category, new HashMap());
            valuesMapForCategory.put(pathName, currentValue);
            this.valuesMapByCategory.put(category, valuesMapForCategory);
            Map valuesMapForComponent = this.valuesMapByComponent.getOrDefault(component, new HashMap());
            valuesMapForComponent.put(par.getParameterName(), currentValue);
            this.valuesMapByComponent.put(component, valuesMapForComponent);
        }
        this.addCategoryDataChecksum();
    }

    public static Map<String, List<ConfigurationParameterInfo>> getParameterInfoGroupByComponent(List<ConfigurationParameterInfo> parmList) {
        return parmList.stream().collect(Collectors.groupingBy(ConfigurationParameterInfo::getComponentName, Collectors.toList()));
    }

    public static Map<String, List<ConfigurationParameterInfo>> getParameterInfoGroupByCategory(List<ConfigurationParameterInfo> parmList) {
        return parmList.stream().collect(Collectors.groupingBy(ConfigurationParameterInfo::getCategoryName, Collectors.toList()));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (!this.complete) {
            this.complete();
        }
    }

    public static class Builder {
        private final ConfigurationInfo ci;
        private final Map<ParameterPath, ConfigurationParameterInfo.Builder> parameterBuilders = new HashMap<ParameterPath, ConfigurationParameterInfo.Builder>();

        public Builder(ConfigurationInfo ci) {
            this.ci = ci;
            for (ConfigurationParameterInfo cpi : ci.getAllParameterInfo()) {
                this.parameterBuilders.put(ParameterPath.valueOf((String)cpi.getPathName()), new ConfigurationParameterInfo.Builder(cpi));
            }
        }

        public Builder() {
            this.ci = new ConfigurationInfo();
        }

        public Builder setDescription(String description) {
            this.ci.descriptionName = description;
            return this;
        }

        public Builder setConfigurationState(ConfigurationState configState) {
            this.ci.configState = configState;
            return this;
        }

        public Builder addParameter(ParameterPath path, Type type, String category, String description, boolean isFinal, boolean isReadOnly, boolean isBuild) {
            ConfigurationParameterInfo.Builder builder = new ConfigurationParameterInfo.Builder();
            builder.addParameter(path, type, category, description, isFinal, isReadOnly, isBuild);
            this.parameterBuilders.put(path, builder);
            this.ci.parametersView.add(builder.build());
            return this;
        }

        public Builder updateParameter(ParameterPath path, String configuredValue, String currentValue, boolean dirty) {
            Map vals;
            ConfigurationParameterInfo.Builder builder = this.parameterBuilders.get(path);
            builder.updateParameter(configuredValue, currentValue, dirty);
            if (this.ci.valuesMapByComponent != null && (vals = (Map)this.ci.valuesMapByComponent.get(path.getComponentName())) != null) {
                vals.put(path.getParameterName(), currentValue);
            }
            if (this.ci.valuesMapByCategory != null && (vals = (Map)this.ci.valuesMapByCategory.get(builder.getCategory())) != null) {
                vals.put(path.toString(), currentValue);
            }
            return this;
        }

        public Builder setRecentChanges(List<String> recentChanges) {
            this.ci.recentChanges.clear();
            this.ci.recentChanges.addAll(recentChanges);
            return this;
        }

        public Builder addRecentChange(String path) {
            this.ci.recentChanges.add(path);
            return this;
        }

        public Builder updateConfigurationDescription(String configurationDescription) {
            return this.updateConfigurationDescription(configurationDescription, configurationDescription);
        }

        public Builder updateConfigurationDescription(String fullConfigurationDescription, String configurationDescription) {
            this.ci.fullConfigurationDescription = fullConfigurationDescription;
            this.ci.configurationDescription = configurationDescription;
            this.ci.cd = null;
            return this;
        }

        public Builder setCCSTimeStamp(CCSTimeStamp ccsTimeStamp) {
            this.ci.ccsTimeStamp = ccsTimeStamp;
            return this;
        }

        public Builder updateCategoryChecksum(String category, Long checksum) {
            this.ci.categoryDataChecksum.put(category, checksum);
            return this;
        }

        public ConfigurationInfo build() {
            this.ci.complete();
            return this.ci;
        }
    }
}

