/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.studio.pluginmanager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.PluginDir;
import org.freehep.application.studio.PluginInfo;
import org.freehep.application.studio.Studio;
import org.freehep.application.studio.pluginmanager.PluginInfoPanel;
import org.freehep.application.studio.pluginmanager.PluginManager;
import org.freehep.swing.ErrorDialog;
import org.freehep.util.VersionComparator;
import org.freehep.util.images.ImageHandler;

class InstalledPluginPanel
extends JPanel {
    private JButton remove;
    private JButton update;
    private JTree tree;
    private PluginInfoPanel infoPanel;
    private PluginActivationPanel activation;
    private PluginManager manager;
    static final Logger logger = Logger.getLogger(InstalledPluginPanel.class.getName());
    private ActionListener al = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean restart;
            Object source = e.getSource();
            if (source == InstalledPluginPanel.this.remove) {
                try {
                    InstalledPluginPanel.this.removeSelectedPlugins();
                }
                catch (Throwable io) {
                    logger.log(Level.SEVERE, "Error while removing plugin", io);
                }
            } else if (source == InstalledPluginPanel.this.update && (restart = InstalledPluginPanel.this.manager.update(InstalledPluginPanel.this))) {
                InstalledPluginPanel.this.manager.restart(InstalledPluginPanel.this);
            }
        }
    };
    private ChangeListener cl = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            InstalledPluginPanel.this.updateTree();
        }
    };
    private HashMap<String, PluginInfo> loadedPlugins;
    private Set<PluginInfo> updatablePlugins;

    InstalledPluginPanel(PluginManager manager) {
        super(new BorderLayout());
        this.manager = manager;
        JPanel panel = new JPanel(new GridLayout(1, 2, 5, 5));
        this.tree = new JTree();
        this.tree.setCellRenderer(new Renderer());
        this.tree.setRootVisible(false);
        this.tree.setVisibleRowCount(8);
        this.tree.setShowsRootHandles(true);
        this.tree.getSelectionModel().addTreeSelectionListener(new TreeHandler());
        JScrollPane treescroll = new JScrollPane(this.tree);
        treescroll.setBorder(BorderFactory.createTitledBorder("Installed Plugins"));
        panel.add(treescroll);
        JPanel rightPanel = new JPanel(new BorderLayout());
        this.infoPanel = new PluginInfoPanel(){
            private JLabel updateLabel;

            @Override
            void addExtraInfo(Object c1, Object c2) {
                this.add((Component)new JLabel("Latest published version:"), c1);
                this.updateLabel = new JLabel();
                this.add((Component)this.updateLabel, c2);
            }

            @Override
            void setExtraInfo(PluginInfo info) {
                PluginInfo update;
                String label = null;
                Map<PluginInfo, PluginInfo> updateMap = InstalledPluginPanel.this.manager.getUpdateMap();
                if (updateMap != null && (update = updateMap.get(info)) != null) {
                    label = update.getVersion();
                }
                this.updateLabel.setText(label);
            }
        };
        this.infoPanel.setBorder(BorderFactory.createTitledBorder("Plugin Info"));
        rightPanel.add((Component)this.infoPanel, "Center");
        this.activation = new PluginActivationPanel();
        this.activation.setBorder(BorderFactory.createTitledBorder("Plugin Activation"));
        rightPanel.add((Component)this.activation, "South");
        panel.add(rightPanel);
        JPanel buttons = new JPanel();
        this.remove = new JButton("Remove selected plugins");
        this.remove.addActionListener(this.al);
        buttons.add(this.remove);
        this.update = new JButton("Update installed plugins");
        this.update.addActionListener(this.al);
        buttons.add(this.update);
        this.add("South", buttons);
        this.add("Center", panel);
        this.updateTree();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.manager.addChangeListener(this.cl);
    }

    @Override
    public void removeNotify() {
        this.manager.removeChangeListener(this.cl);
        super.removeNotify();
    }

    private DefaultMutableTreeNode addSubNode(DefaultMutableTreeNode root, EnumMap<PluginDir, DefaultMutableTreeNode> map, PluginDir dir) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(dir.getLabel(), true);
        map.put(dir, node);
        root.add(node);
        return node;
    }

    protected final void updateTree() {
        DefaultMutableTreeNode treeRoot = new DefaultMutableTreeNode();
        EnumMap<PluginDir, DefaultMutableTreeNode> map = new EnumMap<PluginDir, DefaultMutableTreeNode>(PluginDir.class);
        List<PluginInfo> updates = this.manager.getUpdatablePlugins();
        this.updatablePlugins = updates == null ? Collections.emptySet() : new HashSet<PluginInfo>(updates);
        Map<String, PluginInfo> activePlugins = this.manager.getActivePlugins();
        this.loadedPlugins = new HashMap(activePlugins.size() * 2);
        for (PluginInfo loaded : this.manager.getApplication().getPlugins()) {
            PluginInfo active = activePlugins.get(loaded.getName());
            if (active != null && active.getDirectory() == loaded.getDirectory() && VersionComparator.compareVersion((String)active.getVersion(), (String)loaded.getVersion()) == 0) {
                this.loadedPlugins.put(loaded.getName(), loaded);
                continue;
            }
            this.loadedPlugins.put(loaded.getName(), null);
        }
        for (PluginInfo info : activePlugins.values()) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(info, false);
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)map.get((Object)info.getDirectory());
            if (rootNode == null) {
                rootNode = this.addSubNode(treeRoot, map, info.getDirectory());
            }
            rootNode.add(node);
        }
        DefaultTreeModel treeModel = new DefaultTreeModel(treeRoot, true);
        this.tree.setModel(treeModel);
        DefaultMutableTreeNode userNode = (DefaultMutableTreeNode)map.get((Object)PluginDir.USER);
        if (userNode != null) {
            this.tree.expandPath(new TreePath(new Object[]{treeRoot, userNode}));
        }
        this.remove.setEnabled(false);
        this.update.setEnabled(!this.updatablePlugins.isEmpty());
    }

    protected void removeSelectedPlugins() throws IOException {
        TreePath[] selectednodes = this.tree.getSelectionPaths();
        if (selectednodes != null && selectednodes.length > 0) {
            ArrayList<PluginInfo> plugins = new ArrayList<PluginInfo>(selectednodes.length);
            for (int i = 0; i < selectednodes.length; ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectednodes[i].getLastPathComponent();
                PluginInfo plugleaf = (PluginInfo)node.getUserObject();
                plugins.add(plugleaf);
            }
            boolean restart = this.manager.uninstall(this, plugins);
            this.updateTree();
            if (restart) {
                this.manager.restart(this);
            }
        }
    }

    private class TreeHandler
    implements TreeSelectionListener {
        private TreeHandler() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent evt) {
            DefaultMutableTreeNode node;
            TreePath selection = evt.getPath();
            DefaultMutableTreeNode defaultMutableTreeNode = node = selection == null ? null : (DefaultMutableTreeNode)selection.getLastPathComponent();
            if (node != null && node.getUserObject() instanceof PluginInfo) {
                PluginInfo plugprops = (PluginInfo)node.getUserObject();
                InstalledPluginPanel.this.infoPanel.setPlugin(plugprops);
                InstalledPluginPanel.this.activation.setPlugin(plugprops);
            } else {
                InstalledPluginPanel.this.infoPanel.setPlugin(null);
                InstalledPluginPanel.this.activation.setPlugin(null);
            }
            boolean enableRemove = false;
            TreePath[] checkselection = InstalledPluginPanel.this.tree.getSelectionPaths();
            if (checkselection != null) {
                enableRemove = true;
                EnumSet<PluginDir> writeableDirs = EnumSet.noneOf(PluginDir.class);
                this.checkDir(writeableDirs, PluginDir.USER);
                this.checkDir(writeableDirs, PluginDir.GROUP);
                this.checkDir(writeableDirs, PluginDir.SYSTEM);
                for (int i = 0; i < checkselection.length; ++i) {
                    node = (DefaultMutableTreeNode)checkselection[i].getLastPathComponent();
                    if (!(node.getUserObject() instanceof PluginInfo)) {
                        enableRemove = false;
                        break;
                    }
                    PluginInfo info = (PluginInfo)node.getUserObject();
                    if (writeableDirs.contains((Object)info.getDirectory())) continue;
                    enableRemove = false;
                    break;
                }
            }
            InstalledPluginPanel.this.remove.setEnabled(enableRemove);
        }

        private void checkDir(EnumSet<PluginDir> writeableDirs, PluginDir dir) {
            File file;
            String path;
            if (dir != null && (path = InstalledPluginPanel.this.manager.getApplication().getExtensionsDir(dir)) != null && (file = new File(path)).canWrite()) {
                writeableDirs.add(dir);
            }
        }
    }

    private class Renderer
    extends DefaultTreeCellRenderer {
        private Icon pluginIcon = ImageHandler.getIcon((String)"icons/plugin.gif", InstalledPluginPanel.class);
        private Icon updateIcon = ImageHandler.getIcon((String)"icons/plugin_update.gif", InstalledPluginPanel.class);
        private Icon disabledIcon = ImageHandler.getIcon((String)"icons/plugin_disabled.gif", InstalledPluginPanel.class);
        private Icon errorIcon = ImageHandler.getIcon((String)"icons/plugin_error.gif", InstalledPluginPanel.class);

        private Renderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object info;
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultMutableTreeNode && (info = ((DefaultMutableTreeNode)value).getUserObject()) instanceof PluginInfo) {
                PluginInfo loaded;
                PluginInfo plugleaf = (PluginInfo)info;
                String label = plugleaf.getName();
                this.setIcon(this.pluginIcon);
                boolean isUpdatable = InstalledPluginPanel.this.updatablePlugins.contains(plugleaf);
                if (isUpdatable) {
                    label = "<b>" + label + " (update available)</b>";
                    this.setIcon(this.updateIcon);
                }
                if ((loaded = (PluginInfo)InstalledPluginPanel.this.loadedPlugins.get(plugleaf.getName())) == null) {
                    label = "<font color=\"#888888\">" + label + "</font>";
                    if (plugleaf.getErrorStatus() != null) {
                        this.setIcon(this.errorIcon);
                    } else if (!isUpdatable) {
                        this.setIcon(this.disabledIcon);
                    }
                } else if (plugleaf.getErrorStatus() != null || loaded.getErrorStatus() != null) {
                    this.setIcon(this.errorIcon);
                } else if (!isUpdatable && loaded.getPlugin() == null) {
                    this.setIcon(this.disabledIcon);
                }
                if (label.startsWith("<")) {
                    label = "<html>" + label;
                }
                this.setText(label);
            }
            return this;
        }
    }

    private class PluginActivationPanel
    extends JPanel
    implements ActionListener {
        private PluginInfo info;
        private JButton startButton;
        private JCheckBox startCheckBox;
        private JButton stopButton;
        private JButton errorButton;

        PluginActivationPanel() {
            this.initComponents();
            this.setPlugin(null);
        }

        private void initComponents() {
            this.startCheckBox = new JCheckBox();
            this.startButton = new JButton();
            this.stopButton = new JButton();
            this.errorButton = new JButton();
            this.setLayout(new GridBagLayout());
            this.startCheckBox.setText("Load when application starts");
            this.startCheckBox.addActionListener(this);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            this.add((Component)this.startCheckBox, gridBagConstraints);
            this.startButton.setText("Start");
            this.startButton.addActionListener(this);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 20, 0, 0);
            this.add((Component)this.startButton, gridBagConstraints);
            this.stopButton.setText("Stop");
            this.stopButton.addActionListener(this);
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            this.add((Component)this.stopButton, gridBagConstraints);
            this.errorButton.setText("Show Error...");
            this.errorButton.addActionListener(this);
            this.add((Component)this.errorButton, gridBagConstraints);
        }

        final void setPlugin(PluginInfo info) {
            this.info = info;
            this.setEnable();
        }

        private void setEnable() {
            if (this.info == null) {
                this.startCheckBox.setEnabled(false);
                this.startButton.setEnabled(false);
                this.stopButton.setEnabled(false);
                this.errorButton.setEnabled(false);
            } else {
                Plugin plugin;
                this.startCheckBox.setEnabled(true);
                this.startCheckBox.setSelected(this.info.isLoadAtStart());
                PluginInfo loaded = (PluginInfo)InstalledPluginPanel.this.loadedPlugins.get(this.info.getName());
                Plugin plugin2 = plugin = loaded == null ? null : loaded.getPlugin();
                if (loaded == null) {
                    this.startButton.setText("Load");
                    this.startButton.setEnabled(this.info.getErrorStatus() == null && !InstalledPluginPanel.this.loadedPlugins.containsKey(this.info.getName()));
                    this.errorButton.setEnabled(this.info.getErrorStatus() != null);
                } else {
                    this.startButton.setText("Start");
                    this.startButton.setEnabled(plugin == null && loaded.hasMainClass() && loaded.getErrorStatus() == null);
                    this.errorButton.setEnabled(this.info.getErrorStatus() != null || loaded.getErrorStatus() != null);
                }
                this.stopButton.setEnabled(plugin != null && plugin.canBeShutDown());
            }
        }

        private void startCheckBoxActionPerformed(ActionEvent evt) {
            this.info.setLoadAtStart(this.startCheckBox.isSelected());
        }

        private void stopButtonActionPerformed(ActionEvent evt) {
            InstalledPluginPanel.this.manager.getApplication().stopPlugin(this.info);
            this.setEnable();
            InstalledPluginPanel.this.repaint();
        }

        private void startButtonActionPerformed(ActionEvent evt) {
            try {
                if (evt.getActionCommand().equals("Start")) {
                    InstalledPluginPanel.this.manager.getApplication().startPlugin(this.info);
                } else {
                    InstalledPluginPanel.this.manager.getApplication().loadPlugins(Collections.singletonList(this.info));
                }
                InstalledPluginPanel.this.cl.stateChanged(null);
                this.setEnable();
                InstalledPluginPanel.this.repaint();
            }
            catch (Throwable t) {
                JDialog parent = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, this);
                Studio.error(parent, "Error starting plugin", t);
            }
        }

        private void errorButtonActionPerformed(ActionEvent evt) {
            JDialog parent = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, this);
            Throwable t = this.info.getErrorStatus();
            if (t == null) {
                PluginInfo loaded = (PluginInfo)InstalledPluginPanel.this.loadedPlugins.get(this.info.getName());
                if (loaded != null) {
                    t = loaded.getErrorStatus();
                }
                if (t == null) {
                    return;
                }
            }
            ErrorDialog.ErrorDetailsDialog dlg = new ErrorDialog.ErrorDetailsDialog(parent, t);
            dlg.setDefaultCloseOperation(2);
            dlg.pack();
            dlg.setLocationRelativeTo((Component)parent);
            dlg.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object source = actionEvent.getSource();
            if (source == this.startCheckBox) {
                this.startCheckBoxActionPerformed(actionEvent);
            } else if (source == this.startButton) {
                this.startButtonActionPerformed(actionEvent);
            } else if (source == this.stopButton) {
                this.stopButtonActionPerformed(actionEvent);
            } else if (source == this.errorButton) {
                this.errorButtonActionPerformed(actionEvent);
            }
        }
    }
}

