/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultButtonModel;
import javax.swing.Timer;

class MachineGunButtonModel
extends DefaultButtonModel
implements ActionListener {
    private int initialDelay = 500;
    private int delay = 50;
    private Timer timer;

    MachineGunButtonModel() {
    }

    @Override
    public void setPressed(boolean b) {
        if (!b && this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
        if (this.isPressed() == b || !this.isEnabled()) {
            return;
        }
        this.stateMask = b ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
        if (this.isPressed() && this.isArmed()) {
            this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
        }
        if (this.timer == null && this.isPressed() && this.delay > 0) {
            this.timer = new Timer(this.delay, this);
            this.timer.setInitialDelay(this.initialDelay);
        }
        if (this.isPressed()) {
            this.timer.start();
        }
        this.fireStateChanged();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isEnabled() && this.isArmed() && this.isPressed()) {
            this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
        }
    }

    public int getRepeatDelay() {
        return this.delay;
    }

    public int getInitialDelay() {
        return this.initialDelay;
    }

    public void setRepeatDelay(int delay) {
        if (delay < 0) {
            throw new IllegalArgumentException("Invalid repeatDelay set");
        }
        this.delay = delay;
    }

    public void setInitialDelay(int initialDelay) {
        if (initialDelay < 0) {
            throw new IllegalArgumentException("Invalid initialDelay set");
        }
        this.initialDelay = initialDelay;
    }
}

