/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.studio;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.freehep.application.studio.ExtensionClassLoader;
import org.freehep.application.studio.LibInfo;
import org.freehep.application.studio.PluginDir;
import org.freehep.application.studio.PluginInfo;
import org.freehep.application.studio.Studio;
import org.freehep.util.VersionComparator;

public class PluginMap {
    protected Studio app;
    protected EnumMap<PluginDir, Map<String, PluginInfo>> pluginMap = new EnumMap(PluginDir.class);
    protected EnumMap<PluginDir, Map<String, LibInfo>> libMap = new EnumMap(PluginDir.class);
    protected ArrayList<LibInfo> duplicateLibraries;
    protected EnumMap<PluginDir, Map<String, String>> name2id = new EnumMap(PluginDir.class);
    private static final String ID_MAP_NAME = "library.map";

    public PluginMap(Studio application) {
        this.app = application;
        this.duplicateLibraries = new ArrayList();
        for (PluginDir extdir : PluginDir.values()) {
            this.scanDirectory(extdir);
        }
        if (this.duplicateLibraries.isEmpty()) {
            this.duplicateLibraries = null;
        } else {
            this.duplicateLibraries.trimToSize();
        }
    }

    protected PluginMap(Collection<PluginInfo> plugins) {
        for (PluginInfo plugin : plugins) {
            PluginDir dir = (plugin = new PluginInfo(plugin)).getDirectory();
            Map<String, PluginInfo> dirMapPlugin = this.pluginMap.get((Object)dir);
            if (dirMapPlugin == null) {
                dirMapPlugin = new LinkedHashMap<String, PluginInfo>();
                this.pluginMap.put(dir, dirMapPlugin);
            }
            dirMapPlugin.put(plugin.getName(), plugin);
            Map<String, LibInfo> dirMapLib = this.libMap.get((Object)dir);
            if (dirMapLib == null) {
                dirMapLib = new LinkedHashMap<String, LibInfo>();
                this.libMap.put(dir, dirMapLib);
            }
            for (LibInfo lib : plugin.getLibraries()) {
                lib = new LibInfo(lib);
                lib.setDir(dir);
                LibInfo other = dirMapLib.get(lib.getId());
                if (other != null && other.getVersion() != null && (lib.getVersion() == null || VersionComparator.compareVersion((String)lib.getVersion(), (String)other.getVersion()) <= 0)) continue;
                dirMapLib.put(lib.getId(), lib);
            }
        }
    }

    private void scanDirectory(PluginDir dir) {
        String dirPath = this.app.getExtensionsDir(dir);
        if (dirPath == null) {
            return;
        }
        File extdir = new File(dirPath);
        if (!extdir.isDirectory()) {
            return;
        }
        File infile = new File(dirPath, ID_MAP_NAME);
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(infile));
            HashMap<String, String> map = new HashMap<String, String>();
            this.name2id.put(dir, map);
            while ((line = reader.readLine()) != null) {
                String[] mapping = line.trim().split("\\s");
                if (mapping.length != 2) continue;
                map.put(mapping[0], mapping[1]);
            }
            reader.close();
        }
        catch (FileNotFoundException x) {
            this.name2id.remove((Object)dir);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
        HashMap<String, PluginInfo> loadedPlugins = new HashMap<String, PluginInfo>();
        for (PluginInfo plugin : this.app.getPlugins()) {
            if (plugin.getDirectory() != dir) continue;
            loadedPlugins.put(plugin.getName(), plugin);
        }
        LinkedHashMap<String, PluginInfo> dirMapPlug = new LinkedHashMap<String, PluginInfo>();
        LinkedHashMap<String, LibInfo> dirMapLib = new LinkedHashMap<String, LibInfo>();
        String[] files = extdir.list();
        for (int i = 0; i < files.length; ++i) {
            String file = files[i];
            if (!file.endsWith(".jar") && !file.endsWith(".tmp")) continue;
            File f = new File(extdir, file);
            if (f.length() > 0L) {
                try {
                    JarFile jarFile = new JarFile(f);
                    JarEntry manifest = jarFile.getJarEntry("PLUGIN-inf/plugins.xml");
                    if (manifest != null) {
                        InputStream in = jarFile.getInputStream(manifest);
                        List<PluginInfo> newPlugins = this.app.buildPluginList(in);
                        for (PluginInfo plugin : newPlugins) {
                            PluginInfo prev;
                            plugin.setDirectory(dir);
                            if (!plugin.isApplicationCompatible(this.app) || !plugin.isJavaCompatible() || (prev = (PluginInfo)dirMapPlug.get(plugin.getName())) != null && VersionComparator.compareVersion((String)prev.getVersion(), (String)plugin.getVersion()) >= 0) continue;
                            PluginInfo loaded = (PluginInfo)loadedPlugins.get(plugin.getName());
                            if (loaded != null && VersionComparator.compareVersion((String)loaded.getVersion(), (String)plugin.getVersion()) == 0) {
                                plugin = loaded;
                            }
                            dirMapPlug.put(plugin.getName(), plugin);
                        }
                    }
                    jarFile.close();
                    LibInfo library = new LibInfo(f, dir);
                    LibInfo prev = (LibInfo)dirMapLib.get(library.getId());
                    if (prev == null) {
                        dirMapLib.put(library.getId(), library);
                        continue;
                    }
                    if (prev.getVersion() == null || library.getVersion() != null && VersionComparator.compareVersion((String)library.getVersion(), (String)prev.getVersion()) > 0) {
                        dirMapLib.put(library.getId(), library);
                        this.duplicateLibraries.add(prev);
                        continue;
                    }
                    this.duplicateLibraries.add(library);
                }
                catch (IOException x) {
                    System.err.println("Error reading extension file " + file + " : " + x);
                }
                continue;
            }
            f.delete();
        }
        boolean checkAgain = true;
        while (checkAgain) {
            checkAgain = false;
            ArrayList plugins = new ArrayList(dirMapPlug.values());
            block10: for (PluginInfo plugin : plugins) {
                for (String name : plugin.getRequiredPluginNames()) {
                    PluginInfo req = (PluginInfo)dirMapPlug.get(name);
                    if (req == null) {
                        req = this.getPlugin(name, PluginDir.BUILTIN);
                    }
                    String min = plugin.getRequiredPluginMinVersion(name);
                    String max = plugin.getRequiredPluginMaxVersion(name);
                    if (req != null && (min == null || VersionComparator.compareVersion((String)min, (String)req.getVersion()) <= 0) && (max == null || VersionComparator.compareVersion((String)max, (String)req.getVersion()) >= 0)) continue;
                    checkAgain = true;
                    dirMapPlug.remove(plugin.getName());
                    break;
                }
                for (LibInfo lib : plugin.getLibraries()) {
                    String id = this.getId(lib);
                    if (dirMapLib.get(id) != null || this.getLibrary(id, PluginDir.BUILTIN) != null) continue;
                    checkAgain = true;
                    dirMapPlug.remove(plugin.getName());
                    continue block10;
                }
            }
        }
        if (!dirMapPlug.isEmpty() || !this.libMap.isEmpty()) {
            this.pluginMap.put(dir, dirMapPlug);
            this.libMap.put(dir, dirMapLib);
        }
    }

    public PluginMap add(Collection<PluginInfo> plugins) {
        ArrayList<PluginInfo> pluginsToBeInstalled = new ArrayList<PluginInfo>(plugins.size());
        for (PluginInfo plugin : plugins) {
            PluginInfo installed = this.getPlugin(plugin.getName(), plugin.getDirectory());
            if (installed != null && VersionComparator.compareVersion((String)installed.getVersion(), (String)plugin.getVersion()) >= 0) continue;
            pluginsToBeInstalled.add(plugin);
        }
        PluginMap updateMap = new PluginMap(pluginsToBeInstalled);
        for (LibInfo candidate : updateMap.getLibraries()) {
            LibInfo installed = this.getLibrary(candidate.getId(), candidate.getDir());
            String candidateVersion = candidate.getVersion();
            if (installed != null && installed.getVersion() != null && candidateVersion != null && VersionComparator.compareVersion((String)installed.getVersion(), (String)candidateVersion) >= 0) continue;
            candidate.setFile(this.makePath(candidate, "tmp"));
        }
        return updateMap;
    }

    public boolean commit(PluginMap update) {
        boolean restart = false;
        LinkedHashSet<File> classpath = new LinkedHashSet<File>();
        for (PluginInfo plugin : update.getPlugins()) {
            restart = restart || this.isLoaded(plugin);
            this.addPlugin(plugin);
        }
        for (LibInfo candidate : update.getLibraries()) {
            if (candidate.getFile() == null) continue;
            if (candidate.getVersion() == null) {
                String id;
                String oldId = candidate.getId();
                if (candidate.checkMavenID() && !(id = candidate.getId()).equals(oldId)) {
                    File renameTo = this.makePath(candidate, "tmp");
                    if (candidate.getFile().renameTo(renameTo)) {
                        candidate.setFile(renameTo.getAbsoluteFile());
                        update.idMapPut(candidate.getDir(), oldId, id);
                    }
                }
            }
            LibInfo installed = this.getLibrary(candidate.getId(), candidate.getDir());
            String candidateVersion = candidate.getVersion();
            if (installed == null || installed.getVersion() == null || candidateVersion == null || VersionComparator.compareVersion((String)installed.getVersion(), (String)candidateVersion) < 0) {
                restart = this.addLibrary(candidate) || restart;
                if (restart) continue;
                classpath.add(candidate.getFile());
                continue;
            }
            candidate.getFile().delete();
        }
        for (LibInfo lib : this.getLibraries()) {
            if (lib.getDir() == PluginDir.BUILTIN || !this.getReferencingPlugins(lib).isEmpty()) continue;
            restart = this.removeLibrary(lib) || restart;
        }
        this.updateIdMap(update);
        return restart;
    }

    public boolean remove(Collection<PluginInfo> plugins) {
        boolean restart = false;
        for (PluginInfo plugin : plugins) {
            restart = this.isLoaded(plugin) || restart;
            this.removePlugin(plugin);
        }
        for (LibInfo lib : this.getLibraries()) {
            if (lib.getDir() == PluginDir.BUILTIN || !this.getReferencingPlugins(lib).isEmpty()) continue;
            restart = this.removeLibrary(lib) || restart;
        }
        this.updateIdMap(null);
        return restart;
    }

    public Map<File, String> getDownloads() {
        HashMap<File, String> out = new HashMap<File, String>();
        for (LibInfo lib : this.getLibraries()) {
            if (lib.getFile() == null) continue;
            out.put(lib.getFile(), lib.getHref());
        }
        return out;
    }

    public void purge() {
        if (this.duplicateLibraries != null) {
            for (LibInfo lib : this.duplicateLibraries) {
                lib.getFile().delete();
            }
            this.duplicateLibraries = null;
        }
        for (LibInfo lib : this.getLibraries()) {
            if (lib.getDir() == PluginDir.BUILTIN || !this.getReferencingPlugins(lib).isEmpty()) continue;
            this.removeLibrary(lib);
        }
        for (LibInfo lib : this.getLibraries()) {
            File newFile;
            File file = lib.getFile();
            String path = file.getPath();
            if (!path.endsWith(".tmp") || this.isLoaded(newFile = new File(path = path.substring(0, path.length() - 4) + ".jar")) || !file.renameTo(newFile)) continue;
            lib.setFile(newFile.getAbsoluteFile());
        }
    }

    public Map<String, PluginInfo> getActivePlugins() {
        HashMap<String, PluginInfo> out = new HashMap<String, PluginInfo>();
        for (PluginDir dir : PluginDir.inverseSearchOrder()) {
            Map<String, PluginInfo> dirMap = this.pluginMap.get((Object)dir);
            if (dirMap == null) continue;
            for (Map.Entry<String, PluginInfo> entry : dirMap.entrySet()) {
                out.put(entry.getKey(), entry.getValue());
            }
        }
        boolean checkAgain = true;
        block2: while (checkAgain) {
            checkAgain = false;
            PluginInfo problem = null;
            for (PluginInfo plugin : out.values()) {
                Set<String> dep;
                if (plugin.getDirectory() == PluginDir.BUILTIN || (dep = plugin.getRequiredPluginNames()).isEmpty()) continue;
                for (String name : dep) {
                    PluginInfo active = (PluginInfo)out.get(name);
                    if (active != null && plugin.isRequiredPluginValid(active)) continue;
                    checkAgain = true;
                    break;
                }
                if (!checkAgain) continue;
                problem = plugin;
                out.remove(problem.getName());
                break;
            }
            if (!checkAgain) continue;
            for (PluginDir dir : PluginDir.inverseSearchOrder()) {
                Set<String> dep;
                PluginInfo replacement = this.getPlugin(problem.getName(), dir);
                if (replacement != null && replacement != problem && !(dep = replacement.getRequiredPluginNames()).isEmpty()) {
                    for (String name : dep) {
                        PluginInfo active = (PluginInfo)out.get(name);
                        if (active != null && replacement.isRequiredPluginValid(active)) continue;
                        replacement = null;
                        break;
                    }
                }
                if (replacement == null) continue;
                out.put(replacement.getName(), replacement);
                continue block2;
            }
        }
        return out;
    }

    public Map<String, LibInfo> getActiveLibraries() {
        HashMap<String, EnumSet<PluginDir>> id2plugins = new HashMap<String, EnumSet<PluginDir>>();
        for (PluginInfo plugin : this.getActivePlugins().values()) {
            for (LibInfo lib : plugin.getLibraries()) {
                String id = this.getId(lib);
                PluginDir dir = plugin.getDirectory();
                EnumSet<PluginDir> dirSet = (EnumSet<PluginDir>)id2plugins.get(id);
                if (dirSet == null) {
                    dirSet = EnumSet.of(dir);
                    id2plugins.put(id, dirSet);
                    continue;
                }
                dirSet.add(dir);
            }
        }
        HashMap<String, LibInfo> out = new HashMap<String, LibInfo>();
        for (Map.Entry e : id2plugins.entrySet()) {
            String id = (String)e.getKey();
            LibInfo lib = this.getLibrary(id, PluginDir.BUILTIN);
            if (lib == null) {
                LibInfo candidate;
                PluginDir dir;
                EnumSet dirSet = (EnumSet)e.getValue();
                PluginDir[] arr$ = PluginDir.searchOrder();
                int len$ = arr$.length;
                for (int i$ = 0; !(i$ >= len$ || dirSet.contains((Object)(dir = arr$[i$])) && (candidate = this.getLibrary(id, dir)) != null && (lib == null || candidate.getVersion() != null && VersionComparator.compareVersion((String)lib.getVersion(), (String)candidate.getVersion()) < 0) && (lib = candidate).getVersion() == null); ++i$) {
                }
            }
            out.put(id, lib);
        }
        return out;
    }

    public URL[] getExtensionClasspath() {
        Map<String, LibInfo> al = this.getActiveLibraries();
        URL[] out = new URL[al.size()];
        int i = out.length;
        try {
            for (LibInfo lib : al.values()) {
                out[--i] = lib.getFile().toURI().toURL();
            }
        }
        catch (MalformedURLException x) {
            throw new RuntimeException(x);
        }
        return out;
    }

    public List<PluginInfo> getPlugins() {
        ArrayList<PluginInfo> out = new ArrayList<PluginInfo>(20);
        for (Map<String, PluginInfo> dirMap : this.pluginMap.values()) {
            if (dirMap == null) continue;
            for (PluginInfo plugin : dirMap.values()) {
                out.add(plugin);
            }
        }
        return out;
    }

    public Map<String, PluginInfo> getPlugins(PluginDir dir) {
        if (dir == null) {
            return this.getActivePlugins();
        }
        Map<String, PluginInfo> out = this.pluginMap.get((Object)dir);
        return out == null ? Collections.emptyMap() : Collections.unmodifiableMap(out);
    }

    public PluginInfo getPlugin(String name) {
        for (PluginDir dir : PluginDir.searchOrder()) {
            PluginInfo plugin = this.getPlugin(name, dir);
            if (plugin == null) continue;
            return plugin;
        }
        return null;
    }

    public PluginInfo getPlugin(String name, PluginDir dir) {
        Map<String, PluginInfo> dirMap = this.pluginMap.get((Object)dir);
        return dirMap == null ? null : dirMap.get(name);
    }

    public List<LibInfo> getLibraries() {
        ArrayList<LibInfo> out = new ArrayList<LibInfo>(50);
        for (Map<String, LibInfo> dirMap : this.libMap.values()) {
            if (dirMap == null) continue;
            for (LibInfo lib : dirMap.values()) {
                out.add(lib);
            }
        }
        return out;
    }

    public LibInfo getLibrary(String id, PluginDir dir) {
        Map<String, LibInfo> dirMap = this.libMap.get((Object)dir);
        return dirMap == null ? null : dirMap.get(id);
    }

    public Set<PluginInfo> getDependentPlugins(PluginInfo plugin) {
        HashSet<PluginInfo> out = new HashSet<PluginInfo>();
        Map<String, PluginInfo> all = this.getPlugins(plugin.getDirectory());
        this.findDependentPlugins(plugin, out, all);
        return out;
    }

    private void findDependentPlugins(PluginInfo plugin, Set<PluginInfo> out, Map<String, PluginInfo> all) {
        for (PluginInfo p : all.values()) {
            if (!p.getRequiredPluginNames().contains(plugin.getName()) || !out.add(p)) continue;
            this.findDependentPlugins(p, out, all);
        }
    }

    protected void removePlugin(PluginInfo plugin) {
        Map<String, PluginInfo> dirMap = this.pluginMap.get((Object)plugin.getDirectory());
        if (dirMap != null) {
            dirMap.remove(plugin.getName());
            if (dirMap.isEmpty()) {
                this.pluginMap.remove((Object)plugin.getDirectory());
            }
        }
    }

    protected void addPlugin(PluginInfo plugin) {
        Map<String, PluginInfo> dirMap = this.pluginMap.get((Object)plugin.getDirectory());
        if (dirMap == null) {
            dirMap = new LinkedHashMap<String, PluginInfo>();
            this.pluginMap.put(plugin.getDirectory(), dirMap);
        }
        dirMap.put(plugin.getName(), plugin);
    }

    protected boolean removeLibrary(LibInfo library) {
        boolean restart = false;
        Map<String, LibInfo> dirMap = this.libMap.get((Object)library.getDir());
        if (dirMap != null) {
            File file;
            LibInfo lib = dirMap.remove(library.getId());
            if (dirMap.isEmpty()) {
                this.libMap.remove((Object)library.getDir());
            }
            if (lib != null && (file = lib.getFile()) != null) {
                if (this.isLoaded(file)) {
                    this.markFileForDeletion(file);
                    restart = true;
                } else if (file.delete()) {
                    restart = false;
                } else {
                    this.markFileForDeletion(file);
                    restart = true;
                }
            }
        }
        return restart;
    }

    protected boolean addLibrary(LibInfo library) {
        boolean restart = false;
        Map<String, LibInfo> dirMap = this.libMap.get((Object)library.getDir());
        if (dirMap == null) {
            dirMap = new LinkedHashMap<String, LibInfo>();
            this.libMap.put(library.getDir(), dirMap);
        } else {
            LibInfo old = dirMap.get(library.getId());
            if (old != null) {
                File oldFile = old.getFile();
                restart = this.isLoaded(oldFile) ? true : !oldFile.delete() || restart;
            }
        }
        dirMap.put(library.getId(), library);
        if (!restart && library.getFile().getName().endsWith(".tmp")) {
            File renameTo = this.makePath(library, "jar");
            boolean bl = restart = this.isLoaded(renameTo) || !library.getFile().renameTo(renameTo);
            if (!restart) {
                library.setFile(renameTo);
            }
        }
        return restart;
    }

    protected Set<PluginInfo> getReferencingPlugins(LibInfo library) {
        Set<PluginInfo> out = Collections.newSetFromMap(new IdentityHashMap());
        PluginDir dir = library.getDir();
        Map<String, PluginInfo> dirMap = this.getPlugins(dir);
        for (PluginInfo plugin : dirMap.values()) {
            for (LibInfo lib : plugin.getLibraries()) {
                if (!library.getId().equals(this.getId(lib))) continue;
                out.add(plugin);
            }
        }
        return out;
    }

    protected String idMapPut(PluginDir dir, String name, String id) {
        Map<String, String> dirMap = this.name2id.get((Object)dir);
        if (dirMap == null) {
            dirMap = new HashMap<String, String>();
            this.name2id.put(dir, dirMap);
        }
        return dirMap.put(name, id);
    }

    protected String idMapRemove(PluginDir dir, String name) {
        Map<String, String> dirMap = this.name2id.get((Object)dir);
        if (dirMap == null) {
            return null;
        }
        String out = dirMap.remove(name);
        if (dirMap.isEmpty()) {
            this.name2id.remove((Object)dir);
        }
        return out;
    }

    protected String idMapGet(PluginDir dir, String name) {
        Map<String, String> dirMap = this.name2id.get((Object)dir);
        if (dirMap == null) {
            return name;
        }
        String id = dirMap.get(name);
        return id == null ? name : id;
    }

    protected String getId(LibInfo library) {
        String id = library.getId();
        if (library.getVersion() == null) {
            id = this.idMapGet(library.getDir(), id);
        }
        return id;
    }

    protected File makePath(LibInfo library, String extension) {
        String version = library.getVersion();
        StringBuilder sb = new StringBuilder(library.getId());
        if (version != null) {
            sb.append('-').append(version);
        }
        sb.append('.').append(extension);
        File out = new File(this.app.getExtensionsDir(library.getDir()), sb.toString());
        return out.getAbsoluteFile();
    }

    protected boolean isLoaded(File file) {
        ExtensionClassLoader loader = this.app.getExtensionLoader();
        if (loader == null) {
            return false;
        }
        URL[] classpath = loader.getURLs();
        try {
            URL url = file.toURI().toURL();
            for (URL u : classpath) {
                if (!u.equals(url)) continue;
                return true;
            }
            return false;
        }
        catch (MalformedURLException x) {
            throw new IllegalArgumentException(x);
        }
    }

    protected boolean isLoaded(PluginInfo plugin) {
        String name = plugin.getName();
        PluginDir dir = plugin.getDirectory();
        for (PluginInfo loaded : this.app.getPlugins()) {
            if (!name.equals(loaded.getName()) || dir != loaded.getDirectory()) continue;
            return true;
        }
        return false;
    }

    protected void updateIdMap(PluginMap update) {
        Map<String, String> n2id;
        EnumSet<PluginDir> changed = EnumSet.noneOf(PluginDir.class);
        if (update != null && !update.name2id.isEmpty()) {
            for (PluginDir dir : PluginDir.values()) {
                Map<String, String> dirMap = update.name2id.get((Object)dir);
                if (dirMap == null) continue;
                for (Map.Entry<String, String> e : dirMap.entrySet()) {
                    String old = this.idMapPut(dir, e.getKey(), e.getValue());
                    if (old != null && old.equals(e.getValue())) continue;
                    changed.add(dir);
                }
            }
        }
        for (PluginDir dir : changed) {
            Map<String, PluginInfo> pn2pi = this.pluginMap.get((Object)dir);
            if (pn2pi == null) {
                this.name2id.remove((Object)dir);
            }
            if ((n2id = this.name2id.get((Object)dir)) == null) break;
            HashSet<String> ids = new HashSet<String>();
            for (PluginInfo plugin : pn2pi.values()) {
                for (LibInfo lib : plugin.getLibraries()) {
                    if (lib.getVersion() != null) continue;
                    ids.add(lib.getId());
                }
            }
            Iterator<Map.Entry<String, String>> it = n2id.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> e;
                e = it.next();
                if (ids.contains(e.getKey())) continue;
                it.remove();
            }
            if (!n2id.isEmpty()) continue;
            this.pluginMap.remove((Object)dir);
        }
        for (PluginDir dir : changed) {
            File f = new File(this.app.getExtensionsDir(dir), ID_MAP_NAME);
            f.delete();
            n2id = this.name2id.get((Object)dir);
            if (n2id == null) continue;
            try {
                PrintWriter pw = new PrintWriter(f);
                for (Map.Entry<String, String> e : n2id.entrySet()) {
                    pw.println((String)e.getKey() + " " + (String)e.getValue());
                }
                pw.close();
            }
            catch (FileNotFoundException x) {
                throw new IllegalArgumentException(x);
            }
        }
    }

    protected boolean markFileForDeletion(File file) {
        try {
            new FileOutputStream(file).close();
            return true;
        }
        catch (IOException x) {
            return false;
        }
    }
}

