/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.demo.main;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.RaisedAlertSummary;
import org.lsst.ccs.bus.messages.StatusAlert;
import org.lsst.ccs.bus.messages.StatusCommandDictionary;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusDataProviderDictionary;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.StatusMessageListener;

public class SubsystemMemoryTest
extends Subsystem
implements HasLifecycle,
StatusMessageListener {
    private final Map<String, DataProviderDictionary> dataDictionary = new ConcurrentHashMap<String, DataProviderDictionary>();
    private final Map<String, Map<String, Dictionary>> commandDictionary = new ConcurrentHashMap<String, Map<String, Dictionary>>();
    private final Map<String, StateBundle> stateBundle = new ConcurrentHashMap<String, StateBundle>();
    private final Map<String, ConfigurationInfo> configurationInfo = new ConcurrentHashMap<String, ConfigurationInfo>();
    private final Map<String, Map<String, String>> configurationData = new ConcurrentHashMap<String, Map<String, String>>();
    private final Map<String, RaisedAlertSummary> alertSummary = new ConcurrentHashMap<String, RaisedAlertSummary>();

    public SubsystemMemoryTest() {
        super("mem-test", AgentInfo.AgentType.SERVICE);
    }

    public void preStart() {
        this.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this);
    }

    public void onStatusMessage(StatusMessage msg) {
        String agentName = msg.getOriginAgentInfo().getName();
        this.stateBundle.put(agentName, msg.getState());
        if (msg instanceof StatusDataProviderDictionary) {
            this.dataDictionary.put(agentName, ((StatusDataProviderDictionary)msg).getDataProviderDictionary());
        } else if (msg instanceof StatusCommandDictionary) {
            this.commandDictionary.put(agentName, ((StatusCommandDictionary)msg).getDictionary());
        } else if (msg instanceof StatusConfigurationInfo) {
            ConfigurationInfo ci = ((StatusConfigurationInfo)msg).getConfigurationInfo();
            this.configurationInfo.put(agentName, ci);
            HashMap<String, String> configData = new HashMap<String, String>();
            for (ConfigurationParameterInfo parInfo : ci.getAllParameterInfo()) {
                configData.put(parInfo.getPathName(), parInfo.getConfiguredValue());
            }
            this.configurationData.put(agentName, configData);
        } else if (msg instanceof StatusAlert) {
            this.alertSummary.put(agentName, ((StatusAlert)msg).getRaisedAlertSummary());
        }
    }

    @Command(type=Command.CommandType.QUERY)
    public String printDataSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append("Current sizes of stored data in Kb\n");
        sb.append("Data Dictionary: ").append(SubsystemMemoryTest.sizeOf((Serializable)((Object)this.dataDictionary))).append("\n");
        this.dataDictionary.entrySet().forEach(e -> sb.append("\t").append((String)e.getKey()).append(": ").append(SubsystemMemoryTest.sizeOf((Serializable)e.getValue())).append("\n"));
        sb.append("Command Dictionary: ").append(SubsystemMemoryTest.sizeOf((Serializable)((Object)this.commandDictionary))).append("\n");
        this.commandDictionary.entrySet().forEach(e -> sb.append("\t").append((String)e.getKey()).append(": ").append(SubsystemMemoryTest.sizeOf((Serializable)e.getValue())).append("\n"));
        sb.append("StateBundle: ").append(SubsystemMemoryTest.sizeOf((Serializable)((Object)this.stateBundle))).append("\n");
        this.stateBundle.entrySet().forEach(e -> sb.append("\t").append((String)e.getKey()).append(": ").append(SubsystemMemoryTest.sizeOf((Serializable)e.getValue())).append("\n"));
        sb.append("ConfigurationInfo: ").append(SubsystemMemoryTest.sizeOf((Serializable)((Object)this.configurationInfo))).append("\n");
        this.configurationInfo.entrySet().forEach(e -> sb.append("\t").append((String)e.getKey()).append(": ").append(SubsystemMemoryTest.sizeOf((Serializable)e.getValue())).append("\n"));
        sb.append("Configuration Data: ").append(SubsystemMemoryTest.sizeOf((Serializable)((Object)this.configurationData))).append("\n");
        this.configurationData.entrySet().forEach(e -> sb.append("\t").append((String)e.getKey()).append(": ").append(SubsystemMemoryTest.sizeOf((Serializable)e.getValue())).append("\n"));
        sb.append("Alert Summary: ").append(SubsystemMemoryTest.sizeOf((Serializable)((Object)this.alertSummary))).append("\n");
        this.alertSummary.entrySet().forEach(e -> sb.append("\t").append((String)e.getKey()).append(": ").append(SubsystemMemoryTest.sizeOf((Serializable)e.getValue())).append("\n"));
        return sb.toString();
    }

    public static double sizeOf(Serializable object) {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteOutputStream);){
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
        }
        catch (IOException ieo) {
            return 0.0;
        }
        return (double)byteOutputStream.toByteArray().length / 1024.0;
    }
}

