/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.demo.main;

import hep.aida.IAnalysisFactory;
import hep.aida.IDataPointSetFactory;
import hep.aida.IHistogramFactory;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.Persist;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.demo.bus.DemoData;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;
import org.lsst.ccs.utilities.scheduler.Scheduler;

public class DemoSubsystem
extends Subsystem
implements HasLifecycle {
    protected PeriodicTask dataPublisher;
    private final IAnalysisFactory af = IAnalysisFactory.create();
    private final IDataPointSetFactory dataPointSetFactory = this.af.createDataPointSetFactory(null);
    private final IHistogramFactory histogramFactory = this.af.createHistogramFactory(null);
    private final Random r = new Random();
    private final ArrayList<PeriodicTask> tracerTestTasks = new ArrayList();
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TOP)
    protected Subsystem subsys;
    @Persist
    private String somePersistStr = "abc";
    private int dataPublishRate = 5;
    private int dataSize = 2;
    private volatile long taskSleep = 0L;
    private volatile int numberOfExceptions = 0;
    @ConfigurationParameter(isBuild=true)
    private volatile String buildPar = "someValue";

    public DemoSubsystem() {
        super("demo-subsystem", AgentInfo.AgentType.WORKER);
        this.getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
    }

    public void postStart() {
        this.updateLimits("1.0", "2.0");
    }

    public void postInit() {
        ((AgentPropertiesService)this.subsys.getAgentService(AgentPropertiesService.class)).setAgentProperty("agentCategory", "demo");
        this.subsys.getAgentPersistenceService().setAutomatic(true, true);
    }

    public void build() {
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask("demoData-publish", () -> {
            if (this.numberOfExceptions > 0) {
                --this.numberOfExceptions;
                throw new RuntimeException("An Exception");
            }
            if (this.taskSleep <= 0L) {
                this.subsys.publishSubsystemDataOnStatusBus(this.getDemoDataToPublish("fixedRate"));
            } else {
                try {
                    Thread.sleep(this.taskSleep);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }).withIsFixedRate(true).withPeriod(Duration.ofSeconds(this.dataPublishRate)));
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask("demoData-publish-fixedDelay", () -> {
            if (this.taskSleep <= 0L) {
                this.subsys.publishSubsystemDataOnStatusBus(this.getDemoDataToPublish("fixedDelay"));
            } else {
                try {
                    Thread.sleep(this.taskSleep);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }).withIsFixedRate(false).withPeriod(Duration.ofSeconds(this.dataPublishRate)));
    }

    @Command(type=Command.CommandType.ACTION)
    public void setNumberOfExceptionInMonitoringThread(int nExeptions) {
        this.numberOfExceptions = nExeptions;
    }

    @Command(type=Command.CommandType.ACTION)
    public void setPeriodicTaskSleepTime(long sleep) {
        this.taskSleep = sleep;
    }

    public void init() {
        ((DataProviderDictionaryService)this.subsys.getAgentService(DataProviderDictionaryService.class)).registerData(this.getDemoDataToPublish("fixedRate"));
        ((DataProviderDictionaryService)this.subsys.getAgentService(DataProviderDictionaryService.class)).registerData(this.getDemoDataToPublish("fixedDelay"));
    }

    private KeyValueData getDemoDataToPublish(String prefix) {
        DemoData dd = new DemoData(this.dataSize);
        KeyValueData d = new KeyValueData(prefix + "_demo_Data", (Serializable)dd);
        KeyValueDataList kvdl = new KeyValueDataList();
        kvdl.addData(d);
        return kvdl;
    }

    @Command(type=Command.CommandType.ACTION, description="update limits")
    public void updateLimits(String low, String high) {
        KeyValueDataList limits = new KeyValueDataList("demo_Data/temp");
        limits.addData("alarmLow", (Serializable)((Object)low), KeyValueData.KeyValueDataType.KeyValueMetaData);
        limits.addData("alarmHigh", (Serializable)((Object)high), KeyValueData.KeyValueDataType.KeyValueMetaData);
        this.subsys.publishSubsystemDataOnStatusBus((KeyValueData)limits);
    }

    @Command(type=Command.CommandType.QUERY, description="raise custom alert")
    public void raiseCustomAlert(String alertId, AlertState severity, String cause) {
        Alert a = new Alert(alertId, "Custom Alert");
        ((AlertService)this.subsys.getAgentService(AlertService.class)).raiseAlert(a, severity, cause);
    }

    @Command(type=Command.CommandType.QUERY, description="Get Subsystem Data Sample")
    public DemoData getSampleData() {
        return new DemoData(this.dataSize);
    }

    @Command(type=Command.CommandType.QUERY, description="Set Subsystem Data Sample")
    public void setSampleDataSize(int size) {
        this.dataSize = size;
    }

    @Command(type=Command.CommandType.QUERY, description="Get Subsystem Array Sample")
    public Object[] getSampleArrayData() {
        Object[] data = new Object[]{"test", 2.3, new int[]{3, 2, 2, 2}};
        return data;
    }

    @Command(type=Command.CommandType.QUERY, description="Throw an Exception")
    public void throwAnException() {
        throw new RuntimeException("An Exception");
    }

    @Command(type=Command.CommandType.ACTION, description="Enable/Disable Publishing Tracer Test Messages")
    public void runTracerTest(boolean enable) {
        if (enable) {
            Scheduler s = this.subsys.getScheduler();
            this.tracerTestTasks.add(s.scheduleAtFixedRate(() -> this.subsys.getLogger().info((Object)("Self test on module " + this.r.nextInt(1000) + (this.r.nextInt(5) > 0 ? ": OK" : ": FAILED"))), 0L, 7L, TimeUnit.SECONDS));
            this.tracerTestTasks.add(s.scheduleAtFixedRate(() -> this.subsys.getLogger().warn((Object)"London Bridge is in trouble, please repair."), 2L, 15L, TimeUnit.SECONDS));
            this.tracerTestTasks.add(s.scheduleAtFixedRate(() -> this.subsys.getLogger().error((Object)"Sun has gone supernova."), 3L, 13L, TimeUnit.SECONDS));
        } else {
            this.tracerTestTasks.forEach(task -> task.cancel(false));
            this.tracerTestTasks.clear();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Time out (action command)")
    public String testTimeout(int sleepSeconds) {
        if (sleepSeconds > 0) {
            try {
                Thread.sleep((long)sleepSeconds * 1000L);
            }
            catch (InterruptedException x) {
                return "Interrupted";
            }
        }
        return "Done.";
    }

    @Command(type=Command.CommandType.QUERY, level=0, category=Command.CommandCategory.USER, description="Empty level 0 category USER type QUERY command")
    public void testUserQuery0() {
    }

    @Command(type=Command.CommandType.ACTION, level=0, category=Command.CommandCategory.USER, description="Empty level 0 category USER type QUERY command")
    public void testUserAction0() {
    }

    @Command(type=Command.CommandType.QUERY, level=1, category=Command.CommandCategory.USER, description="Empty level 0 category USER type QUERY command")
    public void testUserQuery1() {
    }

    @Command(type=Command.CommandType.QUERY, level=0, category=Command.CommandCategory.SYSTEM, description="Empty level 0 category USER type QUERY command")
    public void testSystemQuery0() {
    }

    @Command(type=Command.CommandType.QUERY, level=1, category=Command.CommandCategory.SYSTEM, description="Empty level 0 category USER type QUERY command")
    public void testSystemQuery1() {
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Test sending ACK/NACK. Delays are in seconds.", autoAck=false)
    public Object testCommand(@Argument(description="If false, command is rejected with a NACK.") boolean accept, @Argument(defaultValue="0") int delayBeforeAck, @Argument(description="Delay between ACK and the result.", defaultValue="0") int delayAfterAck, @Argument(defaultValue="0") int timeout, @Argument(defaultValue="false") boolean returnException) {
        if (delayBeforeAck > 0) {
            try {
                Thread.sleep((long)delayBeforeAck * 1000L);
            }
            catch (InterruptedException x) {
                return "Interrupted while waiting to send ACK/NACK";
            }
        }
        if (accept) {
            if (timeout > 0) {
                this.subsys.sendAck(Duration.ofSeconds(timeout));
            } else {
                this.subsys.sendAck(null);
            }
        } else {
            this.subsys.sendNack((Serializable)((Object)"Sending NACK as requested."));
            return "NACK";
        }
        if (delayAfterAck > 0) {
            try {
                Thread.sleep((long)delayAfterAck * 1000L);
            }
            catch (InterruptedException x) {
                return "Interrupted while waiting to send the result";
            }
        }
        if (returnException) {
            return new RuntimeException("Requsted exception result.");
        }
        return "Done.";
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Test various types of command arguments and return types.")
    public Object testCommandArguments(@Argument(name="namedBool", description="boolean argument with name but no default") boolean b1, @Argument(defaultValue="0", description="unnamed int argument with default 0") int varName, @Argument(defaultValue="Che", description="String argument: nickname", name="nickname") String nick, @Argument(description="List of integers") List<Integer> intList, @Argument(description="List of strings") List<String> stringList, @Argument(description="Kind of object to return", allowedValueProvider="testCommandArgumentsReturnTypeValues") String returnType) {
        switch (returnType) {
            case "unknown": {
                return new Unknown();
            }
            case "exception": {
                return new RuntimeException("Exception returned.");
            }
            case "string": {
                return "Done";
            }
            case "short_list": {
                return Arrays.asList("11", "22", "33");
            }
            case "long list": {
                return Arrays.asList("first moderately long line", "shorty", "second (kind of) long line with ()", "The third, extremely long line that almost never ends. Contains a comma, too.");
            }
            case "int array": {
                return new int[]{0, 1, 2, 4};
            }
            case "list of args": {
                ArrayList<String> out = new ArrayList<String>();
                out.add("b1 = " + Boolean.toString(b1));
                out.add("varName = " + Integer.toString(varName));
                out.add("nickname = " + nick);
                out.add("intList = " + String.join((CharSequence)",", intList.stream().map(i -> Integer.toString(i)).collect(Collectors.toList())));
                out.add("stringList = " + String.join((CharSequence)",", stringList));
                out.add("returnType = " + returnType);
                return out;
            }
            case "map_of_args": {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("b1", b1);
                map.put("varName", varName);
                map.put("nickname", nick);
                map.put("intList", intList);
                map.put("stringList", stringList);
                map.put("returnType", returnType);
                return map;
            }
        }
        return "Unexpected value for returnType:" + returnType;
    }

    public List<String> testCommandArgumentsReturnTypeValues() {
        return Arrays.asList("unknown", "exception", "string", "short_list", "long list", "int array", "list of args", "map_of_args");
    }

    @Command(type=Command.CommandType.ACTION)
    public void updateState(String componentName, DemoState state) {
        if ("".equals(componentName)) {
            ((AgentStateService)this.subsys.getAgentService(AgentStateService.class)).updateAgentState(new Enum[]{state});
        } else {
            Object componentToUpdate = this.subsys.getComponentLookup().getComponentByPath(componentName);
            if (componentToUpdate == null) {
                throw new IllegalArgumentException("No component corresponds to path " + componentName);
            }
            ((AgentStateService)this.subsys.getAgentService(AgentStateService.class)).updateAgentComponentState(componentToUpdate, new Enum[]{state});
        }
    }

    private static class Unknown
    implements Serializable {
        private Unknown() {
        }
    }

    public static enum AState {
        A,
        B;

    }

    public static enum OtherState {
        LOW,
        HIGH;

    }

    public static enum DemoState {
        IDLE,
        BUSY;

    }
}

