/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.studio.pluginmanager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.freehep.application.studio.PluginDir;
import org.freehep.application.studio.PluginInfo;
import org.freehep.application.studio.pluginmanager.PluginInfoPanel;
import org.freehep.application.studio.pluginmanager.PluginManager;
import org.freehep.util.images.ImageHandler;

class AvailablePluginPanel
extends JPanel {
    private PluginManager manager;
    private JButton install;
    private JRadioButton cb1;
    private JRadioButton cb2;
    private JRadioButton cb3;
    private JTree tree;
    private PluginInfoPanel infoPanel;
    static final Logger logger = Logger.getLogger(AvailablePluginPanel.class.getName());
    private ActionListener al = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PluginDir dir = null;
            if (AvailablePluginPanel.this.cb1.isSelected()) {
                dir = PluginDir.USER;
            } else if (AvailablePluginPanel.this.cb2.isSelected()) {
                dir = PluginDir.GROUP;
            } else if (AvailablePluginPanel.this.cb3.isSelected()) {
                dir = PluginDir.SYSTEM;
            }
            TreePath[] selected = AvailablePluginPanel.this.tree.getSelectionPaths();
            ArrayList<PluginInfo> selectedPlugins = new ArrayList<PluginInfo>();
            for (TreePath path : selected) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                try {
                    PluginInfo plugin = (PluginInfo)node.getUserObject();
                    plugin.setDirectory(dir);
                    selectedPlugins.add(plugin);
                }
                catch (ClassCastException x) {
                    // empty catch block
                }
            }
            boolean restart = AvailablePluginPanel.this.manager.install(AvailablePluginPanel.this, selectedPlugins);
            if (restart) {
                JOptionPane.showMessageDialog(AvailablePluginPanel.this, "You must restart " + AvailablePluginPanel.this.manager.getApplication().getAppName() + " for these changes to take effect");
            }
        }
    };
    private ChangeListener cl = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            AvailablePluginPanel.this.updateTree();
        }
    };

    AvailablePluginPanel(PluginManager manager) {
        super(new BorderLayout(5, 5));
        this.manager = manager;
        JPanel panel = new JPanel(new GridLayout(1, 2, 5, 5));
        this.tree = new JTree();
        this.tree.setCellRenderer(new Renderer());
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setVisibleRowCount(8);
        this.tree.getSelectionModel().addTreeSelectionListener(new TreeHandler());
        JScrollPane treescroll = new JScrollPane(this.tree);
        treescroll.setBorder(BorderFactory.createTitledBorder("Available Plugins"));
        panel.add(treescroll);
        this.updateTree();
        this.infoPanel = new PluginInfoPanel();
        this.infoPanel.setBorder(BorderFactory.createTitledBorder("Plugin Info"));
        panel.add(this.infoPanel);
        this.add((Component)panel, "Center");
        JPanel bottom = new JPanel(new BorderLayout());
        JPanel cb = new JPanel(new BorderLayout());
        this.cb1 = this.createExtensionButton(PluginDir.USER);
        this.cb2 = this.createExtensionButton(PluginDir.GROUP);
        this.cb3 = this.createExtensionButton(PluginDir.SYSTEM);
        if (this.cb1.isEnabled()) {
            this.cb1.setSelected(true);
        } else if (this.cb2.isEnabled()) {
            this.cb2.setSelected(true);
        } else if (this.cb3.isEnabled()) {
            this.cb3.setSelected(true);
        }
        cb.add((Component)this.cb1, "North");
        cb.add((Component)this.cb2, "Center");
        cb.add((Component)this.cb3, "South");
        ButtonGroup rg = new ButtonGroup();
        rg.add(this.cb1);
        rg.add(this.cb2);
        rg.add(this.cb3);
        bottom.add((Component)cb, "North");
        this.install = new JButton("Install selected plugins");
        this.install.addActionListener(this.al);
        this.install.setEnabled(false);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.install);
        bottom.add((Component)buttonPanel, "South");
        this.add((Component)bottom, "South");
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.manager.addChangeListener(this.cl);
    }

    @Override
    public void removeNotify() {
        this.manager.removeChangeListener(this.cl);
        super.removeNotify();
    }

    private void updateTree() {
        DefaultMutableTreeNode treeRoot = new DefaultMutableTreeNode();
        List<PluginInfo> plugins = this.manager.getInstallablePlugins();
        if (plugins != null) {
            HashMap<List, DefaultMutableTreeNode> map = new HashMap<List, DefaultMutableTreeNode>();
            map.put(Collections.EMPTY_LIST, treeRoot);
            for (PluginInfo info : plugins) {
                List<String[]> categories = info.getCategories();
                if (categories == null) {
                    categories = Collections.singletonList(new String[]{"Uncategorized"});
                }
                for (String[] category : categories) {
                    DefaultMutableTreeNode parent = AvailablePluginPanel.findParent(map, Arrays.asList(category));
                    DefaultMutableTreeNode node = new DefaultMutableTreeNode(info, false);
                    parent.add(node);
                }
            }
        }
        DefaultTreeModel treeModel = new DefaultTreeModel(treeRoot, true);
        this.tree.setModel(treeModel);
    }

    private static DefaultMutableTreeNode findParent(Map map, List category) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)map.get(category);
        if (node != null) {
            return node;
        }
        int size = category.size();
        List parentCategory = category.subList(0, size - 1);
        DefaultMutableTreeNode parent = AvailablePluginPanel.findParent(map, parentCategory);
        DefaultMutableTreeNode child = new DefaultMutableTreeNode(category.get(size - 1));
        parent.add(child);
        map.put(category, child);
        return child;
    }

    private void insertNode(DefaultMutableTreeNode parent, DefaultMutableTreeNode child) {
    }

    private JRadioButton createExtensionButton(PluginDir directory) {
        boolean enabled;
        String dir = this.manager.getApplication().getExtensionsDir(directory);
        boolean bl = enabled = dir != null;
        if (enabled) {
            File df = new File(dir);
            if (!df.exists()) {
                df.mkdirs();
            }
            enabled = df.canWrite();
            try {
                dir = df.getCanonicalPath();
            }
            catch (IOException x) {}
        } else {
            dir = ".";
        }
        JRadioButton rb = new JRadioButton("Install in " + directory.getLabel() + " extensions directory (" + dir + ")");
        rb.setEnabled(enabled);
        return rb;
    }

    private class TreeHandler
    implements TreeSelectionListener {
        private TreeHandler() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent evt) {
            DefaultMutableTreeNode node;
            TreePath selection = evt.getPath();
            DefaultMutableTreeNode defaultMutableTreeNode = node = selection == null ? null : (DefaultMutableTreeNode)selection.getLastPathComponent();
            if (node != null && node.getUserObject() instanceof PluginInfo) {
                PluginInfo plugprops = (PluginInfo)node.getUserObject();
                AvailablePluginPanel.this.infoPanel.setPlugin(plugprops);
            } else {
                AvailablePluginPanel.this.infoPanel.setPlugin(null);
            }
            boolean enabled = false;
            TreePath[] checkselection = AvailablePluginPanel.this.tree.getSelectionPaths();
            if (checkselection != null) {
                for (int i = 0; i < checkselection.length; ++i) {
                    node = (DefaultMutableTreeNode)checkselection[i].getLastPathComponent();
                    if (!(node.getUserObject() instanceof PluginInfo)) continue;
                    enabled = true;
                    break;
                }
            }
            AvailablePluginPanel.this.install.setEnabled(enabled);
        }
    }

    private class Renderer
    extends DefaultTreeCellRenderer {
        private Icon pluginIcon = ImageHandler.getIcon((String)"icons/plugin.gif", AvailablePluginPanel.class);

        private Renderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object info;
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultMutableTreeNode && (info = ((DefaultMutableTreeNode)value).getUserObject()) instanceof PluginInfo) {
                PluginInfo plugleaf = (PluginInfo)info;
                this.setIcon(this.pluginIcon);
                this.setText(plugleaf.getName());
            }
            return this;
        }
    }
}

