import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.demo.main.DemoSubsystemWithMonitoring;
import org.lsst.ccs.subsystem.demo.main.device.DemoDevice;
import org.lsst.ccs.subsystem.demo.main.device.OtherDevice;
import org.lsst.ccs.subsystem.demo.main.device.IonPumps;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Alarm;

CCSBuilder builder = ["demo-subsystem-with-monitoring"]

def nChildren = Integer.valueOf(System.getProperty("org.lsst.ccs.subsystem.demo.nChildren","1"));

taskConfig = ["monitor-update/taskPeriodMillis":1234,"monitor-publish/taskPeriodMillis":2333, "update-component-state/taskPeriodMillis":-1, "update-limits/taskPeriodMillis":-1]

builder.main(DemoSubsystemWithMonitoring, nodeTags:taskConfig) {
    
    Alarm1  (Alarm, [description:"Trips off all power", eventParm:0])

    for ( int j = 0; j < nChildren; j++ ) {

        "$j" (Object) {    

            "DemoDevice$j"  (DemoDevice) {
                for (int i = 0; i < 100; i++) {
                    "DemoChannel$i"  (Channel, description:"channel number $i", format:"f",
                        hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag",
                        limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:10.0, alarmHi:"Alarm1")
//                        limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:10.0, alarmHi:"main/Alarm1")
                }
            }


            OtherDevice (OtherDevice) {
                CryoVac (Channel, description:"Cryostat vacuum", units:"Torr", format:".3g",
                     hwChan:0, limitHi:1000)
                     
                TurboVac (Channel, description:"Turbo pump vacuum", units:"Torr", format:".3g",
                      hwChan:1, limitHi:1000)

                TurboSpeed (Channel, description:"Turbo pump speed", units:"rpm", format:".0f",
                        hwChan:2, type:"Numeric", subtype:"DRIVEFREQ", scale:60, limitHi:100000)
            }   
    
            IonPumps (IonPumps) {
                CIP1_I (Channel, description:"Cryo ion pump 1 current", units:"mA",
                    hwChan:0, type:"CURRENT", scale:1000.0, limitHi:3.2, dbandHi:1.6)

                CIP2_I (Channel, description:"Cryo ion pump 2 current", units:"mA",
                    hwChan:1, type:"CURRENT", scale:1000.0, limitHi:3.2, dbandHi:1.6)

                CIP3_I (Channel, description:"Cryo ion pump 3 current", units:"mA",
                        hwChan:2, type:"CURRENT", scale:1000.0, limitHi:3.2, dbandHi:1.6)

                CIP4_I (Channel, description:"Cryo ion pump 4 current", units:"mA",
                        hwChan:3, type:"CURRENT", scale:1000.0, limitHi:3.2, dbandHi:1.6)
                    
                CIP5_I (Channel, description:"Cryo ion pump 5 current", units:"mA",
                        hwChan:4, type:"CURRENT", scale:1000.0, limitHi:3.2, dbandHi:1.6)
                        
                CIP6_I (Channel, description:"Cryo ion pump 6 current", units:"mA",
                        hwChan:5, type:"CURRENT", scale:1000.0, limitHi:3.2, dbandHi:1.6)

                CIP1_V (Channel, description:"Cryo ion pump 1 voltage", units:"Volts", format:".1f",
                        hwChan:10, type:"VOLTAGE")

                CIP2_V (Channel, description:"Cryo ion pump 2 voltage", units:"Volts", format:".1f",
                        hwChan:11, type:"VOLTAGE")

                CIP3_V (Channel, description:"Cryo ion pump 3 voltage", units:"Volts", format:".1f",
                        hwChan:12, type:"VOLTAGE")

                CIP4_V (Channel, description:"Cryo ion pump 4 voltage", units:"Volts", format:".1f",
                        hwChan:13, type:"VOLTAGE")

                CIP5_V (Channel, description:"Cryo ion pump 5 voltage", units:"Volts", format:".1f",
                        hwChan:14, type:"VOLTAGE")

                CIP6_V (Channel, description:"Cryo ion pump 6 voltage", units:"Volts", format:".1f",
                        hwChan:15, type:"VOLTAGE")
            }
        }
    }
}
