/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.monitor;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.CalcDevice;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorParallelTaskManager;
import org.lsst.ccs.monitor.MonitorUpdateTask;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.HasDataProviderInfos;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.utilities.logging.Logger;

public class Monitor
implements HasLifecycle,
HasDataProviderInfos,
AgentService {
    static final String LIMITS = "Limits";
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, Device> devcMap = new HashMap<String, Device>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, Channel> chanMap = new LinkedHashMap<String, Channel>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    final Map<String, Alarm> alarmMap = new HashMap<String, Alarm>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    DataProviderDictionaryService dataProviderDictionaryService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService configurationService;
    protected Logger log;
    @LookupField(strategy=LookupField.Strategy.TOP)
    Agent subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    List<Alarm> monitorAlarms = new ArrayList<Alarm>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    boolean readyToPublish = false;
    private int numChans;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private List<Channel> chanData = new ArrayList<Channel>();
    boolean useFullPath = false;
    private List<MonitorUpdateTask> tasksList = new ArrayList<MonitorUpdateTask>();
    public static final String MONITOR_CHECK_TASK = "monitor-check";
    public static final String MONITOR_UPDATE_TASK = "monitor-update";
    public static final String MONITOR_PUBLISH_TASK = "monitor-publish";
    public static final String MONITOR_CHECK_SCHEDULER = "monitor-check-scheduler";
    public static final String MONITOR_UPDATE_PUBLISH_SCHEDULER = "monitor-update-publish-scheduler";

    @Override
    public String getAgentServiceName() {
        return "monitorService";
    }

    @Override
    public boolean startForAgent(AgentInfo agentInfo) {
        return agentInfo.isAgentWorkerOrService();
    }

    @Override
    public void start() {
        this.readyToPublish = true;
        this.useFullPath = "true".equals(this.subsys.getAgentInfo().getAgentProperty("org.lsst.ccs.use.full.paths", "false").toLowerCase());
    }

    @Override
    public void build() {
        if (this.devcMap.size() > 0) {
            this.log = Logger.getLogger((String)(this.subsys.getLogger().getName() + ".monitor"));
            Properties buildProperties = this.configurationService.getBuildProperties();
            this.tasksList = MonitorParallelTaskManager.getParallelTasks(buildProperties, this.chanData);
            List<Channel> copyOfChannels = new ArrayList<Channel>(this.chanData);
            ComponentNode monitorNode = this.subsys.getComponentLookup().getComponentNodeForObject((Object)this);
            this.periodicTaskService.createScheduler(MONITOR_UPDATE_PUBLISH_SCHEDULER, Math.max(2, 1 + this.tasksList.size() / 4));
            try {
                for (MonitorUpdateTask task : this.tasksList) {
                    String taskName;
                    int channelCount = copyOfChannels.size();
                    if (channelCount - (copyOfChannels = task.configureTask(copyOfChannels)).size() != task.getAllChannels().size()) {
                        this.log.severe((Object)("Something went wrong calculating the monitor tasks " + channelCount + " " + copyOfChannels.size() + " " + task.getAllChannels().size()));
                    }
                    if (!(taskName = task.getName()).isEmpty()) {
                        this.subsys.getComponentLookup().addComponentNodeToLookup(monitorNode, new ComponentNode("monitorTasks/" + taskName, (Object)task));
                    }
                    this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask(MONITOR_UPDATE_TASK + (taskName.isEmpty() ? "" : "/" + taskName), () -> task.monitorUpdate(this)).withPeriod(Duration.ofMillis(1000L)), MONITOR_UPDATE_PUBLISH_SCHEDULER);
                    this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask(MONITOR_PUBLISH_TASK + (taskName.isEmpty() ? "" : "/" + taskName), () -> task.monitorPublish()).withPeriod(Duration.ofMillis(10000L)), MONITOR_UPDATE_PUBLISH_SCHEDULER);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.tasksList.size() > 1) {
                this.periodicTaskService.createScheduler(MONITOR_CHECK_SCHEDULER, Math.max(2, 1 + this.devcMap.size() / 4));
                for (String devName : this.getDeviceNames()) {
                    this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask("monitor-check/" + devName, () -> this.getDevice(devName).checkOnline()).withPeriod(Duration.ofMillis(10000L)), MONITOR_CHECK_SCHEDULER);
                }
            } else {
                this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask(MONITOR_CHECK_TASK, () -> {
                    for (String devName : this.getDeviceNames()) {
                        this.getDevice(devName).checkOnline();
                    }
                }).withPeriod(Duration.ofMillis(10000L)));
            }
            AlarmHandler defaultHandler = new AlarmHandler(){

                @Override
                public boolean processAlarm(int event, int parm, String cause, String name) {
                    AlertState state;
                    switch (event) {
                        case 0: {
                            state = AlertState.ALARM;
                            break;
                        }
                        case 1: {
                            state = AlertState.WARNING;
                            break;
                        }
                        case 2: {
                            state = AlertState.WARNING;
                            break;
                        }
                        case 3: {
                            state = AlertState.NOMINAL;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unkwnown event value " + event);
                        }
                    }
                    Monitor.this.alertService.raiseAlert(new Alert("MonitorAlert" + parm, name), state, "Automatic Monitor Alert\n" + cause);
                    return true;
                }

                @Override
                public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState state) {
                    String idStr = alert.getAlertId().replace("MonitorAlert", "");
                    try {
                        int id = Integer.parseInt(idStr);
                        Alarm a = this.getAlarmById(id);
                        if (a != null) {
                            return a.canClearState() ? ClearAlertHandler.ClearAlertCode.CLEAR_ALERT : ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    return ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT;
                }
            };
            this.subsys.getComponentLookup().addComponentNodeToLookup(monitorNode, new ComponentNode("defaultAlarmHandler", (Object)defaultHandler));
        }
    }

    @Override
    public void postInit() {
        for (MonitorUpdateTask task : this.tasksList) {
            task.updateAlarms();
        }
    }

    @Override
    public void init() {
        if (this.devcMap.size() > 0) {
            this.log.finest((Object)"Initializing monitor framework");
            int totalNumberOfChannels = 0;
            for (MonitorUpdateTask monitorTask : this.tasksList) {
                ArrayList<String> alreadyExistingGroups = new ArrayList<String>();
                for (Device device : monitorTask.getDevices()) {
                    for (String group : monitorTask.getGroupsForDevice(device)) {
                        if (!group.isEmpty()) {
                            if (alreadyExistingGroups.contains(group)) {
                                throw new RuntimeException("Group " + group + " is already defined in another task");
                            }
                            alreadyExistingGroups.add(group);
                        }
                        totalNumberOfChannels += monitorTask.getChannelsForDeviceGroup(device, group).size();
                    }
                    alreadyExistingGroups.clear();
                }
                this.log.debug((Object)monitorTask.toString());
            }
            if (totalNumberOfChannels != this.chanMap.size()) {
                throw new RuntimeException("Total number of Monitor channels: " + this.chanMap.size() + " differs the total channels in tasks: " + totalNumberOfChannels);
            }
        }
    }

    int getChannelId(Channel ch) {
        return this.chanData.indexOf(ch);
    }

    public Device getDevice(String name) {
        Device d = this.devcMap.get(name);
        if (d == null && name.equals("Calc")) {
            d = new CalcDevice();
            this.devcMap.put("Calc", d);
            ComponentNode monitorNode = this.subsys.getComponentLookup().getComponentNodeForObject((Object)this);
            this.subsys.getComponentLookup().addComponentNodeToLookup(monitorNode, new ComponentNode("Calc", (Object)d));
        }
        return d;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of all devices", category=Command.CommandCategory.CORE)
    public List<String> getDeviceNames() {
        return new ArrayList<String>(this.devcMap.keySet());
    }

    public Alarm getAlarm(String name) {
        return this.alarmMap.get(name);
    }

    public Channel getChannel(String name) {
        return this.chanMap.get(name);
    }

    public Channel getChannel(int id) {
        return this.chanData.get(id);
    }

    public int getChannelId(String name) {
        Channel chan = this.chanMap.get(name);
        return chan == null ? -1 : chan.getId();
    }

    public int getNumChans() {
        return this.numChans;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of channel names", category=Command.CommandCategory.CORE)
    public List<String> getChannelNames() {
        return new ArrayList<String>(this.chanMap.keySet());
    }

    @Command(type=Command.CommandType.QUERY, description="Get a channel value", category=Command.CommandCategory.CORE)
    public Double getChannelValue(String name) {
        Channel chan = this.chanMap.get(name);
        return chan == null ? null : Double.valueOf(chan.getValue());
    }

    @Command(type=Command.CommandType.QUERY, description="Read a channel value", category=Command.CommandCategory.CORE, level=1)
    public Double readChannelValue(String name) {
        Channel chan = this.chanMap.get(name);
        if (chan != null) {
            return chan.readSensor();
        }
        return null;
    }

    @Override
    public List<DataProviderInfo> getDataProviderInfos() {
        ArrayList<DataProviderInfo> list = new ArrayList<DataProviderInfo>();
        for (Channel ch : this.chanData) {
            String trendingKey;
            ComponentNode channelComponentNode = this.subsys.getComponentLookup().getComponentNodeForObject((Object)ch);
            this.useFullPath = "true".equals(this.subsys.getAgentInfo().getAgentProperty("org.lsst.ccs.use.full.paths", "false").toLowerCase());
            String string = trendingKey = this.useFullPath ? channelComponentNode.getPath() : channelComponentNode.getKey();
            if (trendingKey.startsWith("/")) {
                trendingKey = trendingKey.substring(1);
            }
            DataProviderInfo dataProviderInfo = new DataProviderInfo(channelComponentNode.getPath(), DataProviderInfo.Type.MONITORING, trendingKey);
            dataProviderInfo.addAttribute(DataProviderInfo.Attribute.UNITS, ch.getUnits());
            dataProviderInfo.addAttribute(DataProviderInfo.Attribute.FORMAT, ch.getFormat());
            dataProviderInfo.addAttribute(DataProviderInfo.Attribute.DESCRIPTION, ch.getDescription());
            dataProviderInfo.addAttribute(DataProviderInfo.Attribute.PAGE, String.valueOf(ch.getPageId()));
            dataProviderInfo.addAttribute(DataProviderInfo.Attribute.ALARMHI, ch.getAlarmNameHi());
            dataProviderInfo.addAttribute(DataProviderInfo.Attribute.ALARMLO, ch.getAlarmNameLo());
            list.add(dataProviderInfo);
        }
        return list;
    }

    @Override
    public void publishDataProviderCurrentData() {
        for (MonitorUpdateTask task : this.tasksList) {
            task.monitorPublish();
        }
    }

    @Deprecated
    public static interface AlarmHandler
    extends ClearAlertHandler {
        @LookupField(strategy=LookupField.Strategy.TREE)
        public static final List<Alarm> alarms = new ArrayList<Alarm>();

        default public boolean processAlarm(int event, int parm, String cause, String alarmName) {
            return false;
        }

        @Override
        default public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState state) {
            return ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT;
        }

        default public Alarm getAlarmById(int id) {
            for (Alarm alarm : alarms) {
                if (alarm.eventParm != id) continue;
                return alarm;
            }
            return null;
        }
    }
}

