/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.demo.main;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.config.ConfigurationBulkChangeHandler;

public class DemoConfigurable
implements ConfigurationBulkChangeHandler {
    @LookupName
    protected String name;
    @ConfigurationParameter(isFinal=true)
    protected String info;
    @ConfigurationParameter
    protected double doubleValue;
    @ConfigurationParameter
    protected final Map<String, Integer> currentParms = new HashMap<String, Integer>();
    @ConfigurationParameter(range="0..10")
    protected int min;
    @ConfigurationParameter
    protected int max;

    public DemoConfigurable(String info, double doubleValue, Map currentParms, int min, int max) {
        this.info = info;
        this.doubleValue = doubleValue;
        this.currentParms.putAll(currentParms);
        this.min = min;
        this.max = max;
    }

    public void validateBulkChange(Map<String, Object> parametersView) {
        int ma;
        int mi = (Integer)parametersView.get("min");
        if (mi > (ma = ((Integer)parametersView.get("max")).intValue())) {
            throw new IllegalArgumentException("min must be less than max");
        }
    }

    public void setParameterBulk(Map<String, Object> parametersView) {
        Object obj = parametersView.get("min");
        if (obj != null) {
            this.min = (Integer)obj;
        }
        if ((obj = parametersView.get("max")) != null) {
            this.max = (Integer)obj;
        }
    }

    @ConfigurationParameterChanger
    public void setCurrentParms(Object currentParms) {
        Map map = (Map)currentParms;
        this.currentParms.putAll(map);
    }

    @ConfigurationParameterChanger
    public void setDoubleValue(double value) {
        this.doubleValue = value;
    }
}

