package org.lsst.ccs.subsystem.demo.main;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.utilities.logging.Logger;

public class DemoSubsystemWithMonitoring extends DemoSubsystem implements Monitor.AlarmHandler, ServiceLifecycle {

    private static final Logger log = Logger.getLogger("org.lsst.ccs.subsystem.demo");
        
    @LookupField(strategy = LookupField.Strategy.TREE)
    DataProviderDictionaryService dictionaryService;

    @LookupField(strategy = LookupField.Strategy.TOP)
    Agent agent;

    @LookupField(strategy = LookupField.Strategy.TREE)
    Monitor monitor;
    
    @LookupField(strategy = LookupField.Strategy.TREE)
    ConfigurationService configurationService;
    
    @Override
    public boolean processAlarm(int event, int parm, String cause, String alarmName) {
        log.info("Processing alarm "+event+" "+parm+" "+alarmName);
        return false;
    }

    
    @Command(description = "Modify the hi limit parameters for an nchan number of channels, randomly picked if shuffle is set to true")
    public void setLimitHi(int nchans, boolean shuffle, double limitHi, double dbandHi) {
        List<String> channelNames = monitor.getChannelNames();
        int channelNumber = channelNames.size();
        if (nchans > channelNumber) {
            nchans = channelNumber;
        }
        ArrayList<Integer> randomNumbers = new ArrayList<>();
        for(int i = 0; i<channelNumber;i++) {
            randomNumbers.add(i);
        }
        if (nchans != channelNumber && shuffle) {
            Collections.shuffle(randomNumbers);
        }
        for(int i = 0; i<nchans; i++) {
            subsys.getComponentConfigurationEnvironmentByName(channelNames.get(randomNumbers.get(i))).submitChange("limitHi", limitHi);
            subsys.getComponentConfigurationEnvironmentByName(channelNames.get(randomNumbers.get(i))).submitChange("dbandHi", dbandHi);
        }
        configurationService.commitBulkChange();
    }
    
    @Command(description = "Reset limit hi for all channels to a value that will not trigger warning or alarms")
    public void resetAllLimitHi() {
        setLimitHi(monitor.getChannelNames().size(), false, 10.0, 0.0);
    }

    

}
