import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.demo.main.DemoSubsystemWithMonitoring;
import org.lsst.ccs.subsystem.demo.main.device.DemoDevice;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Page;

CCSBuilder builder = ["focal-test"]

builder.
    "main" (DemoSubsystemWithMonitoring) {
    
    Alarm1  (Alarm, [description:"Trips off all power", eventParm:0])
        
    REB0  (DemoDevice, name:"REB0")
    REB1  (DemoDevice, name:"REB1")
    REB2  (DemoDevice, name:"REB2")
    RSA  (DemoDevice, name:"RSA")

    Page1 (Page, id: 1, label: "Page1")
    Page2 (Page, id: 2, label: "Page2")
     
    "RAFT11/REB0/1"  (Channel, description:"c001", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:10.0, alarmHi:"Alarm1", pageId: 1)
    "RAFT11/REB0/2"  (Channel, description:"c002", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:12.0, alarmHi:"Alarm1", pageId: 2)
    "RAFT11/REB1/CCD10/1"  (Channel, description:"c003", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:12.0, alarmHi:"Alarm1")
    "RAFT11/CCD11/1"  (Channel, description:"c004", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:10.0, alarmHi:"Alarm1")
    "RAFT11/CCD11/AMP00"  (Channel, description:"c005", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:12.0, alarmHi:"Alarm1")
    "RAFT11/CCD11/AMP01"  (Channel, description:"c006", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:12.0, alarmHi:"Alarm1")
    "RAFT11/CCD11/AMP02"  (Channel, description:"c007", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:10.0, alarmHi:"Alarm1")
    "RAFT11/CCD11/AMP03"  (Channel, description:"c008", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:12.0, alarmHi:"Alarm1")
    "RAFT11/CCD11/AMP04"  (Channel, description:"c009", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:12.0, alarmHi:"Alarm1")
    "RAFT11/CCD11/AMP05"  (Channel, description:"c010", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:12.0, alarmHi:"Alarm1")
    "RAFT11/CCD11/AMP06"  (Channel, description:"c010", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:12.0, alarmHi:"Alarm1")
    "RAFT11/CCD11/AMP07"  (Channel, description:"c010", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:12.0, alarmHi:"Alarm1")

    "RAFT12/1"  (Channel, description:"c011", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:12.0, alarmHi:"Alarm1")
    "RAFT12/REB0/1"  (Channel, description:"c012", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:12.0, alarmHi:"Alarm1")
    
    
}
