/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ConfigurationListener;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.config.CategoryTag;
import org.lsst.ccs.config.ConfigurationDAO;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationServiceException;
import org.lsst.ccs.config.ConfigurationView;
import org.lsst.ccs.config.LocalConfigurationDAO;
import org.lsst.ccs.config.remote.CCSBusesConfigurationDAO;
import org.lsst.ccs.config.remote.DualConfigurationDAO;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.utilities.structs.ParameterPath;

public class ConfigurationDAOWrapper
implements HasLifecycle,
ConfigurationListener {
    private volatile String[] sourceNames = new String[]{"descriptionName", "agentName"};
    private final ConfigurationService configurationService;
    private final List<SourcedConfigurationDAO> sourcedDaos = new ArrayList<SourcedConfigurationDAO>();
    private final Agent agent;
    private final Map<String, ConfigurationView> newLoadedViewsBySourceAndByCategory = new ConcurrentHashMap<String, ConfigurationView>();
    private final Map<String, ConfigurationView> pendingLoadedViewsBySource = new ConcurrentHashMap<String, ConfigurationView>();
    private volatile ConfigurationDescription pendingConfigDescription = null;
    private final String agentName;
    private final String descriptionName;
    private static final String NO_SOURCE = "_No_SoUrCe_";
    private static final String EMPTY_STRING = "_EmPtY_SrInG_";
    private static final Logger LOG = Logger.getLogger(ConfigurationDAOWrapper.class.getName());

    ConfigurationDAOWrapper(Agent agent, ConfigurationService configurationService, String descriptionName) {
        this.agent = agent;
        this.configurationService = configurationService;
        this.agentName = agent.getName();
        this.descriptionName = descriptionName;
        configurationService.addConfigurationListener(this);
        this.buildConfigurationDAOs(this.sourceNames, true);
    }

    ConfigurationDAOWrapper(String[] sourceNames, String agentName, String descriptionName) {
        this.agent = null;
        this.configurationService = null;
        this.agentName = agentName;
        this.descriptionName = descriptionName;
        this.buildConfigurationDAOs(sourceNames, true);
    }

    private void buildConfigurationDAOs(String[] sourceNames, boolean localOnly) {
        this.sourcedDaos.clear();
        boolean isRemoteDao = this.agent == null ? false : this.agent.getAgentInfo().hasAgentProperty("org.lsst.ccs.config.remote");
        boolean isDualDao = this.agent == null ? false : this.agent.getAgentInfo().hasAgentProperty("org.lsst.ccs.config.dual");
        String daoType = null;
        HashSet<String> existingSources = new HashSet<String>();
        boolean first = true;
        for (String sourceName : sourceNames) {
            if (sourceName != null) {
                String tmpSourceName;
                String string = sourceName.equals("agentName") ? this.agentName : (tmpSourceName = sourceName.equals("descriptionName") ? this.descriptionName : sourceName);
                if (tmpSourceName != null) {
                    if (existingSources.contains(tmpSourceName)) continue;
                    Object dao = null;
                    if (localOnly || !isRemoteDao && !isDualDao) {
                        dao = new LocalConfigurationDAO(tmpSourceName, first ? this.configurationService : null);
                        daoType = "local";
                    } else if (isDualDao) {
                        dao = new DualConfigurationDAO(this.agent.getMessagingAccess(), tmpSourceName, this.configurationService);
                        daoType = "dual";
                    } else if (isRemoteDao) {
                        dao = new CCSBusesConfigurationDAO(this.agent.getMessagingAccess(), tmpSourceName);
                        daoType = "remote";
                    } else {
                        throw new RuntimeException("Something went wrong configuring the ConfigurationProxyWrapper (local=" + (this.agent == null) + " dual=" + isDualDao + " remote=" + isRemoteDao);
                    }
                    LOG.log(Level.FINEST, "Created {0} configuration proxy for source {1}", new Object[]{daoType, sourceName});
                    this.sourcedDaos.add(new SourcedConfigurationDAO((ConfigurationDAO)dao, tmpSourceName));
                    existingSources.add(tmpSourceName);
                } else {
                    LOG.log(Level.INFO, "Could not use sourceName: {0}", new Object[]{sourceName});
                }
            }
            first = false;
        }
    }

    @Override
    public void build() {
        this.buildConfigurationDAOs(this.sourceNames, true);
    }

    @Override
    public void init() {
        this.buildConfigurationDAOs(this.sourceNames, false);
    }

    public Properties getConfigurationProperties(String tag, String category) throws ConfigurationServiceException {
        Properties res = new Properties();
        for (SourcedConfigurationDAO sourcedDao : this.sourcedDaos) {
            try {
                Properties p;
                ConfigurationDAO dao = sourcedDao.getDao();
                if (!(dao instanceof LocalConfigurationDAO) || (p = ((LocalConfigurationDAO)dao).getConfigurationProperties(tag, category)) == null) continue;
                res.putAll((Map<?, ?>)p);
            }
            catch (Exception exception) {}
        }
        return res;
    }

    private String getSourceCategoryTagStr(String source, String category, String tag) {
        String s = source.isEmpty() ? EMPTY_STRING : source;
        String c = category.isEmpty() ? EMPTY_STRING : category;
        String t = tag.isEmpty() ? EMPTY_STRING : tag;
        return s + "*" + c + "*" + t;
    }

    private String[] decodeSourceCategoryTagStr(String inputStr) {
        String[] res = inputStr.split("\\*");
        String[] r = new String[3];
        for (int i = 0; i < 2; ++i) {
            r[i] = res[i].replace(EMPTY_STRING, "");
        }
        return r;
    }

    public ConfigurationView loadConfiguration(ConfigurationDescription configDescription) throws ConfigurationServiceException {
        ConfigurationView res = new ConfigurationView(configDescription);
        try {
            for (String category : configDescription.getCategoriesSet()) {
                CategoryTag categoryTag = configDescription.getCategoryTag(category);
                for (String tag : categoryTag.getTags()) {
                    boolean configurationTagExists = false;
                    for (SourcedConfigurationDAO sourcedDao : this.sourcedDaos) {
                        ConfigurationDAO dao = sourcedDao.getDao();
                        ConfigurationDescription cd = new ConfigurationDescription();
                        cd.putTagForCategory(category, tag, categoryTag.getTagVersion(tag));
                        ConfigurationView sourceView = dao.loadConfiguration(cd);
                        if (sourceView == null) continue;
                        configurationTagExists = true;
                        for (Map.Entry valueEntry : sourceView.getAsParameterPathMap().entrySet()) {
                            ParameterPath pp = (ParameterPath)valueEntry.getKey();
                            String parameterCategory = null;
                            try {
                                parameterCategory = this.configurationService.configurationHandler.getParameterSet(pp.getComponentName()).getConfigurationParameterHandler(pp.getParameterName()).getCategory();
                                if (parameterCategory.equals(category)) continue;
                                throw new RuntimeException("Invalid parameter category " + parameterCategory + " for " + pp + ". Should have been: " + category + " for " + sourcedDao.getSource() + " " + cd);
                            }
                            catch (Exception e) {
                                if (!this.configurationService.isInitialConfiguration) continue;
                                throw e;
                            }
                        }
                        String key = this.getSourceCategoryTagStr(sourcedDao.getSource(), category, tag);
                        ConfigurationView categorySourceView = this.pendingLoadedViewsBySource.getOrDefault(key, new ConfigurationView());
                        categorySourceView.putAll(sourceView);
                        this.pendingLoadedViewsBySource.put(key, categorySourceView);
                        res.putAll(sourceView);
                    }
                    if (this.agent.getAgentInfo().getType().compareTo((Enum)AgentInfo.AgentType.WORKER) < 0) continue;
                    boolean checkOnNonExistingFiles = false;
                    if (this.configurationService.isInitialConfiguration) {
                        if (!this.configurationService.saveInitialConfiguration) {
                            checkOnNonExistingFiles = true;
                        }
                    } else if (!tag.equals("") && !tag.equals("safe")) {
                        checkOnNonExistingFiles = true;
                    }
                    if (configurationTagExists || !checkOnNonExistingFiles) continue;
                    throw new IllegalArgumentException("Could not load any configuration parameters for category tag " + category + ":" + tag);
                }
            }
            this.pendingConfigDescription = configDescription;
        }
        catch (Exception e) {
            this.pendingLoadedViewsBySource.clear();
            this.pendingConfigDescription = null;
            throw e;
        }
        res.setConfigurationDescription(configDescription);
        return res;
    }

    public ConfigurationView loadGlobalConfiguration(String name, int version) {
        ConfigurationView res = new ConfigurationView();
        for (SourcedConfigurationDAO sourcedDao : this.sourcedDaos) {
            ConfigurationDAO dao = sourcedDao.getDao();
            ConfigurationView sourceView = dao.loadGlobalConfiguration(name, version);
            if (sourceView == null) continue;
            this.pendingLoadedViewsBySource.put(sourcedDao.getSource(), sourceView);
            res.putAll(sourceView);
            res.setConfigurationDescription(sourceView.getConfigurationDescription());
        }
        this.pendingConfigDescription = res.getConfigurationDescription();
        return res;
    }

    public ConfigurationDescription saveChangesForCategoriesAs(ConfigurationDescription configDesc, ConfigurationInfo configInfo, boolean fullConfiguration) throws ConfigurationServiceException {
        ConfigurationView overallView = new ConfigurationView();
        if (!fullConfiguration) {
            for (SourcedConfigurationDAO sourcedDao : this.sourcedDaos) {
                boolean isLastSource = this.sourcedDaos.indexOf(sourcedDao) == this.sourcedDaos.size() - 1;
                String source = sourcedDao.getSource();
                for (String category : configDesc.getCategoriesSet()) {
                    CategoryTag catTag = configDesc.getCategoryTag(category);
                    List tags = catTag.getTags();
                    for (String tag : tags) {
                        String viewKey;
                        ConfigurationView lastLoadedViewForKey;
                        boolean isLastTag;
                        boolean bl = isLastTag = tags.indexOf(tag) == tags.size() - 1;
                        if (isLastSource && isLastTag || (lastLoadedViewForKey = this.newLoadedViewsBySourceAndByCategory.get(viewKey = this.getSourceCategoryTagStr(source, category, tag))) == null) continue;
                        for (Map.Entry e : lastLoadedViewForKey.getAsParameterPathMap().entrySet()) {
                            ParameterPath path = (ParameterPath)e.getKey();
                            if (overallView.containsPath(path) && overallView.getPathValue(path).equals(e.getValue())) {
                                lastLoadedViewForKey.removeValueForPath(path);
                                continue;
                            }
                            overallView.putParameterValue(path.toString(), (String)e.getValue());
                        }
                    }
                }
            }
        }
        ConfigurationView currentView = this.configurationService.getCurrentConfigurationView();
        SourcedConfigurationDAO topSourceDao = this.sourcedDaos.get(this.sourcedDaos.size() - 1);
        String topSourceName = topSourceDao.getSource();
        for (Map.Entry lastLoadedValues : currentView.getAsParameterPathMap().entrySet()) {
            ParameterPath pp = (ParameterPath)lastLoadedValues.getKey();
            String currentViewValue = (String)lastLoadedValues.getValue();
            String parameterCategory = configInfo.getCurrentParameterInfo(pp.toString()).getCategoryName();
            String lastSource = this.sourcedDaos.get(this.sourcedDaos.size() - 1).getSource();
            CategoryTag catTag = configDesc.getCategoryTag(parameterCategory);
            if (catTag == null) continue;
            List tags = catTag.getTags();
            String lastTag = (String)tags.get(tags.size() - 1);
            String viewKey = this.getSourceCategoryTagStr(lastSource, parameterCategory, lastTag);
            ConfigurationView lastLoadedViewForKey = this.newLoadedViewsBySourceAndByCategory.getOrDefault(viewKey, new ConfigurationView());
            if (overallView.containsPath(pp) && overallView.getPathValue(pp).equals(currentViewValue)) {
                lastLoadedViewForKey.removeValueForPath(pp);
            } else {
                lastLoadedViewForKey.putParameterValue(pp.toString(), currentViewValue);
            }
            this.newLoadedViewsBySourceAndByCategory.put(viewKey, lastLoadedViewForKey);
        }
        for (String category : configDesc.getCategoriesSet()) {
            CategoryTag categoryTag;
            String tag;
            String viewKey = this.getSourceCategoryTagStr(topSourceName, category, tag = (String)(categoryTag = configDesc.getCategoryTag(category)).getTags().get(categoryTag.getTags().size() - 1));
            ConfigurationView view = this.newLoadedViewsBySourceAndByCategory.getOrDefault(viewKey, new ConfigurationView());
            if (view.getConfigurationDescription() == null) {
                view.setConfigurationDescription(configDesc);
            }
            if (view == null) continue;
            ConfigurationDAO dao = topSourceDao.getDao();
            ConfigurationDescription cd = new ConfigurationDescription();
            if (configDesc.getName() != null) {
                cd.setName(configDesc.getName(), configDesc.getVersion());
            }
            cd.putTagForCategory(category, tag, Integer.valueOf(-1));
            ConfigurationDescription configurationDescription = dao.saveChangesForCategoriesAs(cd, this.configurationService.buildConfigurationInfo(view, false).build());
        }
        if (configDesc.getName() != null) {
            topSourceDao.getDao().saveChangesForCategoriesAs(configDesc, configInfo);
        }
        return configDesc;
    }

    private String getNoSourceKeyForCategoryTag(String category, String tag) {
        return this.getSourceCategoryTagStr(NO_SOURCE, category, tag);
    }

    private ConfigurationView getNoSourceConfigurationViewForCategoryTag(String category, String tag) {
        String key = this.getNoSourceKeyForCategoryTag(category, tag);
        ConfigurationView cv = this.newLoadedViewsBySourceAndByCategory.getOrDefault(key, new ConfigurationView());
        this.newLoadedViewsBySourceAndByCategory.put(key, cv);
        return cv;
    }

    public ConfigurationDescription registerConfiguration(ConfigurationInfo configInfo) throws ConfigurationServiceException {
        ConfigurationDescription res = null;
        for (SourcedConfigurationDAO sourcedDao : this.sourcedDaos) {
            ConfigurationDescription desc;
            ConfigurationDAO dao = sourcedDao.getDao();
            res = desc = dao.registerConfiguration(configInfo);
        }
        return res;
    }

    public boolean isAvailable() {
        for (SourcedConfigurationDAO sourcedDao : this.sourcedDaos) {
            ConfigurationDAO dao = sourcedDao.getDao();
            if (dao.isAvailable()) continue;
            return false;
        }
        return true;
    }

    public Set<String> findAvailableConfigurationsForCategory(String category) {
        HashSet<String> res = new HashSet<String>();
        for (SourcedConfigurationDAO sourcedDao : this.sourcedDaos) {
            ConfigurationDAO dao = sourcedDao.getDao();
            res.addAll(dao.findAvailableConfigurationsForCategory(category));
        }
        return res;
    }

    public String locateConfigurations(ConfigurationInfo configInfo) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public void configurationChanged(ConfigurationInfo newConfigurationInfo, ConfigurationInfo oldConfigurationInfo, ConfigurationListener.ConfigurationOperation configurationOperation) {
        if (configurationOperation == ConfigurationListener.ConfigurationOperation.LOAD) {
            String category;
            String[] info;
            if (this.pendingLoadedViewsBySource.isEmpty()) {
                return;
            }
            for (String category2 : this.pendingConfigDescription.getCategoriesSet()) {
                CategoryTag categoryTag = this.pendingConfigDescription.getCategoryTag(category2);
                ConfigurationDescription configurationDescription = ConfigurationDescription.fromConfigurationInfo((ConfigurationInfo)newConfigurationInfo);
                CategoryTag newTag = configurationDescription.getCategoryTag(category2);
                for (Object tag : categoryTag.getTags()) {
                    if (newTag.getTags().contains(tag)) continue;
                    this.pendingLoadedViewsBySource.clear();
                    this.pendingConfigDescription = null;
                    throw new RuntimeException("Configuration Description mismatch for category " + category2 + ". Actual " + newConfigurationInfo.getConfigNameForCategory(category2) + " pending: " + (String)tag);
                }
            }
            for (String category2 : this.pendingConfigDescription.getCategoriesSet()) {
                for (String string : this.newLoadedViewsBySourceAndByCategory.keySet()) {
                    info = this.decodeSourceCategoryTagStr(string);
                    if (!info[1].equals(category2)) continue;
                    this.newLoadedViewsBySourceAndByCategory.remove(string);
                }
            }
            ConfigurationView currentView = this.configurationService.extractConfigurationViewFromConfigurationInfo(newConfigurationInfo);
            ConfigurationDescription configDescription = currentView.getConfigurationDescription();
            for (String string : configDescription.getCategoriesSet()) {
                CategoryTag catTag = configDescription.getCategoryTag(string);
                for (Object tag : catTag.getTags()) {
                    for (SourcedConfigurationDAO sourcedDao : this.sourcedDaos) {
                        String source = sourcedDao.getSource();
                        String sourceKey = this.getSourceCategoryTagStr(source, string, (String)tag);
                        ConfigurationView sourceView = this.pendingLoadedViewsBySource.get(sourceKey);
                        if (sourceView == null) continue;
                        for (Map.Entry valueEntry : sourceView.getAsParameterPathMap().entrySet()) {
                            String parameterCategory;
                            ParameterPath pp;
                            block18: {
                                pp = (ParameterPath)valueEntry.getKey();
                                parameterCategory = null;
                                try {
                                    parameterCategory = this.configurationService.configurationHandler.getParameterSet(pp.getComponentName()).getConfigurationParameterHandler(pp.getParameterName()).getCategory();
                                    if (!parameterCategory.equals(string)) {
                                        throw new RuntimeException("Why is the parameter category variable different ??? " + parameterCategory + " " + string);
                                    }
                                }
                                catch (Exception e) {
                                    if (!this.configurationService.isInitialConfiguration) break block18;
                                    throw e;
                                }
                            }
                            if (parameterCategory == null) continue;
                            String viewKey3 = this.getSourceCategoryTagStr(source, parameterCategory, (String)tag);
                            ConfigurationView categoryView = this.newLoadedViewsBySourceAndByCategory.getOrDefault(viewKey3, new ConfigurationView());
                            this.newLoadedViewsBySourceAndByCategory.put(viewKey3, categoryView);
                            categoryView.putParameterValue(pp.toString(), (String)valueEntry.getValue());
                            currentView.removeValueForPath(pp);
                        }
                    }
                }
            }
            for (Map.Entry entry : currentView.getAsParameterPathMap().entrySet()) {
                ParameterPath pp = (ParameterPath)entry.getKey();
                String parameterCategory = this.configurationService.configurationHandler.getParameterSet(pp.getComponentName()).getConfigurationParameterHandler(pp.getParameterName()).getCategory();
                if (!this.pendingConfigDescription.getCategoriesSet().contains(parameterCategory)) continue;
                this.getNoSourceConfigurationViewForCategoryTag(parameterCategory, "unclaimed").putParameterValue(pp.toString(), (String)entry.getValue());
            }
            currentView = this.configurationService.extractConfigurationViewFromConfigurationInfo(newConfigurationInfo, this.pendingConfigDescription.getCategoriesSet());
            Iterator<Object> iter = this.newLoadedViewsBySourceAndByCategory.keySet().iterator();
            while (iter.hasNext()) {
                String string = (String)iter.next();
                info = this.decodeSourceCategoryTagStr(string);
                category = info[1];
                if (!this.pendingConfigDescription.containsCategory(category)) continue;
                for (ParameterPath pp : this.newLoadedViewsBySourceAndByCategory.get(string).getAsParameterPathMap().keySet()) {
                    currentView.removeValueForPath(pp);
                }
            }
            if (!currentView.isEmpty()) {
                LOG.log(Level.SEVERE, "Parameters still in the current view: " + currentView.getAsParameterPathMap().toString());
                while (iter.hasNext()) {
                    String string = (String)iter.next();
                    info = this.decodeSourceCategoryTagStr(string);
                    category = info[1];
                    if (!this.pendingConfigDescription.containsCategory(category)) continue;
                    ConfigurationView view = this.newLoadedViewsBySourceAndByCategory.get(string);
                    LOG.log(Level.SEVERE, "Loaded configuration for source " + info[0] + " and category " + category + ":\n" + view.getAsParameterPathMap().toString());
                }
                throw new RuntimeException("Something went wrong with the loaded views. Please report this problem.");
            }
            this.pendingConfigDescription = null;
            this.pendingLoadedViewsBySource.clear();
        }
    }

    private class SourcedConfigurationDAO {
        private final ConfigurationDAO dao;
        private final String source;

        SourcedConfigurationDAO(ConfigurationDAO dao, String source) {
            this.dao = dao;
            this.source = source;
        }

        public ConfigurationDAO getDao() {
            return this.dao;
        }

        public String getSource() {
            return this.source;
        }
    }
}

