/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentPropertyPredicate;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.ClusterDisconnectionsListener;
import org.lsst.ccs.messaging.StatusMessageListener;

public class AgentPresenceManager
implements StatusMessageListener,
ClusterDisconnectionsListener {
    private final Object agentsLock = new Object();
    final CopyOnWriteArrayList<AgentPresenceListener> listAPL = new CopyOnWriteArrayList();
    private final Map<AgentInfo, AgentPresenceState> mapAgents = new ConcurrentHashMap<AgentInfo, AgentPresenceState>();
    private final List<AgentInfo> fullyConnectedAgents = new CopyOnWriteArrayList<AgentInfo>();
    private final List<AgentInfo> pendingConnectedAgents = new CopyOnWriteArrayList<AgentInfo>();
    private static final Logger LOG = Logger.getLogger(AgentPresenceManager.class.getName());
    private final ReentrantLock agentConnectionWaitLock = new ReentrantLock(true);
    private volatile LinkedHashMap<Condition, AgentPropertyPredicate> agentConnectionWaitList;
    private final ReentrantLock agentDisconnectionWaitLock = new ReentrantLock(true);
    private volatile LinkedHashMap<Condition, String> agentDisconnectionWaitList;
    private volatile TimerTask delayedNotificationTask;
    private final Timer timer = new Timer(true);
    private final AgentInfo agentInfo;
    private final BlockingQueue<Runnable> notifications = new ArrayBlockingQueue<Runnable>(100);

    public AgentPresenceManager(AgentInfo agentInfo) {
        ExecutorService queueExecutor = Executors.newSingleThreadExecutor(r -> {
            Thread t = new Thread(r, "Connection/Disconnection queue");
            t.setDaemon(true);
            return t;
        });
        queueExecutor.submit(() -> this.checkQueue());
        this.agentInfo = agentInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect() {
        Object object = this.agentsLock;
        synchronized (object) {
            this.mapAgents.clear();
            this.fullyConnectedAgents.clear();
        }
    }

    private void checkQueue() {
        try {
            while (true) {
                this.notifications.take().run();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed when draining Connection/Disconnection queue.", e);
        }
    }

    @Override
    public void onStatusMessage(StatusMessage s) {
        AgentInfo a = s.getOriginAgentInfo();
        if (a == null) {
            return;
        }
        if (a.getName().startsWith("image-handling")) {
            LOG.log(Level.FINEST, "Message from {0} in state {1}", new Object[]{a.getName(), s.getState().getState(PhaseState.class)});
        }
        if (s.getState().isInState(PhaseState.OFF_LINE)) {
            this.disconnectedAgent(a);
        } else if (s.getState().isInState(PhaseState.INITIALIZING)) {
            this.updateAgent(a, AgentPresenceState.CONNECTING);
        } else {
            this.updateAgent(a, AgentPresenceState.CONNECTED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAgent(AgentInfo a, AgentPresenceState state) {
        ConnectionDisconnectionNotification notification = null;
        LOG.log(Level.FINEST, "Updating {0} for AP State {1}: exists? {2} ({3})", new Object[]{a.getName(), state, this.mapAgents.containsKey(a), this.mapAgents.get(a)});
        Object object = this.agentsLock;
        synchronized (object) {
            AgentPresenceState oldState = this.mapAgents.get(a);
            if (oldState != null) {
                if (oldState != state) {
                    if (state != AgentPresenceState.CONNECTED) {
                        throw new RuntimeException("Something went really wrong with this agent's state: " + a.getName() + " " + (Object)((Object)state));
                    }
                    this.mapAgents.put(a, AgentPresenceState.CONNECTED);
                    notification = new ConnectionDisconnectionNotification(AgentPresenceState.CONNECTED, a);
                }
            } else {
                this.mapAgents.put(a, state);
                if (state == AgentPresenceState.CONNECTING) {
                    notification = new ConnectionDisconnectionNotification(AgentPresenceState.CONNECTING, a);
                } else if (state == AgentPresenceState.CONNECTED) {
                    notification = new ConnectionDisconnectionNotification(AgentPresenceState.CONNECTING, a);
                    this.pendingConnectedAgents.add(a);
                    this.submitDelayedNotificationIfNeeded();
                }
            }
            if (notification != null) {
                try {
                    this.notifications.put(notification);
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException("Problem submitting AgentPresenceManager notifications ", ie);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitDelayedNotificationIfNeeded() {
        LOG.log(Level.FINEST, "Submitting delayed notification {0} ", new Object[]{this.delayedNotificationTask});
        Object object = this.agentsLock;
        synchronized (object) {
            if (this.delayedNotificationTask == null) {
                this.delayedNotificationTask = new DelayedConnectedNotificationTask();
                this.timer.schedule(this.delayedNotificationTask, this.agentInfo.getType().compareTo(AgentInfo.AgentType.CONSOLE) >= 0 && !this.agentInfo.isScriptingConsole() ? 1200L : 0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDelayedConnectionNotification() {
        LOG.log(Level.FINEST, "Processing delayed notification {0} ", new Object[]{this.pendingConnectedAgents});
        Object object = this.agentsLock;
        synchronized (object) {
            if (!this.pendingConnectedAgents.isEmpty()) {
                AgentInfo[] connectedAgents = this.pendingConnectedAgents.toArray(new AgentInfo[this.pendingConnectedAgents.size()]);
                this.notifications.offer(new ConnectionDisconnectionNotification(AgentPresenceState.CONNECTED, connectedAgents));
                this.pendingConnectedAgents.clear();
                this.delayedNotificationTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectedAgent(AgentInfo ... agents) {
        Object object = this.agentsLock;
        synchronized (object) {
            ArrayList<AgentInfo> disconnectedAgents = new ArrayList<AgentInfo>();
            for (AgentInfo agent : agents) {
                AgentPresenceState state = this.mapAgents.remove(agent);
                if (state == null) continue;
                disconnectedAgents.add(agent);
                this.pendingConnectedAgents.remove(agent);
            }
            if (!disconnectedAgents.isEmpty()) {
                LOG.log(Level.FINER, "disconnecting agents {0}", disconnectedAgents);
                ConnectionDisconnectionNotification notification = new ConnectionDisconnectionNotification(AgentPresenceState.DISCONNECTING, disconnectedAgents.toArray(new AgentInfo[disconnectedAgents.size()]));
                this.notifications.offer(notification);
            }
        }
    }

    public List<AgentInfo> listConnectedAgents() {
        return new ArrayList<AgentInfo>(this.fullyConnectedAgents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void membersLeft(List<String> left) {
        ArrayList<AgentInfo> agentsToRemove = new ArrayList<AgentInfo>();
        Object object = this.agentsLock;
        synchronized (object) {
            for (AgentInfo a : this.mapAgents.keySet()) {
                if (!left.contains(a.getName())) continue;
                agentsToRemove.add(a);
            }
        }
        if (!agentsToRemove.isEmpty()) {
            this.disconnectedAgent(agentsToRemove.toArray(new AgentInfo[agentsToRemove.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAgentPresenceListener(AgentPresenceListener l) {
        Object object = this.agentsLock;
        synchronized (object) {
            l.connecting(this.mapAgents.keySet().toArray(new AgentInfo[0]));
            l.connected(this.fullyConnectedAgents.toArray(new AgentInfo[0]));
            this.listAPL.add(l);
        }
    }

    public void removeAgentPresenceListener(AgentPresenceListener l) {
        this.listAPL.remove(l);
    }

    public boolean agentExists(String agentName) {
        ArrayList<AgentInfo> existingAgents = new ArrayList<AgentInfo>(this.mapAgents.keySet());
        for (AgentInfo a : existingAgents) {
            if (!a.getName().equals(agentName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAgentConnected(String agentName) {
        List<AgentInfo> list = this.fullyConnectedAgents;
        synchronized (list) {
            for (AgentInfo a : this.fullyConnectedAgents) {
                if (!a.getName().equals(agentName)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAgentConnected(AgentPropertyPredicate agentPredicate) {
        List<AgentInfo> list = this.fullyConnectedAgents;
        synchronized (list) {
            for (AgentInfo a : this.fullyConnectedAgents) {
                if (!agentPredicate.test(a)) continue;
                return true;
            }
            return false;
        }
    }

    public final boolean waitForAgent(String name, long timeout, TimeUnit unit) throws InterruptedException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("agentName", name);
        AgentPropertyPredicate innerPredicate = new AgentPropertyPredicate(properties);
        return this.waitForAgent(innerPredicate, timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean waitForAgent(AgentPropertyPredicate predicate, long timeout, TimeUnit unit) throws InterruptedException {
        long deadline = TimeUnit.MILLISECONDS.convert(timeout, unit) + System.currentTimeMillis();
        if (!this.agentConnectionWaitLock.tryLock(timeout, unit)) {
            return false;
        }
        try {
            if (this.isAgentConnected(predicate)) {
                boolean bl = true;
                return bl;
            }
            Condition condition = this.agentConnectionWaitLock.newCondition();
            if (this.agentConnectionWaitList == null) {
                this.agentConnectionWaitList = new LinkedHashMap(4);
            }
            this.agentConnectionWaitList.put(condition, predicate);
            while (this.agentConnectionWaitList != null && this.agentConnectionWaitList.containsKey(condition)) {
                timeout = deadline - System.currentTimeMillis();
                if (condition.await(timeout, TimeUnit.MILLISECONDS)) continue;
                if (this.agentConnectionWaitList != null) {
                    this.agentConnectionWaitList.remove(condition);
                }
                if (this.agentConnectionWaitList.isEmpty()) {
                    this.agentConnectionWaitList = null;
                }
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.agentConnectionWaitLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void agentConnectionWaitNotify(AgentInfo agentInfo) {
        try {
            this.agentConnectionWaitLock.lockInterruptibly();
            try {
                if (this.agentConnectionWaitList == null) {
                    return;
                }
                Iterator<Map.Entry<Condition, AgentPropertyPredicate>> it = this.agentConnectionWaitList.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Condition, AgentPropertyPredicate> entry = it.next();
                    AgentPropertyPredicate agentWaitPredicate = entry.getValue();
                    if (!agentWaitPredicate.test(agentInfo)) continue;
                    entry.getKey().signal();
                    it.remove();
                }
                if (this.agentConnectionWaitList.isEmpty()) {
                    this.agentConnectionWaitList = null;
                }
            }
            finally {
                this.agentConnectionWaitLock.unlock();
            }
        }
        catch (InterruptedException x) {
            LOG.log(Level.SEVERE, "Exception when notifying for disconnection ", x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean waitForAgentDisconnection(String name, long timeout, TimeUnit unit) throws InterruptedException {
        long deadline = TimeUnit.MILLISECONDS.convert(timeout, unit) + System.currentTimeMillis();
        if (!this.agentDisconnectionWaitLock.tryLock(timeout, unit)) {
            return false;
        }
        try {
            if (!this.isAgentConnected(name)) {
                boolean bl = true;
                return bl;
            }
            Condition condition = this.agentDisconnectionWaitLock.newCondition();
            if (this.agentDisconnectionWaitList == null) {
                this.agentDisconnectionWaitList = new LinkedHashMap(4);
            }
            this.agentDisconnectionWaitList.put(condition, name);
            while (this.agentDisconnectionWaitList != null && this.agentDisconnectionWaitList.containsKey(condition)) {
                timeout = deadline - System.currentTimeMillis();
                if (condition.await(timeout, TimeUnit.MILLISECONDS)) continue;
                if (this.agentDisconnectionWaitList != null) {
                    this.agentDisconnectionWaitList.remove(condition);
                }
                if (this.agentDisconnectionWaitList.isEmpty()) {
                    this.agentDisconnectionWaitList = null;
                }
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.agentDisconnectionWaitLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void agentDisconnectionWaitNotify(String name) {
        try {
            this.agentDisconnectionWaitLock.lockInterruptibly();
            try {
                if (this.agentDisconnectionWaitList == null) {
                    return;
                }
                Iterator<Map.Entry<Condition, String>> it = this.agentDisconnectionWaitList.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Condition, String> entry = it.next();
                    String agentWaitName = entry.getValue();
                    if (!name.equals(agentWaitName)) continue;
                    entry.getKey().signal();
                    it.remove();
                }
                if (this.agentDisconnectionWaitList.isEmpty()) {
                    this.agentDisconnectionWaitList = null;
                }
            }
            finally {
                this.agentDisconnectionWaitLock.unlock();
            }
        }
        catch (InterruptedException ie) {
            LOG.log(Level.SEVERE, "Exception when notifying for disconnection ", ie);
        }
    }

    private class ConnectionDisconnectionNotification
    implements Runnable {
        private final AgentInfo[] agentInfos;
        private final AgentPresenceState state;

        ConnectionDisconnectionNotification(AgentPresenceState state, AgentInfo ... agentInfos) {
            this.agentInfos = agentInfos;
            this.state = state;
        }

        @Override
        public void run() {
            LOG.log(Level.FINEST, "Processing APL notifications for state {0} and agents {1}", new Object[]{this.state, Arrays.asList(this.agentInfos)});
            switch (this.state) {
                case DISCONNECTING: {
                    AgentPresenceManager.this.listAPL.forEach(l -> {
                        try {
                            l.disconnected(this.agentInfos);
                        }
                        catch (RuntimeException x) {
                            this.warn((AgentPresenceListener)l, x, this.state);
                        }
                    });
                    for (AgentInfo agentInfo : this.agentInfos) {
                        AgentPresenceManager.this.fullyConnectedAgents.remove(agentInfo);
                        AgentPresenceManager.this.agentDisconnectionWaitNotify(agentInfo.getName());
                    }
                    break;
                }
                case CONNECTING: {
                    AgentPresenceManager.this.listAPL.forEach(l -> {
                        try {
                            l.connecting(this.agentInfos);
                        }
                        catch (RuntimeException x) {
                            this.warn((AgentPresenceListener)l, x, this.state);
                        }
                    });
                    break;
                }
                case CONNECTED: {
                    AgentPresenceManager.this.listAPL.forEach(l -> {
                        try {
                            l.connected(this.agentInfos);
                        }
                        catch (RuntimeException x) {
                            this.warn((AgentPresenceListener)l, x, this.state);
                        }
                    });
                    for (AgentInfo agentInfo : this.agentInfos) {
                        AgentPresenceManager.this.fullyConnectedAgents.add(agentInfo);
                        AgentPresenceManager.this.agentConnectionWaitNotify(agentInfo);
                    }
                    break;
                }
            }
        }

        private void warn(AgentPresenceListener listener, RuntimeException x, AgentPresenceState state) {
            String agents = this.agentInfos.length == 1 ? this.agentInfos[0].getName() : Arrays.asList(this.agentInfos).stream().map(a -> a.getName()).collect(Collectors.joining(", ", "[", "]"));
            LOG.log(Level.WARNING, "Exception while notifying " + listener.getClass().getSimpleName() + " of " + (Object)((Object)state) + " of " + agents, x);
        }
    }

    class DelayedConnectedNotificationTask
    extends TimerTask {
        DelayedConnectedNotificationTask() {
        }

        @Override
        public void run() {
            AgentPresenceManager.this.processDelayedConnectionNotification();
        }
    }

    public static enum AgentPresenceState {
        CONNECTING,
        CONNECTED,
        DISCONNECTING;

    }
}

