/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.config.ConfigurationHandler;
import org.lsst.ccs.config.ConfigurationParameterHandler;

class ConfigurationHandlerBuilder {
    private static final Map<String, Map<String, Method>> CONFIG_CHANGER_MAP = new HashMap<String, Map<String, Method>>();
    private static final Map<String, Map<String, Field>> PARAMETER_MAP = new HashMap<String, Map<String, Field>>();

    private ConfigurationHandlerBuilder() {
    }

    static ConfigurationHandler buildParameterSetterFromObject(String objName, Object obj) {
        Class<?> cls = obj.getClass();
        Map<String, Field> fieldsMap = ConfigurationHandlerBuilder.buildParameterFieldsMap(cls);
        if (fieldsMap.isEmpty()) {
            return null;
        }
        Map<String, Method> configChangerMap = ConfigurationHandlerBuilder.buildConfigChangerMap(cls);
        ConfigurationHandler res = new ConfigurationHandler(obj, objName);
        for (Map.Entry<String, Field> entry : fieldsMap.entrySet()) {
            res.addParameter(entry.getKey(), new ConfigurationParameterHandler(objName, configChangerMap.get(entry.getKey()), entry.getValue(), obj));
        }
        return res;
    }

    private static Map<String, Method> buildConfigChangerMap(Class klass) {
        String klassName = klass.getName();
        Map<String, Method> configMethods = CONFIG_CHANGER_MAP.get(klassName);
        if (configMethods == null) {
            configMethods = new HashMap<String, Method>();
            CONFIG_CHANGER_MAP.put(klassName, configMethods);
            for (Method method : klass.getMethods()) {
                String methodName = method.getName();
                ConfigurationParameterChanger parameterChanger = method.getAnnotation(ConfigurationParameterChanger.class);
                if (parameterChanger == null) continue;
                String propertyName = parameterChanger.propertyName();
                if (!"".equals(propertyName)) {
                    configMethods.put(propertyName, method);
                    continue;
                }
                if (!methodName.startsWith("set")) continue;
                char firstLetter = methodName.charAt(3);
                propertyName = Character.toLowerCase(firstLetter) + methodName.substring(4);
                configMethods.put(propertyName, method);
            }
            for (Class clazz = klass; clazz != null; clazz = clazz.getSuperclass()) {
                for (Method method : clazz.getDeclaredMethods()) {
                    int modifiers = method.getModifiers();
                    ConfigurationParameterChanger parameterChanger = method.getAnnotation(ConfigurationParameterChanger.class);
                    if (parameterChanger == null || Modifier.isPublic(modifiers)) continue;
                    throw new RuntimeException("Method " + clazz.getName() + "::" + method.getName() + " is annotated as a ConfigurationParameterChanger but it is not public. Please update your code: this method must be public.");
                }
            }
        }
        return configMethods;
    }

    private static Map<String, Field> buildParameterFieldsMap(Class klass) {
        String className = klass.getName();
        Map<String, Field> res = PARAMETER_MAP.get(className);
        if (res == null) {
            res = new HashMap<String, Field>();
            PARAMETER_MAP.put(className, res);
            Class toIntrospect = klass;
            do {
                Field[] fields;
                for (Field f : fields = toIntrospect.getDeclaredFields()) {
                    String parmName;
                    ConfigurationParameter a = f.getAnnotation(ConfigurationParameter.class);
                    if (a == null) continue;
                    String string = parmName = a.name().isEmpty() ? f.getName() : a.name();
                    if (res.containsKey(parmName)) {
                        throw new RuntimeException("Class " + klass.getSimpleName() + " is erroneously annotated as it contains two parameters with same name : " + parmName);
                    }
                    res.put(parmName, f);
                }
            } while ((toIntrospect = toIntrospect.getSuperclass()) != null);
        }
        return res;
    }
}

