package org.lsst.ccs.subsystem.demo.main;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.utilities.logging.Logger;

public class DemoSubsystemWithMonitoring extends DemoSubsystem implements Monitor.AlarmHandler, ServiceLifecycle {

    private static final Logger log = Logger.getLogger("org.lsst.ccs.subsystem.demo");
        
    @LookupField(strategy = LookupField.Strategy.TREE)
    DataProviderDictionaryService dictionaryService;

    @Override
    public boolean processAlarm(int event, int parm, String cause, String alarmName) {
        log.info("Processing alarm "+event+" "+parm+" "+alarmName);
        return false;
    }
    
    @Override
    public void build() {
        super.build();
//        periodicTaskService.scheduleAgentPeriodicTask(
//                new AgentPeriodicTask("update-limits",
//                        () -> {
//                            Random r = new Random();
//                            double[] vals = new double[]{1.0, 1.5, 2.0};
//                            
//                            setLimitHi(3, false, vals[r.nextInt(vals.length)], 0.4);
//                        })
//                        .withIsFixedRate(true)
//                        .withPeriod(Duration.ofSeconds(30)));
    }
    
    @Command(description = "Modify the hi limit parameters for an nchan number of channels, randomly picked if shuffle is set to true")
    public void setLimitHi(int nchans, boolean shuffle, double limitHi, double dbandHi) {
        List<String> channelNames = subsys.getMonitor().getChannelNames();
        int channelNumber = channelNames.size();
        if (nchans > channelNumber) {
            nchans = channelNumber;
        }
        ArrayList<Integer> randomNumbers = new ArrayList<>();
        for(int i = 0; i<channelNumber;i++) {
            randomNumbers.add(i);
        }
        if (nchans != channelNumber && shuffle) {
            Collections.shuffle(randomNumbers);
        }
        for(int i = 0; i<nchans; i++) {
            subsys.getComponentConfigurationEnvironmentByName(channelNames.get(randomNumbers.get(i))).submitChange("limitHi", limitHi);
            subsys.getComponentConfigurationEnvironmentByName(channelNames.get(randomNumbers.get(i))).submitChange("dbandHi", dbandHi);
        }
        subsys.getConfigurationService().commitBulkChange();
    }
    
    @Command(description = "Reset limit hi for all channels to a value that will not trigger warning or alarms")
    public void resetAllLimitHi() {
        setLimitHi(subsys.getMonitor().getChannelNames().size(), false, 10.0, 0.0);
    }

    
    @Override
    public void preStart() {
        Pattern raft = Pattern.compile(".*RAFT(\\d\\d)/.*");
        Pattern reb = Pattern.compile(".*/REB(\\d)/.*");
        Pattern ccd = Pattern.compile(".*CCD(\\d\\d)/.*");
        Pattern amp = Pattern.compile(".*AMP(\\d\\d).*");
        for ( DataProviderInfo data: dictionaryService.getDataProviderDictionary().getDataProviderInfos() ) {
            String path = data.getPath();
            Matcher m = raft.matcher(path);
            if (m.matches()) {
                data.addAttribute(DataProviderInfo.Attribute.RAFT_ID, "R"+ m.group(1));
                m = reb.matcher(path);
                if (m.matches()) {
                    data.addAttribute(DataProviderInfo.Attribute.REB_ID, "Reb"+ m.group(1));
                }
                m = ccd.matcher(path);
                if (m.matches()) {
                    data.addAttribute(DataProviderInfo.Attribute.SENSOR_ID, "S"+ m.group(1));
                    m = amp.matcher(path);
                    if (m.matches()) {
                        data.addAttribute(DataProviderInfo.Attribute.ASPIC_ID, m.group(1));
                    }
                }
            }
        }
    }





}
