/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.utilities.structs.ParameterPath;

public class ConfigurationView
implements Serializable {
    private static final long serialVersionUID = -1596767856817881046L;
    private ConfigurationDescription configDesc;
    private final Map<String, Map<String, String>> componentsMap = new TreeMap<String, Map<String, String>>();

    public ConfigurationView() {
    }

    public ConfigurationView(ConfigurationDescription configDesc) {
        this.configDesc = configDesc;
    }

    public void putParameterValue(String parameterFullName, String value) {
        ParameterPath pp = ParameterPath.valueOf((String)parameterFullName);
        this.putParameterValue(pp.getComponentName(), pp.getParameterName(), value);
    }

    public void putParameterValue(String componentName, String parmName, String value) {
        Map<String, String> subMap = this.componentsMap.get(componentName);
        if (subMap == null) {
            subMap = new TreeMap<String, String>();
            this.componentsMap.put(componentName, subMap);
        }
        subMap.put(parmName, value);
    }

    public void putAll(ConfigurationView cv) {
        this.configDesc = cv.configDesc;
        for (Map.Entry<String, Map<String, String>> entry : cv.componentsMap.entrySet()) {
            Map<String, String> subMap = this.componentsMap.get(entry.getKey());
            if (subMap == null) {
                subMap = new HashMap<String, String>();
                this.componentsMap.put(entry.getKey(), subMap);
            }
            subMap.putAll(entry.getValue());
        }
    }

    public Map<ParameterPath, String> getAsParameterPathMap() {
        TreeMap<ParameterPath, String> res = new TreeMap<ParameterPath, String>();
        for (Map.Entry<String, Map<String, String>> e1 : this.componentsMap.entrySet()) {
            for (Map.Entry<String, String> e2 : e1.getValue().entrySet()) {
                res.put(new ParameterPath(e1.getKey(), e2.getKey()), e2.getValue());
            }
        }
        return res;
    }

    public ConfigurationView diff(ConfigurationView other) {
        ConfigurationView diff = new ConfigurationView();
        for (Map.Entry<String, Map<String, String>> e1 : this.componentsMap.entrySet()) {
            String comp = e1.getKey();
            for (Map.Entry<String, String> e2 : e1.getValue().entrySet()) {
                Map<String, String> subMap;
                String otherVal;
                String parm = e2.getKey();
                String val = e2.getValue();
                if (val.equals(otherVal = (subMap = other.getValuesForComponent(comp)) == null ? null : subMap.get(parm))) continue;
                diff.putParameterValue(comp, parm, otherVal);
            }
        }
        return diff;
    }

    public boolean containsPath(ParameterPath path) {
        return this.componentsMap.containsKey(path.getComponentName()) && this.componentsMap.get(path.getComponentName()).containsKey(path.getParameterName());
    }

    public String getPathValue(ParameterPath path) {
        return this.componentsMap.get(path.getComponentName()).get(path.getParameterName());
    }

    public ConfigurationDescription getConfigurationDescription() {
        return this.configDesc;
    }

    public void setConfigurationDescription(ConfigurationDescription configDesc) {
        this.configDesc = configDesc;
    }

    public boolean isEmpty() {
        return this.componentsMap.isEmpty();
    }

    public Map<String, String> getValuesForComponent(String componentName) {
        return this.componentsMap.get(componentName);
    }

    public void putValuesForComponent(String componentName, Map<String, String> values) {
        for (Map.Entry<String, String> e : values.entrySet()) {
            this.putParameterValue(componentName, e.getKey(), e.getValue());
        }
    }
}

