/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.demo.main;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.subsystem.demo.main.DemoSubsystem;
import org.lsst.ccs.utilities.logging.Logger;

public class DemoSubsystemWithMonitoring
extends DemoSubsystem
implements Monitor.AlarmHandler,
ServiceLifecycle {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.demo");
    @LookupField(strategy=LookupField.Strategy.TREE)
    DataProviderDictionaryService dictionaryService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    Monitor monitor;
    @LookupField(strategy=LookupField.Strategy.TREE)
    ConfigurationService configurationService;

    public boolean processAlarm(int event, int parm, String cause, String alarmName) {
        log.info((Object)("Processing alarm " + event + " " + parm + " " + alarmName));
        return false;
    }

    @Override
    public void build() {
        super.build();
    }

    @Command(description="Modify the hi limit parameters for an nchan number of channels, randomly picked if shuffle is set to true")
    public void setLimitHi(int nchans, boolean shuffle, double limitHi, double dbandHi) {
        int i;
        List channelNames = this.monitor.getChannelNames();
        int channelNumber = channelNames.size();
        if (nchans > channelNumber) {
            nchans = channelNumber;
        }
        ArrayList<Integer> randomNumbers = new ArrayList<Integer>();
        for (i = 0; i < channelNumber; ++i) {
            randomNumbers.add(i);
        }
        if (nchans != channelNumber && shuffle) {
            Collections.shuffle(randomNumbers);
        }
        for (i = 0; i < nchans; ++i) {
            this.subsys.getComponentConfigurationEnvironmentByName((String)channelNames.get((Integer)randomNumbers.get(i))).submitChange("limitHi", (Object)limitHi);
            this.subsys.getComponentConfigurationEnvironmentByName((String)channelNames.get((Integer)randomNumbers.get(i))).submitChange("dbandHi", (Object)dbandHi);
        }
        this.configurationService.commitBulkChange();
    }

    @Command(description="Reset limit hi for all channels to a value that will not trigger warning or alarms")
    public void resetAllLimitHi() {
        this.setLimitHi(this.monitor.getChannelNames().size(), false, 10.0, 0.0);
    }

    public void preStart() {
        Pattern raft = Pattern.compile(".*RAFT(\\d\\d)/.*");
        Pattern reb = Pattern.compile(".*/REB(\\d)/.*");
        Pattern ccd = Pattern.compile(".*CCD(\\d\\d)/.*");
        Pattern amp = Pattern.compile(".*AMP(\\d\\d).*");
        for (DataProviderInfo data : this.dictionaryService.getDataProviderDictionary().getDataProviderInfos()) {
            String path = data.getPath();
            Matcher m = raft.matcher(path);
            if (!m.matches()) continue;
            data.addAttribute(DataProviderInfo.Attribute.RAFT_ID, "R" + m.group(1));
            m = reb.matcher(path);
            if (m.matches()) {
                data.addAttribute(DataProviderInfo.Attribute.REB_ID, "Reb" + m.group(1));
            }
            if (!(m = ccd.matcher(path)).matches()) continue;
            data.addAttribute(DataProviderInfo.Attribute.SENSOR_ID, "S" + m.group(1));
            m = amp.matcher(path);
            if (!m.matches()) continue;
            data.addAttribute(DataProviderInfo.Attribute.ASPIC_ID, m.group(1));
        }
    }
}

