/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.demo.main;

import hep.aida.IAnalysisFactory;
import hep.aida.IDataPointSet;
import hep.aida.IDataPointSetFactory;
import hep.aida.IHistogram1D;
import hep.aida.IHistogramFactory;
import hep.aida.IManagedObject;
import hep.aida.util.XMLUtils;
import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.demo.bus.DemoData;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;
import org.lsst.ccs.utilities.scheduler.Scheduler;

public class DemoSubsystem
implements HasLifecycle {
    protected PeriodicTask dataPublisher;
    protected PeriodicTask plotPublisher;
    private final IAnalysisFactory af = IAnalysisFactory.create();
    private final IDataPointSetFactory dataPointSetFactory = this.af.createDataPointSetFactory(null);
    private final IHistogramFactory histogramFactory = this.af.createHistogramFactory(null);
    private final Random r = new Random();
    private final ArrayList<PeriodicTask> tracerTestTasks = new ArrayList();
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TOP)
    protected Subsystem subsys;
    private int dataPublishRate = 5;
    private int dataSize = 2;

    public void postStart() {
        this.updateLimits("1.0", "2.0");
    }

    public void postInit() {
        this.subsys.setAgentProperty("agentCategory", "demo");
    }

    public void build() {
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask("demoData-publish", () -> {
            DemoData dd = new DemoData(this.dataSize);
            KeyValueData d = new KeyValueData("demo_Data", (Serializable)dd);
            KeyValueDataList kvdl = new KeyValueDataList();
            kvdl.addData(d);
            this.subsys.publishSubsystemDataOnStatusBus((KeyValueData)kvdl);
        }).withIsFixedRate(false).withPeriod(Duration.ofSeconds(this.dataPublishRate)));
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask("demoPlots-publish", () -> {
            try {
                KeyValueDataList plots = new KeyValueDataList("");
                IHistogram1D histObj = this.histogramFactory.createHistogram1D("test 1d", 50, -3.0, 6.0);
                for (int i = 0; i < 500; ++i) {
                    histObj.fill(this.r.nextGaussian());
                }
                IDataPointSet dps1D = this.dataPointSetFactory.create("dps1D", "one dimensional IDataPointSet", 1);
                for (int i = 0; i < 10; ++i) {
                    dps1D.addPoint().coordinate(0).setValue(this.r.nextDouble());
                }
                plots.addData("histogram1D", (Serializable)((Object)XMLUtils.createXMLString((IManagedObject)((IManagedObject)histObj))), KeyValueData.KeyValueDataType.KeyValuePlotData);
                plots.addData("dataPointSet", (Serializable)((Object)XMLUtils.createXMLString((IManagedObject)((IManagedObject)dps1D))), KeyValueData.KeyValueDataType.KeyValuePlotData);
                this.subsys.publishSubsystemDataOnStatusBus((KeyValueData)plots);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }).withIsFixedRate(false).withPeriod(Duration.ofSeconds(5L)));
    }

    @Command(type=Command.CommandType.ACTION, description="update limits")
    public void updateLimits(String low, String high) {
        KeyValueDataList limits = new KeyValueDataList("demo_Data/temp");
        limits.addData("alarmLow", (Serializable)((Object)low), KeyValueData.KeyValueDataType.KeyValueMetaData);
        limits.addData("alarmHigh", (Serializable)((Object)high), KeyValueData.KeyValueDataType.KeyValueMetaData);
        this.subsys.publishSubsystemDataOnStatusBus((KeyValueData)limits);
    }

    @Command(type=Command.CommandType.QUERY, description="raise custom alert")
    public void raiseCustomAlert(String alertId, AlertState severity, String cause) {
        Alert a = new Alert(alertId, "Custom Alert");
        ((AlertService)this.subsys.getAgentService(AlertService.class)).raiseAlert(a, severity, cause);
    }

    @Command(type=Command.CommandType.QUERY, description="Get Subsystem Data Sample")
    public DemoData getSampleData() {
        return new DemoData(this.dataSize);
    }

    @Command(type=Command.CommandType.QUERY, description="Set Subsystem Data Sample")
    public void setSampleDataSize(int size) {
        this.dataSize = size;
    }

    @Command(type=Command.CommandType.QUERY, description="Get Subsystem Array Sample")
    public Object[] getSampleArrayData() {
        Object[] data = new Object[]{"test", 2.3, new int[]{3, 2, 2, 2}};
        return data;
    }

    @Command(type=Command.CommandType.QUERY, description="Throw an Exception")
    public void throwAnException() {
        throw new RuntimeException("An Exception");
    }

    @Command(type=Command.CommandType.ACTION, description="Enable/Disable Publishing Tracer Test Messages")
    public void runTracerTest(boolean enable) {
        if (enable) {
            Scheduler s = this.subsys.getScheduler();
            this.tracerTestTasks.add(s.scheduleAtFixedRate(() -> this.subsys.getLogger().info((Object)("Self test on module " + this.r.nextInt(1000) + (this.r.nextInt(5) > 0 ? ": OK" : ": FAILED"))), 0L, 7L, TimeUnit.SECONDS));
            this.tracerTestTasks.add(s.scheduleAtFixedRate(() -> this.subsys.getLogger().warn((Object)"London Bridge is in trouble, please repair."), 2L, 15L, TimeUnit.SECONDS));
            this.tracerTestTasks.add(s.scheduleAtFixedRate(() -> this.subsys.getLogger().error((Object)"Sun has gone supernova."), 3L, 13L, TimeUnit.SECONDS));
        } else {
            this.tracerTestTasks.forEach(task -> task.cancel(false));
            this.tracerTestTasks.clear();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Time out (action command)")
    public String testTimeout(int sleepSeconds) {
        if (sleepSeconds > 0) {
            try {
                Thread.sleep((long)sleepSeconds * 1000L);
            }
            catch (InterruptedException x) {
                return "Interrupted";
            }
        }
        return "Done.";
    }

    @Command(type=Command.CommandType.QUERY, description="Test sending ACK/NACK. Delays are in seconds.", autoAck=false)
    public Object testAck(boolean accept, int delayBeforeAck, int delayAfterAck, int timeout, boolean returnException) {
        if (delayBeforeAck > 0) {
            try {
                Thread.sleep((long)delayBeforeAck * 1000L);
            }
            catch (InterruptedException x) {
                return "Interrupted while waiting to send ACK/NACK";
            }
        }
        if (accept) {
            if (timeout > 0) {
                this.subsys.sendAck(Duration.ofSeconds(timeout));
            } else {
                this.subsys.sendAck(null);
            }
        } else {
            this.subsys.sendNack((Serializable)((Object)"Sending NACK as requested."));
            return "NACK";
        }
        if (delayAfterAck > 0) {
            try {
                Thread.sleep((long)delayAfterAck * 1000L);
            }
            catch (InterruptedException x) {
                return "Interrupted while waiting to send the result";
            }
        }
        return returnException ? new RuntimeException("Requsted exception result") : "Done.";
    }

    @Command(type=Command.CommandType.ACTION, description="Publish AIDA plot")
    public void publishPlot(String key, String path, String title) {
        try {
            KeyValueDataList plots = new KeyValueDataList("test_plots");
            IHistogram1D histObj = this.histogramFactory.createHistogram1D(path, title, 50, -3.0, 6.0);
            for (int i = 0; i < 500; ++i) {
                histObj.fill(this.r.nextGaussian());
            }
            plots.addData(key, (Serializable)((Object)XMLUtils.createXMLString((IManagedObject)((IManagedObject)histObj))), KeyValueData.KeyValueDataType.KeyValuePlotData);
            this.subsys.publishSubsystemDataOnStatusBus((KeyValueData)plots);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Command(type=Command.CommandType.ACTION)
    public void updateState(String componentName, DemoState state) {
        if ("".equals(componentName)) {
            this.subsys.updateAgentState(new Enum[]{state});
        } else {
            Object componentToUpdate = this.subsys.getComponentLookup().getComponentByPath(componentName);
            if (componentToUpdate == null) {
                throw new IllegalArgumentException("No component corresponds to path " + componentName);
            }
            this.subsys.updateAgentComponentState(componentToUpdate, new Enum[]{state});
        }
    }

    public static enum AState {
        A,
        B;

    }

    public static enum OtherState {
        LOW,
        HIGH;

    }

    public static enum DemoState {
        IDLE,
        BUSY;

    }
}

