import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.demo.main.DemoSubsystemWithMonitoring;
import org.lsst.ccs.subsystem.demo.main.device.DemoDevice;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Page;

CCSBuilder builder = ["monitor-test"]

builder.
    "main" (DemoSubsystemWithMonitoring) {
    
    Alarm1  (Alarm, [description:"Trips off all power", lineName:null, eventParm:0])
        
    REB0  (DemoDevice, name:"REB0")
    REB1  (DemoDevice, name:"REB1")
    REB2  (DemoDevice, name:"REB2")
    RSA  (DemoDevice, name:"RSA")

    Page1 (Page, id: 1, label: "Page1")
    Page2 (Page, id: 2, label: "Page2")
     
            "REB0/Global/Power/VP5_UNREG/Voltage"  (Channel, description:"c001", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:10.0, alarmHi:"Alarm1", pageId: 1)
    "REB0/Global/Power/VP5_UNREG/Current"  (Channel, description:"c002", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:12.0, alarmHi:"Alarm1", pageId: 2)
    "REB0/Global/Power/VP5_UNREG/Power"  (Channel, description:"c003", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:12.0, alarmHi:"Alarm1")
    "REB0/Global/Power/VP7_UNREG/Voltage"  (Channel, description:"c004", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:10.0, alarmHi:"Alarm1")
    "REB0/Global/Power/VP7_UNREG/Current"  (Channel, description:"c005", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:12.0, alarmHi:"Alarm1")
    "REB0/Global/Power/VP7_UNREG/Power"  (Channel, description:"c006", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:12.0, alarmHi:"Alarm1")
    "REB0/Global/Power/VP15_UNREG/Voltage"  (Channel, description:"c007", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:10.0, alarmHi:"Alarm1")
    "REB0/Global/Power/VP15_UNREG/Current"  (Channel, description:"c008", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:12.0, alarmHi:"Alarm1")
    "REB0/Global/Power/VP15_UNREG/Power"  (Channel, description:"c009", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:12.0, alarmHi:"Alarm1")
    "REB0/Global/Power/Total Power/Power"  (Channel, description:"c010", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:12.0, alarmHi:"Alarm1")

    "REB0/Global/Clock Rails/P_LO"  (Channel, description:"c011", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:12.0, alarmHi:"Alarm1")
    "REB0/Global/Clock Rails/P_HI"  (Channel, description:"c012", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:12.0, alarmHi:"Alarm1")
    
        "REB1/Global/Power/VP5_UNREG/Voltage"  (Channel, description:"c001", format:"f", devcName:"REB1", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:10.0, alarmHi:"Alarm1")
    "REB1/Global/Power/VP5_UNREG/Current"  (Channel, description:"c002", format:"f", devcName:"REB1", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:12.0, alarmHi:"Alarm1")
    "REB1/Global/Power/VP5_UNREG/Power"  (Channel, description:"c003", format:"f", devcName:"REB1", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:12.0, alarmHi:"Alarm1")
    "REB1/Global/Power/VP7_UNREG/Voltage"  (Channel, description:"c004", format:"f", devcName:"REB1", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:10.0, alarmHi:"Alarm1")
    "REB1/Global/Power/VP7_UNREG/Current"  (Channel, description:"c005", format:"f", devcName:"REB1", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:12.0, alarmHi:"Alarm1")
    "REB1/Global/Power/VP7_UNREG/Power"  (Channel, description:"c006", format:"f", devcName:"REB1", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:12.0, alarmHi:"Alarm1")
    "REB1/Global/Power/VP15_UNREG/Voltage"  (Channel, description:"c007", format:"f", devcName:"REB1", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:10.0, alarmHi:"Alarm1")
    "REB1/Global/Power/VP15_UNREG/Current"  (Channel, description:"c008", format:"f", devcName:"REB1", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:12.0, alarmHi:"Alarm1")
    "REB1/Global/Power/VP15_UNREG/Power"  (Channel, description:"c009", format:"f", devcName:"REB1", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:12.0, alarmHi:"Alarm1")
    "REB1/Global/Power/Total Power/Power"  (Channel, description:"c010", format:"f", devcName:"REB1", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:12.0, alarmHi:"Alarm1")
    
    "REB1/Global/Clock Rails/P_LO"  (Channel, description:"c011", format:"f", devcName:"REB1", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:12.0, alarmHi:"Alarm1")
    "REB1/Global/Clock Rails/P_HI"  (Channel, description:"c012", format:"f", devcName:"REB1", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"alarm", limitHi:12.0, alarmHi:"Alarm1")
    
}
