/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.demo.main;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.subsystem.demo.main.DemoSubsystem;
import org.lsst.ccs.utilities.logging.Logger;

public class DemoSubsystemWithMonitoring
extends DemoSubsystem
implements Monitor.AlarmHandler {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.demo");

    public boolean processAlarm(int event, int parm, String cause, String alarmName) {
        log.info((Object)("Processing alarm " + event + " " + parm + " " + alarmName));
        return false;
    }

    @Override
    public void build() {
        super.build();
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask("update-limits", () -> {
            Random r = new Random();
            double[] vals = new double[]{1.0, 1.5, 2.0};
            this.setLimitHi(3, false, vals[r.nextInt(vals.length)], 0.4);
        }).withIsFixedRate(true).withPeriod(Duration.ofSeconds(30L)));
    }

    @Command(description="Modify the hi limit parameters for an nchan number of channels, randomly picked if shuffle is set to true")
    public void setLimitHi(int nchans, boolean shuffle, double limitHi, double dbandHi) {
        int i;
        List channelNames = this.subsys.getMonitor().getChannelNames();
        int channelNumber = channelNames.size();
        if (nchans > channelNumber) {
            nchans = channelNumber;
        }
        ArrayList<Integer> randomNumbers = new ArrayList<Integer>();
        for (i = 0; i < channelNumber; ++i) {
            randomNumbers.add(i);
        }
        if (nchans != channelNumber && shuffle) {
            Collections.shuffle(randomNumbers);
        }
        for (i = 0; i < nchans; ++i) {
            this.subsys.getComponentConfigurationEnvironmentByName((String)channelNames.get((Integer)randomNumbers.get(i))).submitChange("limitHi", (Object)limitHi);
            this.subsys.getComponentConfigurationEnvironmentByName((String)channelNames.get((Integer)randomNumbers.get(i))).submitChange("dbandHi", (Object)dbandHi);
        }
        this.subsys.getConfigurationService().commitBulkChange();
    }

    @Command(description="Reset limit hi for all channels to a value that will not trigger warning or alarms")
    public void resetAllLimitHi() {
        this.setLimitHi(this.subsys.getMonitor().getChannelNames().size(), false, 10.0, 0.0);
    }
}

