/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.description;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.lsst.ccs.description.ComponentNode;

public class ComponentLookup {
    private final ComponentNode top;
    private final Map<String, ComponentNode> componentNodeDict = new HashMap<String, ComponentNode>();

    public ComponentLookup(ComponentNode top) {
        this.top = top;
        this.buildDict(top);
    }

    public ComponentNode getTopComponentNode() {
        return this.top;
    }

    private void buildDict(ComponentNode<?> node) {
        this.addComponentNode(node);
        for (ComponentNode child : node.getChildren()) {
            this.buildDict(child);
        }
    }

    private void addComponentNode(ComponentNode node) {
        this.componentNodeDict.put(node.getPath(), node);
    }

    public void setComponentNodeName(ComponentNode node, String name) {
        node.setKey(name);
        this.componentNodeDict.clear();
        this.buildDict(this.getTopComponentNode());
    }

    public void addComponentNodeToLookup(ComponentNode parent, ComponentNode node) {
        if (parent == null) {
            throw new RuntimeException("Parent node cannot be null");
        }
        parent.addChild(node);
        this.buildDict(node);
    }

    public Object getComponentByPath(String path) {
        ComponentNode node = this.componentNodeDict.get(path);
        if (node == null) {
            ComponentNode.logger.log(Level.WARNING, "null reference associated to path {0}", (Object)path);
            return null;
        }
        return node.getComponent();
    }

    @Deprecated
    public Object getComponentByName(String name) {
        for (ComponentNode node : this.componentNodeDict.values()) {
            if (!node.getKey().equals(name)) continue;
            return node.getComponent();
        }
        ComponentNode.logger.log(Level.WARNING, "null reference associated to path {0}", (Object)name);
        return null;
    }

    public ComponentNode getNodeByPath(String path) {
        ComponentNode node = this.componentNodeDict.get(path);
        if (node == null) {
            ComponentNode.logger.log(Level.WARNING, "no component for path {0}", (Object)path);
            return null;
        }
        return node;
    }

    public String getNameOfComponent(Object obj) {
        ComponentNode componentNode = this.getComponentNodeForObject(obj);
        if (componentNode != null) {
            return componentNode.getKey();
        }
        return null;
    }

    public ComponentNode getComponentNodeForObject(Object obj) {
        for (Map.Entry<String, ComponentNode> entry : this.componentNodeDict.entrySet()) {
            if (entry.getValue().getComponent() != obj) continue;
            return entry.getValue();
        }
        return null;
    }

    public <N> Map<String, N> getChildren(ComponentNode node, Class<N> classFilter) {
        ArrayList children = new ArrayList();
        if (node == null) {
            children.add(this.getTopComponentNode());
        } else {
            children.addAll(node.getChildren());
        }
        LinkedHashMap<String, Object> mapRes = new LinkedHashMap<String, Object>();
        for (ComponentNode componentNode : children) {
            Object realValue = componentNode.getComponent();
            if (classFilter != null && !classFilter.isAssignableFrom(realValue.getClass())) continue;
            mapRes.put(componentNode.getKey(), realValue);
        }
        return mapRes;
    }

    public <N> List<N> listDescendants(ComponentNode node, Class<N> classFilter) {
        ArrayList children = new ArrayList();
        if (node == null) {
            children.add(this.getTopComponentNode());
        } else {
            children.addAll(node.getChildren());
        }
        ArrayList<N> res = new ArrayList<N>();
        res.addAll(this.listChildren(node, classFilter));
        for (ComponentNode componentNode : children) {
            res.addAll(this.listDescendants(componentNode, classFilter));
        }
        return res;
    }

    public <Q> List<Q> listChildren(ComponentNode node, Class<Q> klass) {
        return this.getChildren(node, klass).values().stream().collect(Collectors.toList());
    }

    public boolean containsComponent(Object obj) {
        return this.getComponentNodeForObject(obj) != null;
    }
}

