package org.lsst.ccs.subsystem.demo.main.device;

import java.time.Duration;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.demo.DemoDriver;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.services.DataProviderDictionaryService;


/**
 * Monitoring Device. It publishes a metadata called 'devicemetadata' at its
 * level, that will therefore be associated to all its channels.
 *
 * @author turri
 */
public class OtherDevice extends Device {
    
    @LookupField(strategy=LookupField.Strategy.TREE)
    private DataProviderDictionaryService dataProviderDictionaryService;
    
    private DemoDriver driver;
    private final String id;
    private final Random r = new Random();
    private int meta;

    public OtherDevice(String id) {
        this.id = id;
    }

    public String getId() {
        return id;
    }
    
    @Override
    public void build() {
        s.getAgentPeriodicTaskService().scheduleAgentPeriodicTask(
        new AgentPeriodicTask(name + "-update-metadata",
        () -> { 
            meta+=2;
            dataProviderDictionaryService.publishMetadataForObject("devicemetadata", String.valueOf(meta), this);
        }).withPeriod(Duration.ofSeconds(-1))
        );
    }

    @Override
    protected void initialize() {
        if (driver == null) {
            try {
                driver = new DemoDriver();
            } catch (DriverException ex) {
                Logger.getLogger(OtherDevice.class.getName()).log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
        }
        setOnline(true);
    }

    @Override
    protected void close() {
        if (driver != null) {
            try {
                driver.close();
                driver = null;
            } catch (DriverException ex) {
                Logger.getLogger(OtherDevice.class.getName()).log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    protected double readChannel(int chan, int type) {
        return chan + r.nextGaussian();
    }
    
}
