/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis;

import java.io.Serializable;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.UnivariateRealFunction;

public class PolynomialFunctionNewtonForm
implements UnivariateRealFunction,
Serializable {
    static final long serialVersionUID = -3353896576191389897L;
    private double[] coefficients;
    private double[] a;
    private double[] c;
    private boolean coefficientsComputed;

    PolynomialFunctionNewtonForm(double[] a, double[] c) throws IllegalArgumentException {
        PolynomialFunctionNewtonForm.verifyInputArray(a, c);
        this.a = new double[a.length];
        this.c = new double[c.length];
        System.arraycopy(a, 0, this.a, 0, a.length);
        System.arraycopy(c, 0, this.c, 0, c.length);
        this.coefficientsComputed = false;
    }

    public double value(double z) throws FunctionEvaluationException {
        return PolynomialFunctionNewtonForm.evaluate(this.a, this.c, z);
    }

    public int degree() {
        return this.c.length;
    }

    public double[] getNewtonCoefficients() {
        double[] out = new double[this.a.length];
        System.arraycopy(this.a, 0, out, 0, this.a.length);
        return out;
    }

    public double[] getCenters() {
        double[] out = new double[this.c.length];
        System.arraycopy(this.c, 0, out, 0, this.c.length);
        return out;
    }

    public double[] getCoefficients() {
        if (!this.coefficientsComputed) {
            this.computeCoefficients();
        }
        double[] out = new double[this.coefficients.length];
        System.arraycopy(this.coefficients, 0, out, 0, this.coefficients.length);
        return out;
    }

    public static double evaluate(double[] a, double[] c, double z) throws FunctionEvaluationException, IllegalArgumentException {
        PolynomialFunctionNewtonForm.verifyInputArray(a, c);
        int n = c.length;
        double value = a[n];
        for (int i = n - 1; i >= 0; --i) {
            value = a[i] + (z - c[i]) * value;
        }
        return value;
    }

    protected void computeCoefficients() {
        int i;
        int n = this.degree();
        this.coefficients = new double[n + 1];
        for (i = 0; i <= n; ++i) {
            this.coefficients[i] = 0.0;
        }
        this.coefficients[0] = this.a[n];
        for (i = n - 1; i >= 0; --i) {
            for (int j = n - i; j > 0; --j) {
                this.coefficients[j] = this.coefficients[j - 1] - this.c[i] * this.coefficients[j];
            }
            this.coefficients[0] = this.a[i] - this.c[i] * this.coefficients[0];
        }
        this.coefficientsComputed = true;
    }

    protected static void verifyInputArray(double[] a, double[] c) throws IllegalArgumentException {
        if (a.length < 1 || c.length < 1) {
            throw new IllegalArgumentException("Input arrays must not be empty.");
        }
        if (a.length != c.length + 1) {
            throw new IllegalArgumentException("Bad input array sizes, should have difference 1.");
        }
    }
}

