/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;

public class ComponentConfigurationEnvironment {
    private final String name;
    private final ConfigurationService configurationCommandSet;

    ComponentConfigurationEnvironment(String name, ConfigurationService configurationCommandSet) {
        this.name = name;
        this.configurationCommandSet = configurationCommandSet;
    }

    @Command(description="engineering mode change of parameter value", type=Command.CommandType.CONFIGURATION)
    public void change(@Argument(name="parameterName", description="Configuration parameter name") String parameterName, @Argument(name="value", description="Configuration parameter value") Object value) {
        this.configurationCommandSet.change(this.name, parameterName, value);
    }

    @Command(description="submit a potential change for a parameter", type=Command.CommandType.CONFIGURATION)
    public void submitChange(@Argument(name="parameterName", description="Configuration parameter name") String parameterName, @Argument(name="value", description="Configuration parameter value") Object value) {
        this.configurationCommandSet.submitChange(this.name, parameterName, value);
    }

    @Command(description="submit potential changes for parameters", type=Command.CommandType.CONFIGURATION)
    public void submitChanges(Map<String, Object> values) {
        try {
            for (Map.Entry<String, Object> parameter : values.entrySet()) {
                this.submitChange(parameter.getKey(), parameter.getValue());
            }
        }
        catch (Exception ex) {
            this.configurationCommandSet.dropAllSubmittedChanges();
            throw ex;
        }
    }

    public String getConfigurationParameterValue(String parameterName) {
        return this.configurationCommandSet.getConfigurationParameterValue(this.name, parameterName);
    }

    public void saveAllChanges() {
        this.configurationCommandSet.saveAllChanges();
    }

    public void saveChangesForCategories(String ... categories) {
        this.configurationCommandSet.saveChangesForCategories(categories);
    }

    public void saveChangesForCategoriesAs(String ... taggedCategories) {
        this.configurationCommandSet.saveChangesForCategoriesAs(taggedCategories);
    }

    public void dropAllChanges() {
        this.configurationCommandSet.dropAllChanges();
    }

    public void dropChangesForCategories(String ... categories) {
        this.configurationCommandSet.dropChangesForCategories(categories);
    }

    @Command
    public Boolean isParameterConfigurable(String parameterName) {
        return this.configurationCommandSet.isParameterConfigurable(this.name, parameterName);
    }

    @Command(description="displays the current values of the parameters that belong to the given categories", type=Command.CommandType.CONFIGURATION)
    public Map<String, String> printConfigurableParameters(@Argument(defaultValue="[]") String[] categories) {
        return this.configurationCommandSet.getCurrentValuesForComponent(this.name, new HashSet<String>(Arrays.asList(categories)));
    }

    @Command(description="prints the current state of the submitted changes", type=Command.CommandType.CONFIGURATION)
    public Map<String, String> getSubmittedChanges() {
        return this.configurationCommandSet.getSubmittedChangesForComponent(this.name);
    }

    @Command(description="drops the submitted changes for this component", type=Command.CommandType.CONFIGURATION)
    public void dropSubmittedChanges() {
        this.configurationCommandSet.dropSubmittedChangesForComponent(this.name);
    }
}

