/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.ref.function.PolynomialCoreNotNorm;

public class PolynomialCoreNorm
extends PolynomialCoreNotNorm {
    public PolynomialCoreNorm(String str) {
        super(1, PolynomialCoreNorm.getDimension(str) - 1);
        this.setTitle("PolynomialCoreNorm::" + str);
        this.providesNormalization = true;
        String[] pNames = new String[this.numberOfParameters];
        for (int i = 0; i < this.numberOfParameters; ++i) {
            pNames[i] = "p" + (i + 1);
        }
        this.setParameterNames(pNames);
    }

    public PolynomialCoreNorm(String str, double[] pVal) {
        super(1, PolynomialCoreNorm.getDimension(str) - 1, pVal);
        this.setTitle("PolynomialCoreNorm::" + str);
        this.providesNormalization = true;
        String[] pNames = new String[this.numberOfParameters];
        for (int i = 0; i < this.numberOfParameters; ++i) {
            pNames[i] = "p" + (i + 1);
        }
        this.setParameterNames(pNames);
    }

    @Override
    public double functionValue(double[] var) {
        double val = 0.0;
        for (int i = 0; i < this.numberOfParameters; ++i) {
            val += this.p[i] * Math.pow(var[0], i + 1);
        }
        return val += 1.0;
    }

    @Override
    public double[] gradient(double[] var) {
        double[] tmp = new double[]{0.0};
        if (this.numberOfParameters == 0) {
            return tmp;
        }
        double val = this.p[0];
        for (int i = 1; i < this.numberOfParameters; ++i) {
            val += (double)i * this.p[i] * Math.pow(var[0], i);
        }
        tmp[0] = val;
        return tmp;
    }

    @Override
    public double[] parameterGradient(double[] var) {
        double[] tmp = new double[this.numberOfParameters];
        tmp[0] = 1.0;
        for (int i = 1; i < this.numberOfParameters; ++i) {
            tmp[i] = Math.pow(var[0], i);
        }
        return tmp;
    }

    @Override
    public double normalizationAmplitude(double[] xMin, double[] xMax) {
        double val = 0.0;
        val += xMax[0] - xMin[0];
        for (int i = 0; i < this.numberOfParameters; ++i) {
            val += this.p[i] / (double)(i + 2) * (Math.pow(xMax[0], i + 2) - Math.pow(xMin[0], i + 2));
        }
        return val;
    }
}

