/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.services.lock.Lock;

public class MonitorTableCellRenderer
extends DefaultTableCellRenderer {
    private boolean ensureWidth = false;
    private boolean ensureHeight = false;
    private Border border;
    private boolean extraPadding = true;

    public void setEnsureWidth(boolean ensureWidth) {
        this.ensureWidth = ensureWidth;
    }

    public void setEnsureHeight(boolean ensureHeight) {
        this.ensureHeight = ensureHeight;
    }

    public void setPadding(int top, int left, int bottom, int right) {
        if (top == 0 && left == 0 && bottom == 0 && right == 0) {
            this.extraPadding = false;
            this.border = null;
        } else {
            this.extraPadding = true;
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int charHeight = fm.getAscent();
            int charWidth = fm.charWidth(' ');
            if (top < 0) {
                top = -top * charHeight;
            }
            if (left < 0) {
                left = -left * charWidth;
            }
            if (bottom < 0) {
                bottom = -bottom * charHeight;
            }
            if (right < 0) {
                right = -right * charWidth;
            }
            this.border = BorderFactory.createEmptyBorder(top, left, bottom, right);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int h;
        TableColumn c;
        int w;
        if (value instanceof FormattedValue) {
            FormattedValue fv = (FormattedValue)value;
            super.getTableCellRendererComponent(table, fv.getText(), false, false, row, column);
            if (fv.value instanceof AgentLock) {
                this.setEnsureHeight(true);
                AgentLock lock = (AgentLock)fv.value;
                ImageIcon icon = Lock.getIcon(lock.getAgentName());
                this.setIcon(icon);
            } else {
                this.setIcon(null);
            }
            this.setBackground(fv.getBgColor());
            this.setForeground(fv.getFgColor());
            this.setHorizontalAlignment(fv.getHorizontalAlignment());
            this.setToolTipText(fv.getToolTip());
        } else if (value == null) {
            super.getTableCellRendererComponent(table, " ", false, false, row, column);
            TableColumn c2 = table.getColumnModel().getColumn(column);
            this.setBackground(MonitorField.COLOR_OFF);
            this.setHorizontalAlignment(0);
        } else {
            super.getTableCellRendererComponent(table, value.toString(), false, false, row, column);
            this.setHorizontalAlignment(0);
        }
        if (this.extraPadding) {
            Border b;
            if (this.border == null) {
                this.setPadding(0, -1, 0, -1);
            }
            if ((b = this.getBorder()) == null) {
                this.setBorder(this.border);
            } else {
                this.setBorder(BorderFactory.createCompoundBorder(b, this.border));
            }
        }
        if (this.ensureWidth && (w = this.getMinimumSize().width + 2) > (c = table.getColumnModel().getColumn(column)).getMinWidth()) {
            c.setMinWidth(w);
        }
        if (this.ensureHeight && (h = this.getMinimumSize().height) > table.getRowHeight(row)) {
            table.setRowHeight(row, h);
        }
        return this;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }
}

