/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.web;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.freehep.jas.plugin.web.SimpleWebBrowser;

class WebPreferences
extends JPanel {
    private SimpleWebBrowser plugin;
    private JTextField homePage;
    private JCheckBox antiAlias;
    private JCheckBox showAtStart;

    WebPreferences(SimpleWebBrowser plugin) {
        this.plugin = plugin;
        this.initComponents();
    }

    private void initComponents() {
        JLabel jLabel1 = new JLabel();
        this.homePage = new JTextField();
        this.showAtStart = new JCheckBox();
        this.antiAlias = new JCheckBox();
        this.setLayout(new GridBagLayout());
        jLabel1.setText("Home Page:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)jLabel1, gridBagConstraints);
        this.homePage.setText(this.plugin.getHomePage() == null ? "" : this.plugin.getHomePage().toExternalForm());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.homePage, gridBagConstraints);
        this.showAtStart.setSelected(this.plugin.isShowAtStart());
        this.showAtStart.setText("Show home page at start-up");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.showAtStart, gridBagConstraints);
        this.antiAlias.setSelected(this.plugin.isAntiAlias());
        this.antiAlias.setText("Anti-alias text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.antiAlias, gridBagConstraints);
    }

    boolean apply() {
        try {
            String homePageText = this.homePage.getText();
            URL url = homePageText.length() == 0 ? null : new URL(homePageText);
            this.plugin.setHomePage(url);
            this.plugin.setShowAtStart(this.showAtStart.isSelected());
            this.plugin.setAntiAlias(this.antiAlias.isSelected());
            return true;
        }
        catch (MalformedURLException x) {
            JOptionPane.showMessageDialog(this, "Malformed URL", "Error", 0);
            this.homePage.requestFocus();
            return false;
        }
    }
}

