/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.bus.data.AgentLockInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.AgentLockServiceDelegate;
import org.lsst.ccs.services.AgentLoginService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.RemoteAgentLockService;
import org.lsst.ccs.services.UnauthorizedLevelException;
import org.lsst.ccs.services.UnauthorizedLockException;
import org.lsst.ccs.utilities.logging.Logger;

public abstract class AbstractAgentLockServiceDelegate
implements AgentLockServiceDelegate,
AgentPresenceListener,
AgentLoginService.AgentLoginUpdateListener {
    protected static final Logger log = Logger.getLogger((String)"org.lsst.ccs.services.lockservice");
    protected AgentLockService svc;
    protected final List<AgentLockService.AgentLockUpdateListener> agentLockUpdateListeners = new CopyOnWriteArrayList<AgentLockService.AgentLockUpdateListener>();
    protected final Map<String, Integer> agentLevels = new ConcurrentHashMap<String, Integer>();
    protected final Map<String, AgentLock> heldLocks = new ConcurrentHashMap<String, AgentLock>();
    protected final Map<String, AgentLock> allLocks = new ConcurrentHashMap<String, AgentLock>();
    protected volatile AgentLock myCurrentLock = null;
    protected final int enforceLevel;
    protected final Object listenerUpdatesLock = new Object();

    protected Agent getAgent() {
        return this.svc.getAgent();
    }

    protected AgentStateService getAgentStateService() {
        return this.svc.getAgentStateService();
    }

    public AbstractAgentLockServiceDelegate(AgentLockService svc) {
        int i;
        this.svc = svc;
        String s = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.lockservice.enforceLevel", "0");
        try {
            i = Integer.parseInt(s.trim());
        }
        catch (NumberFormatException x) {
            i = switch (s.toLowerCase().strip()) {
                case "off", "false" -> 0;
                case "soft" -> 1;
                case "hard", "strict", "true" -> 2;
                default -> {
                    log.warning((Object)("Unrecognized value of org.lsst.ccs.lockservice.enforceLevel: " + s + ". Command levels will be strictly enforced."));
                    yield 2;
                }
            };
        }
        this.enforceLevel = i;
    }

    @Override
    public void preInit() {
        log.debug((Object)("AbstractAgentLockServiceDelegate preInit for " + this));
        this.getAgent().getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        this.svc.getAgentLoginService().addAgentLoginUpdateListener(this);
        StringBuilder sb = new StringBuilder("Lock management: ").append(this instanceof RemoteAgentLockService ? "remote" : "local");
        sb.append(". Level enforcement: ");
        switch (this.enforceLevel) {
            case 0: {
                sb.append("OFF. Command is accepted as long any valid lock or 'withLock' option is provided. Levels are ignored.");
                break;
            }
            case 1: {
                sb.append("SOFT. Command is accepted if the user is authorized to execute it, regardless of the level currently set on the issuing script or console.");
                break;
            }
            case 2: {
                sb.append("STRICT. Command is accepted if the user is authorized to execute it, and sufficient level is set on the issuing script or console.");
                break;
            }
            default: {
                sb.append("illegal value: ").append(this.enforceLevel);
            }
        }
        log.info((Object)sb.toString());
    }

    @Override
    public void preStart() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLevelForAgent(String agentName) {
        Object object = this.listenerUpdatesLock;
        synchronized (object) {
            if (this.getHeldLocks().get(agentName) == null) {
                return 0;
            }
            return this.agentLevels.getOrDefault(agentName, 0);
        }
    }

    @Override
    public AgentLock getLockForAgent(String agentName) {
        AgentLock lock = this.getHeldLocks().get(agentName);
        if (lock != null && !lock.getOwner().equals(this.svc.getUserId())) {
            return null;
        }
        return lock;
    }

    @Override
    public AgentLock getExistingLockForAgent(String agentName) {
        AgentLock lock = this.getLocks().get(agentName);
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, AgentLock> getHeldLocks() {
        Object object = this.listenerUpdatesLock;
        synchronized (object) {
            HashMap<String, AgentLock> res = new HashMap<String, AgentLock>();
            this.heldLocks.entrySet().stream().filter(e -> ((AgentLock)e.getValue()).getOwner().equals(this.svc.getUserId())).forEach(e -> res.put((String)e.getKey(), (AgentLock)e.getValue()));
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addHeldLock(AgentLock lock) throws UnauthorizedLockException {
        Object object = this.listenerUpdatesLock;
        synchronized (object) {
            String agentName = lock.getAgentName();
            this.heldLocks.put(agentName, lock);
            this.agentLevels.remove(agentName);
        }
        this.notifyHeldLockListeners(lock.getAgentName(), lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeHeldLock(String agentName, AgentLock info) throws UnauthorizedLockException {
        Object object = this.listenerUpdatesLock;
        synchronized (object) {
            this.heldLocks.remove(agentName);
        }
        this.notifyHeldLockListeners(agentName, null);
    }

    protected void setCurrentLock(AgentLock lock) {
        this.myCurrentLock = lock;
        this.notifyLockListeners(lock.getAgentName(), lock.getOwner(), lock);
    }

    public AgentLock getCurrentLock() {
        return this.myCurrentLock;
    }

    protected void removeCurrentLock() {
        AgentLock oldLock = this.myCurrentLock;
        this.myCurrentLock = null;
        if (oldLock != null) {
            this.notifyLockListeners(oldLock.getAgentName(), oldLock.getOwner(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAgentLockUpdateListener(AgentLockService.AgentLockUpdateListener aluListener) {
        HashMap<String, AgentLock> heldLocksCopy = null;
        Iterator iterator = this.listenerUpdatesLock;
        synchronized (iterator) {
            heldLocksCopy = new HashMap<String, AgentLock>(this.heldLocks);
            this.agentLockUpdateListeners.add(aluListener);
        }
        for (Map.Entry entry : heldLocksCopy.entrySet()) {
            try {
                aluListener.onAgentHeldLockUpdate((String)entry.getKey(), (AgentLock)entry.getValue());
            }
            catch (Exception e) {
                log.error((Object)"exception while calling onAgentHeldLockUpdate for backlog on new listener ", (Throwable)e);
            }
        }
    }

    @Override
    public void removeAgentLockUpdateListener(AgentLockService.AgentLockUpdateListener aluListener) {
        this.agentLockUpdateListeners.remove(aluListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLockListeners(String agentName, String owner, AgentLock lock) {
        ArrayList<AgentLockService.AgentLockUpdateListener> alul;
        Object object = this.listenerUpdatesLock;
        synchronized (object) {
            alul = new ArrayList<AgentLockService.AgentLockUpdateListener>(this.agentLockUpdateListeners);
        }
        alul.forEach(l -> l.onAgentLockUpdate(agentName, owner, lock));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyHeldLockListeners(String agentName, AgentLock lock) {
        ArrayList<AgentLockService.AgentLockUpdateListener> alul;
        Object object = this.listenerUpdatesLock;
        synchronized (object) {
            alul = new ArrayList<AgentLockService.AgentLockUpdateListener>(this.agentLockUpdateListeners);
        }
        alul.forEach(l -> l.onAgentHeldLockUpdate(agentName, lock));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyGlobalLockListeners(String agentName, AgentLock lock) {
        ArrayList<AgentLockService.AgentLockUpdateListener> alul;
        Object object = this.listenerUpdatesLock;
        synchronized (object) {
            alul = new ArrayList<AgentLockService.AgentLockUpdateListener>(this.agentLockUpdateListeners);
        }
        alul.forEach(l -> l.onGlobalLockUpdate(agentName, lock.getOwner(), lock));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLevelListeners(String agentName, int level) {
        ArrayList<AgentLockService.AgentLockUpdateListener> alul;
        Object object = this.listenerUpdatesLock;
        synchronized (object) {
            alul = new ArrayList<AgentLockService.AgentLockUpdateListener>(this.agentLockUpdateListeners);
        }
        alul.forEach(l -> l.onAgentLevelChange(agentName, level));
    }

    protected void notifyLockVisibility(String oldUserid, String newUserid) {
        this.heldLocks.values().stream().filter(l -> l.getOwner().equals(oldUserid)).forEach(l -> this.notifyHeldLockListeners(l.getAgentName(), (AgentLock)(l instanceof AgentLockInfo ? AgentLockInfo.createLoginInvisble((AgentLockInfo)((AgentLockInfo)l)) : null)));
        this.heldLocks.values().stream().filter(l -> l.getOwner().equals(newUserid)).forEach(l -> this.notifyHeldLockListeners(l.getAgentName(), (AgentLock)(l instanceof AgentLockInfo ? AgentLockInfo.createLoginVisble((AgentLockInfo)((AgentLockInfo)l)) : l)));
        Set heldLockAgents = this.heldLocks.values().stream().map(AgentLock::getAgentName).collect(Collectors.toSet());
        this.allLocks.values().stream().filter(l -> !heldLockAgents.contains(l.getAgentName())).filter(l -> l.getOwner().equals(oldUserid)).forEach(l -> this.notifyHeldLockListeners(l.getAgentName(), (AgentLock)(l instanceof AgentLockInfo ? AgentLockInfo.createLoginInvisble((AgentLockInfo)((AgentLockInfo)l)) : null)));
        this.allLocks.values().stream().filter(l -> !heldLockAgents.contains(l.getAgentName())).filter(l -> l.getOwner().equals(newUserid)).forEach(l -> this.notifyHeldLockListeners(l.getAgentName(), (AgentLock)(l instanceof AgentLockInfo ? AgentLockInfo.createLoginVisble((AgentLockInfo)((AgentLockInfo)l)) : l)));
    }

    @Override
    public void onAgentLoginUpdate(String oldUserId, String newUserId) {
        this.notifyLockVisibility(oldUserId, newUserId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLevelInternal(String agentName, int level) throws UnauthorizedLevelException {
        Object object = this.listenerUpdatesLock;
        synchronized (object) {
            log.log(Level.FINE, "{0} set level for agent {1} to {2}", new Object[]{this.getAgent().getName(), agentName, level});
            this.agentLevels.put(agentName, level);
        }
        this.notifyLevelListeners(agentName, level);
    }

    @Override
    public List<String> getLockableAgents() {
        ArrayList<String> result = new ArrayList<String>();
        for (AgentInfo a : this.getAgent().getMessagingAccess().getAgentPresenceManager().listConnectedAgents()) {
            AgentInfo.AgentType tp = a.getType();
            if (tp == AgentInfo.AgentType.LISTENER || tp == AgentInfo.AgentType.CONSOLE || tp == AgentInfo.AgentType.LOCK_MANAGER || this.allLocks.get(a.getName()) != null) continue;
            result.add(a.getName());
        }
        return result;
    }

    @Override
    public List<String> getLocallyLockedAgents() {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, AgentLock> e : this.getHeldLocks().entrySet()) {
            if (e.getValue() == null) continue;
            res.add(e.getKey());
        }
        return res;
    }

    @Override
    public List<String> getLockedAgents() {
        String currentUser = this.svc.getUserId();
        return new ArrayList<String>(this.allLocks.values().stream().filter(lock -> lock.getOwner().equals(currentUser)).map(lock -> lock.getAgentName()).collect(Collectors.toSet()));
    }

    @Override
    public List<String> getAllLockedAgents() {
        return new ArrayList<String>(this.allLocks.values().stream().map(lock -> lock.getAgentName()).collect(Collectors.toSet()));
    }

    @Override
    public List<String> getDetachableAgents() {
        return this.getLocallyLockedAgents();
    }

    @Override
    public List<String> getAttachableAgents() {
        ArrayList<String> result = new ArrayList<String>();
        for (AgentLock lock : this.allLocks.values()) {
            if (!lock.getOwner().equals(this.svc.getUserId()) || this.heldLocks.containsKey(lock.getAgentName())) continue;
            result.add(lock.getAgentName());
        }
        return result;
    }

    @Override
    public List<String> getAllWorkerAgents() {
        return this.getAgent().getMessagingAccess().getAgentPresenceManager().listConnectedAgents().stream().filter(i -> i.getType() == AgentInfo.AgentType.WORKER || i.getType() == AgentInfo.AgentType.MCM).map(i -> i.getName()).collect(Collectors.toList());
    }

    @Override
    public Map<String, AgentLock> getLocks() {
        return Collections.unmodifiableMap(this.allLocks);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String validateLock(DictionaryCommand command, CommandRequest request) {
        int commandLevel = command.getLevel();
        Command.CommandType commandType = command.getType();
        if (commandLevel == 0 && commandType == Command.CommandType.QUERY) {
            return null;
        }
        AgentLock lock = request.getLock();
        int level = request.getLevel();
        if (lock == null) {
            return "Command " + command.getCommandName() + " requires a lock on " + this.getAgent().getName() + " subsystem.";
        }
        AgentLock knownLock = this.myCurrentLock;
        String target = this.getAgent().getName();
        String user = lock.getOwner();
        StringBuilder sb = new StringBuilder("User ").append(user).append(" requires a lock on ").append(target);
        sb.append(" at level ").append(commandLevel).append(" to execute ").append(command.getCommandName()).append(". ");
        if (knownLock != null && !knownLock.getOwner().equals(user)) {
            return sb.append("Currently locked by ").append(knownLock.getOwner()).append(".").toString();
        }
        if ("withLock".equals(lock.getToken())) {
            int maxLevel;
            if (this.enforceLevel == 0) {
                return null;
            }
            int n = maxLevel = knownLock == null ? this.getMaxLevel(user, target) : knownLock.getMaxLevel();
            if (maxLevel >= commandLevel) return null;
            sb.append("Maximum level for this user is ").append(maxLevel);
            return sb.append(".").toString();
        } else if (knownLock == null) {
            sb.append("The target is currently unlocked.");
            return sb.append(".").toString();
        } else if (!knownLock.getToken().equals(lock.getToken()) || !knownLock.getAgentName().equals(lock.getAgentName())) {
            sb.append(" Invalid lock was sent with the command: ").append(lock).append(".");
            return sb.append(".").toString();
        } else {
            int maxLevel = knownLock.getMaxLevel();
            switch (this.enforceLevel) {
                case 0: {
                    return null;
                }
                case 1: {
                    if (maxLevel >= commandLevel) return null;
                    sb.append("Maximum level for this user is ").append(maxLevel);
                    return sb.append(".").toString();
                }
                default: {
                    if (maxLevel < commandLevel) {
                        sb.append("Maximum level for this user is ").append(maxLevel);
                        return sb.append(".").toString();
                    }
                    if (level >= commandLevel) return null;
                    sb.append("Maximum level for this user is ").append(maxLevel);
                    sb.append(", but the level set on the subsystem that sent the command was ").append(level);
                    return sb.append(".").toString();
                }
            }
        }
    }
}

